/**************************************************************************//**
 * \file       clSDS_Method_NaviGetWaypointListInfo.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviGetWaypointListInfo_h
#define clSDS_Method_NaviGetWaypointListInfo_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "external/sds2hmi_fi.h"


class clSDS_Method_NaviGetWaypointListInfo : public clServerMethod
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::WaypointListCallbackIF
   , public org::bosch::cm::navigation::NavigationService::RequestWaypointListCallbackIF
   , public org::bosch::cm::navigation::NavigationService::ApplyWaypointListChangeCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::GetMaxWaypointCountCallbackIF
{
   public:
      virtual ~clSDS_Method_NaviGetWaypointListInfo();
      clSDS_Method_NaviGetWaypointListInfo(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> pNaviProxy,
         ::boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> pNaviSDSProxy);

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onWaypointListError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::WaypointListError >& error);
      virtual void onWaypointListUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::WaypointListUpdate >& update);

      virtual void onRequestWaypointListError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestWaypointListError >& error);
      virtual void onRequestWaypointListResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestWaypointListResponse >& response);

      virtual void onApplyWaypointListChangeError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::ApplyWaypointListChangeError >& error);
      virtual void onApplyWaypointListChangeResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::ApplyWaypointListChangeResponse >& response);

      virtual void onGetMaxWaypointCountError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetMaxWaypointCountError >& error);

      virtual void onGetMaxWaypointCountResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetMaxWaypointCountResponse >& response);

      tBool waypointListIsFull() const;
      tVoid vSendGetWaypointListRequest();
      void onSetAddAsWayPoint(tBool bAddAsWayPoint);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      tVoid vSendResult();

      boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> _naviProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _naviSDSProxy;
      size_t _waypointListSize;
      tBool _bWayListRequested;
      tBool _bAddAsWayPoint;
      tU32  _maxWayPointCount;
};


#endif
