/**************************************************************************//**
 * \file       clSDS_Method_NaviGetSearchLocation.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviGetSearchLocation_h
#define clSDS_Method_NaviGetSearchLocation_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "Sds2HmiServer/functions/clSDS_Property_NaviStatus.h"
#include "application/NaviPOICategoryList.h"
#include "external/sds2hmi_fi.h"


class clSDS_Property_NaviStatus;
class NaviPOICategoryList;


class clSDS_Method_NaviGetSearchLocation
   : public clServerMethod
{
   public:
      clSDS_Method_NaviGetSearchLocation(
         ahl_tclBaseOneThreadService* pService,
         clSDS_Property_NaviStatus* pPropertyNaviStatus,
         NaviPOICategoryList* pNaviPOICategoryList);
      virtual ~clSDS_Method_NaviGetSearchLocation();
      void getSearchLocation(sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart&, sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult&);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      clSDS_Property_NaviStatus* _pPropertyNaviStatus;
      NaviPOICategoryList* _pNaviPOICategoryList;
};


#endif
