/**************************************************************************//**
 * \file       clSDS_Method_NaviGetSearchLocation.cpp
 *
 * clSDS_Method_NaviGetSearchLocation method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "clSDS_Method_NaviGetSearchLocation.h"
#include "SdsAdapter_Trace.h"
#include "application/clSDS_ConfigurationFlags.h"

#define FI_S_IMPORT_INTERFACE_FI_TYPES
#include "fi_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_NaviGetSearchLocation.cpp.trc.h"
#endif


#define PARKING_POICATEGORYID 33560432

/**************************************************************************//**
 * Constructor
 ******************************************************************************/
clSDS_Method_NaviGetSearchLocation::clSDS_Method_NaviGetSearchLocation(
   ahl_tclBaseOneThreadService* pService,
   clSDS_Property_NaviStatus* pPropertyNaviStatus,
   NaviPOICategoryList* pNaviPOICategoryList)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVIGETSEARCHLOCATION, pService)
   , _pPropertyNaviStatus(pPropertyNaviStatus)
   , _pNaviPOICategoryList(pNaviPOICategoryList)
{
}


/**************************************************************************//**
 * Destructor
 ******************************************************************************/
clSDS_Method_NaviGetSearchLocation::~clSDS_Method_NaviGetSearchLocation()
{
   _pPropertyNaviStatus = NULL;
}


/***********************************************************************//**
 *
 ***************************************************************************/
tVoid clSDS_Method_NaviGetSearchLocation::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart oMethodStart;
   sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult oResult;
   vGetDataFromAmt(pInMessage, oMethodStart);
   getSearchLocation(oMethodStart, oResult);
   vSendMethodResult(oResult);
}


/***********************************************************************//**
 *
 **************************************************************************/
void clSDS_Method_NaviGetSearchLocation::getSearchLocation(sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodStart& searchLocation,
      sds2hmi_sdsfi_tclMsgNaviGetSearchLocationMethodResult& result)
{
   std::vector<sds2hmi_fi_tcl_HMIElementDescription> ::iterator it;
   it = searchLocation.SearchString.begin();
   //TODO:ATL5COB to re-visit the implementation once the feature clarification is done with Denny

   switch (it->DescriptorTag.enType)
   {
      case sds2hmi_fi_tcl_e8_WordType::FI_EN_POICATEGORY:
      case sds2hmi_fi_tcl_e8_WordType::FI_EN_POIBRAND:
      case sds2hmi_fi_tcl_e8_WordType::FI_EN_POINAME:
      {
         if (_pPropertyNaviStatus->getNaviStatus() == sds2hmi_fi_tcl_e8_NAV_Status::FI_EN_GUIDANCE_ACTIVE)
         {
            if (clSDS_ConfigurationFlags::isPOIExtendedSearchLocation())
            {
               if ((_pNaviPOICategoryList->getPOICategoryId(it->DescriptorValue.szValue)) == (uint)PARKING_POICATEGORYID)
               {
                  result.SearchLocation.enType = sds2hmi_fi_tcl_e8_NAV_LocationType::FI_EN_NEAR_DESTINATION;
               }
               else
               {
                  result.SearchLocation.enType = sds2hmi_fi_tcl_e8_NAV_LocationType::FI_EN_ALONG_ROUTE;
               }
            }
            else
            {
               result.SearchLocation.enType = sds2hmi_fi_tcl_e8_NAV_LocationType::FI_EN_NEAR_DESTINATION;
            }
         }
         else if (_pPropertyNaviStatus->getNaviStatus() == sds2hmi_fi_tcl_e8_NAV_Status::FI_EN_IDLE)
         {
            result.SearchLocation.enType = sds2hmi_fi_tcl_e8_NAV_LocationType::FI_EN_NEARBY;
         }
      }

      break;
      default:
         result.SearchLocation.enType = sds2hmi_fi_tcl_e8_NAV_LocationType::FI_EN_DEFAULT;
         break;
   }
}
