/**************************************************************************//**
 * \file       clSDS_Method_NaviGetHouseNumberRange.cpp
 *
 * clSDS_Method_NaviGetHouseNumberRange method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NaviGetHouseNumberRange.h"
#include "application/clSDS_StringVarList.h"
#include "external/sds2hmi_fi.h"


using namespace org::bosch::cm::navigation::NavigationService;


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_NaviGetHouseNumberRange::~clSDS_Method_NaviGetHouseNumberRange()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NaviGetHouseNumberRange::clSDS_Method_NaviGetHouseNumberRange(
   ahl_tclBaseOneThreadService* pService,
   ::boost::shared_ptr<NavigationServiceProxy> naviProxy)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVIGETHOUSENUMBERRANGE, pService)
   , _navigationProxy(naviProxy)
{
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviGetHouseNumberRange::onSdsGetHouseNumberPatternError(const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< SdsGetHouseNumberPatternError >& /*error*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviGetHouseNumberRange::onSdsGetHouseNumberPatternResponse(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< SdsGetHouseNumberPatternResponse >& response)
{
   _oHouseNumberRange.minHouseNr = response->getMinHouseNumber();
   _oHouseNumberRange.maxHouseNr = response->getMaxHouseNumber();
   _oHouseNumberRange.patternlist = response->getPatterns();
   vGetHouseNumberRangeFromNavi(_oHouseNumberRange);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_NaviGetHouseNumberRange::vMethodStart(amt_tclServiceData* /*pInMessage*/)
{
   _navigationProxy->sendSdsGetHouseNumberPatternRequest(*this);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_NaviGetHouseNumberRange::vGetHouseNumberRangeFromNavi(stHouseNumberRange& houseNrRange)
{
   sds2hmi_sdsfi_tclMsgNaviGetHouseNumberRangeMethodResult oResult;
   oResult.sFirst.bSet(houseNrRange.minHouseNr.c_str(), sds2hmi_fi_tclString::FI_EN_UTF8);
   oResult.sLast.bSet(houseNrRange.maxHouseNr.c_str(), sds2hmi_fi_tclString::FI_EN_UTF8);
   std::vector< std::string> ::iterator it;
   for (it = houseNrRange.patternlist.begin(); it != houseNrRange.patternlist.end(); it++)
   {
      sds2hmi_fi_tclString patternstring;
      patternstring.bSet(it->c_str(), sds2hmi_fi_tclString::FI_EN_UTF8);
      oResult.PatternList.push_back(patternstring);
   }
   oResult.bResult = !(houseNrRange.minHouseNr == "" || houseNrRange.maxHouseNr == "");
   vSendMethodResult(oResult);
}
