/**************************************************************************//**
 * \file       clSDS_Method_NaviGetCurrentDestination.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviGetCurrentDestination_h
#define clSDS_Method_NaviGetCurrentDestination_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"

class GuiService;


class clSDS_Method_NaviGetCurrentDestination
   : public clServerMethod
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsCallbackIF
   , public org::bosch::cm::navigation::NavigationService::SetLocationWithSdsInputCallbackIF
   , public org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationCallbackIF
{
   public:
      virtual ~clSDS_Method_NaviGetCurrentDestination();
      clSDS_Method_NaviGetCurrentDestination(ahl_tclBaseOneThreadService* pService,
                                             ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> naviProxy,
                                             GuiService* pGuiService);

      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      // SdsAddressWithOptionsCallbackIF
      virtual void onSdsAddressWithOptionsUpdate(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsUpdate >& update);
      virtual void onSdsAddressWithOptionsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SdsAddressWithOptionsError >& error);
      // SetLocationWithSdsInputCallbackIF
      virtual void onSetLocationWithSdsInputError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithSdsInputError >& error);
      virtual void onSetLocationWithSdsInputResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::SetLocationWithSdsInputResponse >& response);
      //RequestDetailsForSelectedLocation
      virtual void onRequestDetailsForSelectedLocationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationError >& error);
      virtual void onRequestDetailsForSelectedLocationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::RequestDetailsForSelectedLocationResponse >& response);
   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      boost::shared_ptr<org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> _navigationProxy;
      GuiService* _pGuiService;
      tVoid vHandlehouseNum();
      std::string housenum;
      std::string szAddressString;
      sds2hmi_fi_tcl_e8_NAV_LocationType _locationType;
      std::vector< sds2hmi_fi_tcl_LocationDescriptor > _locationDescriptors;
      bool isPOISearchRequest() const;
      void resetResultValues();
      sds2hmi_fi_tcl_e16_SelectionCriterionType selectionType;
      sds2hmi_fi_tcl_e8_LocationDescriptionDataType DataType;
      sds2hmi_sdsfi_tclMsgNaviGetCurrentDestinationMethodResult result;
      sds2hmi_fi_tcl_LocationDescriptor tLocationDescriptor;
      //sds2hmi_fi_tcl_StringPosition* str;
};


#endif
