/**************************************************************************//**
 * \file       clSDS_Method_NaviGetCurrentDestination.cpp
 *
 * clSDS_Method_NaviGetCurrentDestination method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NaviGetCurrentDestination.h"
#include "SdsAdapter_Trace.h"
#include "application/GuiService.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_NaviGetCurrentDestination.cpp.trc.h"
#endif


using namespace org::bosch::cm::navigation::NavigationService;
using namespace sds_gui_fi::SdsGuiService;

#define housenotag "houseno:"

/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_NaviGetCurrentDestination::~clSDS_Method_NaviGetCurrentDestination()
{
   _pGuiService = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NaviGetCurrentDestination::clSDS_Method_NaviGetCurrentDestination(ahl_tclBaseOneThreadService* pService, ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy> naviProxy, GuiService* pGuiService)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVIGETCURRENTDESTINATION, pService)
   , _navigationProxy(naviProxy)
   , _pGuiService(pGuiService)

{
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_NaviGetCurrentDestination::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
      const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _navigationProxy)
   {
      _navigationProxy->sendSdsAddressWithOptionsDeregisterAll();
   }
}


void clSDS_Method_NaviGetCurrentDestination::onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy,
      const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (proxy == _navigationProxy)
   {
      _navigationProxy->sendSdsAddressWithOptionsRegister(*this);
   }
}


void clSDS_Method_NaviGetCurrentDestination::onSdsAddressWithOptionsError(const ::boost::shared_ptr<NavigationServiceProxy>& /*proxy*/,
      const ::boost::shared_ptr< SdsAddressWithOptionsError >& /*error*/)
{
   vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_DESTINATIONVALUENOTRESOLVED);
}


void clSDS_Method_NaviGetCurrentDestination::onSdsAddressWithOptionsUpdate(const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< SdsAddressWithOptionsUpdate >& /*oSdsAddressWithOptionsUpdate*/)
{
   resetResultValues();
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_NaviGetCurrentDestination::vMethodStart(amt_tclServiceData* /*pInMessage*/)
{
   ETG_TRACE_USR1(("clSDS_Method_NaviGetCurrentDestination, vMethodStart()"));
   vHandlehouseNum();
}


void clSDS_Method_NaviGetCurrentDestination::onSetLocationWithSdsInputResponse(const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< SetLocationWithSdsInputResponse >& /*response*/)
{
   if (!((isPOISearchRequest() && (_locationType.enType == sds2hmi_fi_tcl_e8_NAV_LocationType::FI_EN_DEFAULT))))
   {
      _navigationProxy->sendRequestDetailsForSelectedLocationRequest(*this);
   }
}


void clSDS_Method_NaviGetCurrentDestination::onSetLocationWithSdsInputError(const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
      const ::boost::shared_ptr< SetLocationWithSdsInputError >& /*error*/)
{
   vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
}


void clSDS_Method_NaviGetCurrentDestination::vHandlehouseNum()
{
   resetResultValues();
   ETG_TRACE_USR1(("vHandlehouseNum"));
   std::vector< SDSAddressElement> verifiedSdsAddress;
   SDSAddressOptions sdsAddressOptions;
   std::vector< SDSAddressElementType > sdsAddressElementType;
   if (_navigationProxy->hasSdsAddressWithOptions())
   {
      verifiedSdsAddress = _navigationProxy->getSdsAddressWithOptions().getAddress();
      sdsAddressOptions = _navigationProxy->getSdsAddressWithOptions().getAddressOptions();
      sdsAddressElementType = _navigationProxy->getSdsAddressWithOptions().getAddressElementType();
   }
   ::std::vector<SDSAddressElement>::iterator it;
   for (it = verifiedSdsAddress.begin(); it != verifiedSdsAddress.end(); ++it)
   {
      if (it->getAddressElementType() == SDSAddressElementType__SDS_ADDRESS_ELEMENT_TYPE_HOUSENUMBER)
      {
         szAddressString = housenotag;
         szAddressString += it->getData();
      }
   }
   _navigationProxy->sendSetLocationWithSdsInputRequest(*this);
   sds2hmi_fi_tcl_StringPosition* Ptr_StrPos = OSAL_NULL;
   Ptr_StrPos = OSAL_NEW sds2hmi_fi_tcl_StringPosition();
   if (OSAL_NULL != Ptr_StrPos)
   {
      Ptr_StrPos->String.bSet(szAddressString.c_str(), sds2hmi_fi_tclString::FI_EN_UTF8);
   }
   tLocationDescriptor.poDataData = (fi_tclTypeBase*)(Ptr_StrPos);
   result.nNumberOfElements = 1;
   tLocationDescriptor.DataType.enType = sds2hmi_fi_tcl_e8_LocationDescriptionDataType::FI_EN_T_STRINGPOSITION;
   tLocationDescriptor.SelectionCriterion.enType = sds2hmi_fi_tcl_e16_SelectionCriterionType::FI_EN_HOUSENUMBER;
   result.tLocationDescription.Descriptors.push_back(tLocationDescriptor);
   ETG_TRACE_USR1(("vHandlehouseNum, %s", szAddressString.c_str()));
   vSendMethodResult(result);
}


bool clSDS_Method_NaviGetCurrentDestination::isPOISearchRequest() const
{
   if (_locationDescriptors.size() > 0)
   {
      return (_locationDescriptors[0].SelectionCriterion.enType == sds2hmi_fi_tcl_e16_SelectionCriterionType::FI_EN_OSDE_POI);
   }
   return FALSE;
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_NaviGetCurrentDestination::onRequestDetailsForSelectedLocationError(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< RequestDetailsForSelectedLocationError >& /*error*/)
{
}


void clSDS_Method_NaviGetCurrentDestination::resetResultValues()
{
   result.tLocationDescription.Descriptors.clear();
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_NaviGetCurrentDestination::onRequestDetailsForSelectedLocationResponse(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< RequestDetailsForSelectedLocationResponse >& /*response*/)
{
   if (_pGuiService)
   {
      _pGuiService->sendEventSignal(Event__SPEECH_DIALOG_GADGET_ACTIVATION);
   }
}
