/**************************************************************************//**
 * \file       clSDS_Method_NaviCancelDistanceDetour.h
 *
 * clSDS_Method_NaviCancelDistanceDetour  class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NaviCancelDistanceDetour_h
#define clSDS_Method_NaviCancelDistanceDetour_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "external/sds2hmi_fi.h"


class clSDS_Method_NaviCancelDistanceDetour
   : public clServerMethod
   , public org::bosch::cm::navigation::NavigationService::CancelJamAheadCallbackIF
{
   public:
      clSDS_Method_NaviCancelDistanceDetour(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy);

      virtual ~clSDS_Method_NaviCancelDistanceDetour();

      virtual void onCancelJamAheadError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::CancelJamAheadError >& error);

      virtual void onCancelJamAheadResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::CancelJamAheadResponse >& response);

   protected:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);

   private:
      ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _pNaviProxy;
};


#endif
