/**************************************************************************//**
 * \file       clSDS_Method_NaviCancelDistanceDetour.cpp
 *
 * clSDS_Method_NaviCancelDistanceDetour  class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_NaviCancelDistanceDetour.h"


using namespace org::bosch::cm::navigation::NavigationService;


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_NaviCancelDistanceDetour::clSDS_Method_NaviCancelDistanceDetour
(ahl_tclBaseOneThreadService* pService,
 ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > naviProxy)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_NAVICANCELDISTANCEDETOUR, pService)
   , _pNaviProxy(naviProxy)
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/

clSDS_Method_NaviCancelDistanceDetour::~clSDS_Method_NaviCancelDistanceDetour()
{
}


/***********************************************************************//**
 *
 ***************************************************************************/
tVoid clSDS_Method_NaviCancelDistanceDetour::vMethodStart(amt_tclServiceData* pInMsg)
{
   if (_pNaviProxy != NULL)
   {
      _pNaviProxy->sendCancelJamAheadRequest(*this);
      vSendMethodResult();
   }
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_NaviCancelDistanceDetour::onCancelJamAheadError(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::CancelJamAheadError >& /*error*/)
{
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_NaviCancelDistanceDetour::onCancelJamAheadResponse(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::CancelJamAheadResponse >& /*response*/)
{
}
