/**************************************************************************//**
 * \file       clSDS_Method_NavDataUnRegisterDirectNDSUse.h
 *
 * clSDS_Method_NavDataUnRegisterDirectNDSUse method implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NavDataUnRegisterDirectNDSUse_h
#define clSDS_Method_NavDataUnRegisterDirectNDSUse_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceConst.h"

#include "application/NaviDataSetDeRegistrationObserver.h"

class clSDS_Method_NavDataUnRegisterDirectNDSUse
   : public clServerMethod
   , public org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserDeregistrationCallbackIF
{
   public:
      clSDS_Method_NavDataUnRegisterDirectNDSUse(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> naviSDSProxy);
      virtual ~clSDS_Method_NavDataUnRegisterDirectNDSUse();

      void onSdsDatasetUserDeregistrationError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserDeregistrationError >& error);
      void onSdsDatasetUserDeregistrationResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserDeregistrationResponse >& response);

      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);

      void addDataSetDeRegistrationObserver(NaviDataSetDeRegistrationObserver* pObserver);

   private:
      boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy> _naviSDSProxy;
      std::vector<NaviDataSetDeRegistrationObserver*> _dataSetDeRegistrationObservers;
      void notifydataSetDeRegistrationObservers();
};


#endif
