/**************************************************************************//**
 * \file       clSDS_Method_NavDataGetStringAndPhoneme.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NavDataGetStringAndPhoneme_h
#define clSDS_Method_NavDataGetStringAndPhoneme_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "application/NdsStringObserver.h"
#include "application/NdsPhonemeObserver.h"


class NdsStringRequestor;
class NdsPhonemeRequestor;


class clSDS_Method_NavDataGetStringAndPhoneme
   : public clServerMethod
   , public NdsStringObserver
   , public NdsPhonemeObserver
{
   public:
      virtual ~clSDS_Method_NavDataGetStringAndPhoneme();
      clSDS_Method_NavDataGetStringAndPhoneme(
         ahl_tclBaseOneThreadService* pService,
         NdsStringRequestor* pNdsStringRequestor,
         NdsPhonemeRequestor* pNdsPhonemeRequestor);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      void getStringList();
      void getPhonemeList();
      void setStringOrPhonemeListForNdsId(
         std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& ndsStringData,
         std::vector<sds2hmi_fi_tcl_StringAndPhoneme>& sdsStringData,
         sds2hmi_fi_tcl_e8_NDSFeatureType ndsFeatureType,
         bool isStringRequested);

      void setCombinedListForNdsId(
         std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& ndsStringList,
         std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings >& ndsPhonemeList,
         std::vector<sds2hmi_fi_tcl_StringAndPhoneme>& sdsStringPhonemeData,
         sds2hmi_fi_tcl_e8_NDSFeatureType ndsFeatureType);

      void setPhonemeListForNdsId(
         sds2hmi_fi_tcl_StringAndPhoneme& phonemeObject,
         std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > ndsPhonemeList);

      void ndsNamesUpdated();
      void ndsPhonemesUpdated();
      sds2hmi_fi_tcl_e8_SDSDestinationType setDestinationType(org::bosch::cm::navigation::NavigationSDSService::AddressElementType addressElementType);

      std::vector<sds2hmi_fi_tcl_NDSID> _requestedNDSIds;
      NdsStringRequestor* _pNdsStringRequestor;
      NdsPhonemeRequestor* _pNdsPhonemeRequestor;
      std::vector<sds2hmi_fi_tcl_NDSLanguageID> _ndsLanguageId;
      bool _isStringRequested;
      bool _isPhonemeRequested;
};


#endif
