/**************************************************************************//**
 * \file       clSDS_Method_NavDataGetCountryStateList.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_NavDataGetCountryStateList_h
#define clSDS_Method_NavDataGetCountryStateList_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"


class clSDS_Method_NavDataGetCountryStateList
   : public clServerMethod
   , public org::bosch::cm::navigation::NavigationSDSService::GetIdListOfCountryAndSubCountryCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsCallbackIF
{
   public:
      virtual ~clSDS_Method_NavDataGetCountryStateList();
      clSDS_Method_NavDataGetCountryStateList(
         ahl_tclBaseOneThreadService* pService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > pSds2NaviProxy);

      virtual void onGetIdListOfCountryAndSubCountryError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetIdListOfCountryAndSubCountryError >& error);
      virtual void onGetIdListOfCountryAndSubCountryResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetIdListOfCountryAndSubCountryResponse >& response);

      virtual void onGetPhonemesForNDSIdsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsError >& error);
      virtual void onGetPhonemesForNDSIdsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsResponse >& response);

      virtual void onGetNamesForNDSIdsError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsError >& error);
      virtual void onGetNamesForNDSIdsResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsResponse >& response);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      void getPhonemesForIds(std::vector< org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId > ndsIds);
      void getNamesForIds(std::vector< org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId > ndsIds);
      void sendCountryStatePhonemesAndNames();
      void setCountryPhonemes(
         std::vector< ::std::string > countryPhonemeList,
         sds2hmi_fi_tcl_CountryPhoneme& countryPhoneme);
      void setCountryNames(
         std::vector< ::std::string > countryPhonemeList,
         sds2hmi_fi_tcl_CountryPhoneme& countryPhoneme);
      void setStatePhonemesAndNames(
         sds2hmi_fi_tcl_CountryPhoneme& CountryPhoneme,
         tU32 countryNdsId,
         tU16 updateRegionId);
      void requestStatePhonemes(org::bosch::cm::navigation::NavigationSDSService::SubCountryIds subCountryIds);
      void requestStateNames(org::bosch::cm::navigation::NavigationSDSService::SubCountryIds subCountryIds);
      void updateCountrySubCountryPhonemes(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > stateList);
      void updateCountrySubCountryNames(std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > stateList);
      void resetDataMembers();

      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _sds2NaviProxy;
      sds2hmi_fi_tcl_NDSLanguageID _ndsLanguageId;

      std::vector< org::bosch::cm::navigation::NavigationSDSService::SubCountryIds > _stateIdList;
      std::vector< org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId > _countryIdList;
      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _countryPhonemeList;
      std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > _countryNameList;
      tU32 _requestedsubCountryNdsIdSize;
      tU32 _requestedsubCountryNdsIdforNameSize;

      enum enNDSRequestor
      {
         NDSID_UNKNWON,
         NDSID_FOR_COUNTRY,
         NDSID_FOR_STATE
      };

      struct CountrySubCountryPhonemes
      {
         tU32 countryNdsId;
         tU16 updateRegionId;
         std::vector< org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings > namedObjectIdStrings;
      };

      std::vector < CountrySubCountryPhonemes > _countrySubCountryPhonemeList;
      std::vector < CountrySubCountryPhonemes > _countrySubCountryNameList;

      enNDSRequestor _ndsRequestor;
      enNDSRequestor _ndsNameRequestor;
};


#endif
