/**************************************************************************//**
 * \file       clSDS_Method_InfoShowMenu.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_InfoShowMenu_h
#define clSDS_Method_InfoShowMenu_h

#include "org/bosch/cm/navigation/NavigationSDSServiceProxy.h"
#include "org/bosch/cm/navigation/NavigationServiceProxy.h"
#include "Sds2HmiServer/framework/clServerMethod.h"
#include "application/GuiService.h"
#include "external/sds2hmi_fi.h"

//#include "HVACPIVI_MAIN_FIProxy.h"
//#include "hvacpivi_main_fi_types.h"

class TemperatureUnitObserver;
class InfoShowMenuHandler;


class clSDS_Method_InfoShowMenu
   : public clServerMethod
   , public asf::core::ServiceAvailableIF
   , public org::bosch::cm::navigation::NavigationService::ShowWhereAmIScreenCallbackIF
   , public org::bosch::cm::navigation::NavigationService::ShowAdjustCurrentLocationScreenCallbackIF
   , public org::bosch::cm::navigation::NavigationSDSService::SdsShowReachableAreaMapCallbackIF
//, public HVACPIVI_MAIN_FI::ClimateControlSettingCallbackIF
//, public HVACPIVI_MAIN_FI::TemperatureSettingCallbackIF
//, public HVACPIVI_MAIN_FI::TemperatureUnitStatusCallbackIF
{
   public:
      virtual ~clSDS_Method_InfoShowMenu();
      clSDS_Method_InfoShowMenu(
         ahl_tclBaseOneThreadService* pService,
         GuiService& guiService,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > pSds2NaviProxy,
         ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > naviSDSProxy,
         InfoShowMenuHandler* _pInfoShowMenuHandler);
      //boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy> hvacPIVIProxy

      virtual void onShowWhereAmIScreenError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::ShowWhereAmIScreenError >& error);
      virtual void onShowWhereAmIScreenResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::ShowWhereAmIScreenResponse >& response);

      virtual void onShowAdjustCurrentLocationScreenError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::ShowAdjustCurrentLocationScreenError >& error);

      virtual void onShowAdjustCurrentLocationScreenResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationService::ShowAdjustCurrentLocationScreenResponse >& response);

      virtual void onSdsShowReachableAreaMapResponse(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy>& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsShowReachableAreaMapResponse >& response);

      virtual void onSdsShowReachableAreaMapError(
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& proxy,
         const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsShowReachableAreaMapError >& error);

      /*virtual void onClimateControlSettingError(
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::ClimateControlSettingError >& error);*/

      /*virtual void onClimateControlSettingResult(
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::ClimateControlSettingResult >& result);*/

      /*virtual void onTemperatureSettingError(
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::TemperatureSettingError >& error);

      virtual void onTemperatureSettingResult(
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::TemperatureSettingResult >& result);

      virtual void onTemperatureUnitStatusError(
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::TemperatureUnitStatusError >& error);

      virtual void onTemperatureUnitStatusStatus(
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& proxy,
         const ::boost::shared_ptr< HVACPIVI_MAIN_FI::TemperatureUnitStatusStatus >& status);*/

      virtual void onAvailable(
         const ::boost::shared_ptr< asf::core::Proxy >& proxy,
         const asf::core::ServiceStateChange& stateChange) ;
      virtual void onUnavailable(
         const ::boost::shared_ptr< asf::core::Proxy >& proxy,
         const asf::core::ServiceStateChange& stateChange) ;

      void addTemperatureUnitObserver(TemperatureUnitObserver* pObserver);

   private:

      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      bool bShowInfoScreen(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage);
      bool bShowNaviInfoScreen(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage);
      bool bShowSxmInfoScreen(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage)const;
      bool bShowGeneralInfoScreen(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage);
      void handleTemperatureSetting(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage);
      void updateTemperatureUnit();
      void notifyTemperatureUnitObservers(bool isCelsiusON);

      GuiService& _guiService;
      InfoShowMenuHandler* _pInfoShowMenuHandler;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationService::NavigationServiceProxy > _sds2NaviProxy;
      boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > _sds2NaviSDSProxy;
      //boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy> _hvacPIVIProxy;
      uint8 _tempUnitState;
      std::vector<TemperatureUnitObserver*> _temperatureUnitObservers;
};


#endif
