/**************************************************************************//**
 * \file       clSDS_Method_InfoShowMenu.cpp
 *
 * clSDS_Method_InfoShowMenu method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_InfoShowMenu.h"
#include "Sds2HmiServer/functions/clSDS_Property_NaviStatus.h"
#include "application/clSDS_ConfigurationFlags.h"
#include "application/TemperatureUnitObserver.h"
#include "application/InfoShowMenuHandler.h"
#include "application/StringUtils.h"
#include "SdsAdapter_Trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_InfoShowMenu.cpp.trc.h"
#endif


using namespace org::bosch::cm::navigation::NavigationService;
using namespace sds_gui_fi::SdsGuiService;
//using namespace hvacpivi_main_fi_types;
using namespace sxm_main_fi_types;
//using namespace HVACPIVI_MAIN_FI;


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_InfoShowMenu::~clSDS_Method_InfoShowMenu()
{
   _pInfoShowMenuHandler = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_InfoShowMenu::clSDS_Method_InfoShowMenu(
   ahl_tclBaseOneThreadService* pService, GuiService& guiService,
   ::boost::shared_ptr< NavigationServiceProxy > pSds2NaviProxy,
   ::boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy > naviSDSProxy,
   InfoShowMenuHandler* pInfoShowMenuHandler)
//boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy> hvacPIVIProxy
   : clServerMethod(SDS2HMI_SDSFI_C_U16_INFOSHOWMENU, pService)
   , _guiService(guiService)
   , _pInfoShowMenuHandler(pInfoShowMenuHandler)
   , _sds2NaviProxy(pSds2NaviProxy)
   , _sds2NaviSDSProxy(naviSDSProxy)
     //, _hvacPIVIProxy(hvacPIVIProxy)
   , _tempUnitState(0)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_InfoShowMenu::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);

   if (bShowInfoScreen(oMessage))
   {
      vSendMethodResult();
   }
   else
   {
      vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
   }
}


/**************************************************************************//**
*
******************************************************************************/
bool clSDS_Method_InfoShowMenu::bShowInfoScreen(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage)
{
   ETG_TRACE_USR1(("MenuType %d", oMessage.eMenu.enType));

   if (bShowNaviInfoScreen(oMessage))
   {
      return true;
   }
   if (bShowSxmInfoScreen(oMessage))
   {
      return true;
   }
   if (bShowGeneralInfoScreen(oMessage))
   {
      return true;
   }
   return false;
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_InfoShowMenu::onShowWhereAmIScreenResponse(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< ShowWhereAmIScreenResponse >&  /*response*/)
{
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_InfoShowMenu::onShowWhereAmIScreenError(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< ShowWhereAmIScreenError >& /*error*/)
{
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_InfoShowMenu::onShowAdjustCurrentLocationScreenResponse(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< ShowAdjustCurrentLocationScreenResponse >& /*response*/)
{
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_InfoShowMenu::onShowAdjustCurrentLocationScreenError(
   const ::boost::shared_ptr< NavigationServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< ShowAdjustCurrentLocationScreenError >& /*error*/)
{
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_InfoShowMenu::onSdsShowReachableAreaMapResponse(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsShowReachableAreaMapResponse >& /*response*/)
{
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_InfoShowMenu::onSdsShowReachableAreaMapError(
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy >& /*proxy*/,
   const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsShowReachableAreaMapError >& /*error*/)
{
}


/***********************************************************************//**
*
***************************************************************************/
bool clSDS_Method_InfoShowMenu::bShowNaviInfoScreen(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage)
{
   switch (oMessage.eMenu.enType)
   {
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_TRAFFIC:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_INFO_TRAFFIC);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_WEATHER_MAP:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_INFO_WEATHER_REPORT_MAP);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_CURRENT_LOCATION:
         _sds2NaviProxy->sendShowWhereAmIScreenRequest(*this);
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_WHERE_AM_I);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_ADJUST_LOCATION:
         _sds2NaviProxy->sendShowAdjustCurrentLocationScreenRequest(*this);
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_NAVI_SOURCECHANGE_ACTIVE);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_EVE_DRIVING_RANGE:
      {
         if (_sds2NaviSDSProxy->isAvailable())
         {
            _sds2NaviSDSProxy->sendSdsShowReachableAreaMapRequest(*this, org::bosch::cm::navigation::NavigationSDSService::LocationType__NEAR_CURRENT_LOCATION);
         }
         return true;
      }

      default:
         return false;
   }
}


/***********************************************************************//**
 *
 ***************************************************************************/
bool clSDS_Method_InfoShowMenu::bShowSxmInfoScreen(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage)const
{
   if (_pInfoShowMenuHandler)
   {
      return _pInfoShowMenuHandler->getSxmInfoScreenStatus(oMessage.eMenu.enType);
   }
   return false;
}


/***********************************************************************//**
*
***************************************************************************/
bool clSDS_Method_InfoShowMenu::bShowGeneralInfoScreen(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage)
{
   switch (oMessage.eMenu.enType)
   {
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_TCU_VOICE_MENU:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_TCU_VOICE_MENU);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_INFO_FEED:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_TCU_FAVORITE_FEEDS);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_EVE_ENERGY_USAGE:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_EVE_ENERGY_USAGE);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_MAINTENANCE:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_MAINTENANCE);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_ENERGY_FLOW:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_ENERGY_FLOW);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_FUEL_ECONOMY:
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_FUEL_ECONOMY);
         return true;
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_CLIMATE_CONTROL:
      {
         _guiService.sendEventSignal(Event__SPEECH_DIALOG_SHOW_CLIMATE_CONTROL);
         /*if (_hvacPIVIProxy->isAvailable())
         {
            _hvacPIVIProxy->sendClimateControlSettingStart(*this, (oMessage.Param == "ON" ? true : false)) ;
         }
         return true;*/
      }
      case sds2hmi_fi_tcl_e8_Info_Menu::FI_EN_INFO_SET_TEMPERATURE:
      {
         handleTemperatureSetting(oMessage);
         return true;
      }
      default:
         return false;
   }
}


/***********************************************************************//**
*
***************************************************************************/
void clSDS_Method_InfoShowMenu::handleTemperatureSetting(const sds2hmi_sdsfi_tclMsgInfoShowMenuMethodStart& oMessage)
{
   /*if (_hvacPIVIProxy->isAvailable())
   {
      if ((_tempUnitState == T_e8_HvacPiviTemperatureUnitStatus__CENTIGRADEON) || (_tempUnitState == T_e8_HvacPiviTemperatureUnitStatus__CENTIGRADEOFF))
      {
         _hvacPIVIProxy->sendTemperatureSettingStart(*this, (strtof((oMessage.Param), 0)), T_e8_HvacPiviTemperatureUnitStatus__CENTIGRADEON);
      }
      else
      {
         _hvacPIVIProxy->sendTemperatureSettingStart(*this, (strtof((oMessage.Param), 0)), T_e8_HvacPiviTemperatureUnitStatus__FAHRENHEITON);
      }
   }*/
}


/***********************************************************************//**
*
***************************************************************************/
//void clSDS_Method_InfoShowMenu::onClimateControlSettingError(const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& /*proxy*/,
//const ::boost::shared_ptr< HVACPIVI_MAIN_FI::ClimateControlSettingError >& /*error*/)
//{
//}


/***********************************************************************//**
*
***************************************************************************/
//void clSDS_Method_InfoShowMenu::onClimateControlSettingResult(const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& /*proxy*/,
//const ::boost::shared_ptr< HVACPIVI_MAIN_FI::ClimateControlSettingResult >& /*result*/)
//{
//}


/***********************************************************************//**
*
***************************************************************************/
//void clSDS_Method_InfoShowMenu::onTemperatureSettingError(const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& /*proxy*/,
//const ::boost::shared_ptr< HVACPIVI_MAIN_FI::TemperatureSettingError >& /*error*/)
//{
//}


/***********************************************************************//**
*
***************************************************************************/
//void clSDS_Method_InfoShowMenu::onTemperatureSettingResult(const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& /*proxy*/,
//const ::boost::shared_ptr< HVACPIVI_MAIN_FI::TemperatureSettingResult >& /*result*/)
//{
//}


/**************************************************************************//**
 *
 ******************************************************************************/
//void clSDS_Method_InfoShowMenu::onTemperatureUnitStatusError(
//const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& /*proxy*/,
//const ::boost::shared_ptr< HVACPIVI_MAIN_FI::TemperatureUnitStatusError >& /*error*/)
//{
//}


/**************************************************************************//**
 *
 ******************************************************************************/
//void clSDS_Method_InfoShowMenu::onTemperatureUnitStatusStatus(
//const ::boost::shared_ptr< HVACPIVI_MAIN_FI::HVACPIVI_MAIN_FIProxy >& /*proxy*/,
//const ::boost::shared_ptr< HVACPIVI_MAIN_FI::TemperatureUnitStatusStatus >& status)*///
//{
//if (status->hasU8TemperatureUnitStatus())
//{
//_tempUnitState = status->getU8TemperatureUnitStatus();
// updateTemperatureUnit();
//}
//}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_InfoShowMenu::updateTemperatureUnit()
{
   /*switch (_tempUnitState)
   {
      case T_e8_HvacPiviTemperatureUnitStatus__CENTIGRADEOFF:
      case T_e8_HvacPiviTemperatureUnitStatus__CENTIGRADEON:
         notifyTemperatureUnitObservers(true);
         break;
      case T_e8_HvacPiviTemperatureUnitStatus__FAHRENHEITON:
      case T_e8_HvacPiviTemperatureUnitStatus__FAHRENHEITOFF:
         notifyTemperatureUnitObservers(false);
         break;
      default:
         break;
   }*/
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_InfoShowMenu::onAvailable(
   const ::boost::shared_ptr< asf::core::Proxy >& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   /*if (proxy == _hvacPIVIProxy)
   {
      _hvacPIVIProxy->sendTemperatureUnitStatusUpReg(*this);
   }*/
}


/**************************************************************************//**
 *
 ******************************************************************************/
void clSDS_Method_InfoShowMenu::onUnavailable(
   const ::boost::shared_ptr< asf::core::Proxy >& proxy,
   const asf::core::ServiceStateChange& /*stateChange*/)
{
   /*if (proxy == _hvacPIVIProxy)
   {
      _hvacPIVIProxy->sendTemperatureUnitStatusRelUpRegAll();
   }*/
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_InfoShowMenu::addTemperatureUnitObserver(TemperatureUnitObserver* pObserver)
{
   if (pObserver != NULL)
   {
      _temperatureUnitObservers.push_back(pObserver);
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clSDS_Method_InfoShowMenu::notifyTemperatureUnitObservers(bool isCelsiusON)
{
   std::vector<TemperatureUnitObserver*>::iterator it = _temperatureUnitObservers.begin();

   while (it != _temperatureUnitObservers.end())
   {
      if (*it != NULL)
      {
         (*it)->hvacTemperatureUnitUpdated(isCelsiusON);
      }
      ++it;
   }
}
