/**************************************************************************//**
 * \file       clSDS_Method_ContactsGetAmbiguityList.h
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#ifndef clSDS_Method_ContactsGetAmbiguityList_h
#define clSDS_Method_ContactsGetAmbiguityList_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "MOST_PhonBk_FIProxy.h"


class clSDS_AmbigContactList;
class clSDS_AmbigNumberList;


class clSDS_Method_ContactsGetAmbiguityList
   : public clServerMethod
   , public asf::core::ServiceAvailableIF
   , public MOST_PhonBk_FI::GetContactDetailsExtendedCallbackIF
   , public MOST_PhonBk_FI::PreferredPhoneBookSortOrderCallbackIF
{
   public:
      clSDS_Method_ContactsGetAmbiguityList(ahl_tclBaseOneThreadService* pService
                                            , ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phoneBookProxy
                                            , clSDS_AmbigContactList* ambigContactList
                                            , clSDS_AmbigNumberList* ambigNumberList);
      virtual ~clSDS_Method_ContactsGetAmbiguityList();

      virtual void vMethodStart(amt_tclServiceData* pInMsg);

   private:

      void resolveAmbiguity();

      void onAvailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(
         const boost::shared_ptr<asf::core::Proxy>& proxy,
         const asf::core::ServiceStateChange& stateChange);

      virtual void onGetContactDetailsExtendedError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedError >& error);

      virtual void onGetContactDetailsExtendedResult(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::GetContactDetailsExtendedResult >& result);

      virtual void onPreferredPhoneBookSortOrderError(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::PreferredPhoneBookSortOrderError >& error);
      virtual void onPreferredPhoneBookSortOrderStatus(
         const ::boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy >& proxy,
         const ::boost::shared_ptr< MOST_PhonBk_FI::PreferredPhoneBookSortOrderStatus >& status);

      void setResultEntriesAndType(tU32 contactID, const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& contactDetails, sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& result);
      void setResultType(sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& result);

      void setAmbigContacts(const std::vector<most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended>& resultEntries);
      void setAmbigNumbers(const std::vector< sds2hmi_fi_tcl_CON_AmbiguityResultEntry >& resultEntries);
      void addNewContact(std::vector<std::pair <std::string, unsigned int> >& contactNumberDetails, std::pair <std::string, unsigned int>& contactNumber);

      std::string getContactName(const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& contactDetails) const;

      void extractResultEntriesByAllPhoneNumberType(tU32 contactID, const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& contactDetails, sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& result) const;
      void extractAvailablePhoneNumberTypes(tU32 contactID,
                                            const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& contactDetails,
                                            most_PhonBk_fi_types_Extended::T_e8_PhonBkNumberType phoneBkFiType,
                                            sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& result,
                                            const std::string displayString) const;
      void extractResultEntryByPhoneNumberType(tU32 contactID,
            const ::most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended& contactDetails,
            most_PhonBk_fi_types_Extended::T_e8_PhonBkNumberType phoneBkFiType,
            sds2hmi_sdsfi_tclMsgContactsGetAmbiguityListMethodResult& result) const;
      boost::shared_ptr< MOST_PhonBk_FI::MOST_PhonBk_FIProxy> _phoneBookProxy;
      clSDS_AmbigContactList* _pAmbigContactList;
      clSDS_AmbigNumberList* _pAmbigNumberList;
      sds2hmi_fi_tcl_e8_PHN_NumberType _locationType;
      bool _requireAllLocationIfNoExactMatch;
      std::vector<tU32> _contactIDList;
      std::vector<most_PhonBk_fi_types_Extended::T_PhonBkContactDetailsExtended> _contactDetailList;
};


#endif
