/**************************************************************************//**
 * \file       clSDS_Method_CommonStartSession.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_CommonStartSession_h
#define clSDS_Method_CommonStartSession_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "application/GuiService.h"
#include "application/SdsAudioSourceObserver.h"
#include "application/EcnrEngineParamObserver.h"
#include "application/DiagnosticsClientHandler.h"
#include "asf/core/Timer.h"

class SdsAudioSource;
class clSDS_Property_Audio_ECNR_EngineParameter;


class clSDS_Method_CommonStartSession
   : public clServerMethod
   , public EcnrEngineParamObserver
   , public asf::core::TimerCallbackIF
{
   public:
      virtual ~clSDS_Method_CommonStartSession();
      clSDS_Method_CommonStartSession(
         ahl_tclBaseOneThreadService* pService,
         SdsAudioSource& audioSource,
         GuiService& guiService,
         clSDS_Property_Audio_ECNR_EngineParameter& property_Audio_ECNR_EngineParameter,
         DiagnosticsClientHandler& diagnosticsClientHandler);

   private:
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      virtual void onEcnrEngineParameterChanged();
      void startAudioChannelWaitTimer();
      void stopAudioChannelWaitTimer();
      void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);

      SdsAudioSource& _audioSource;
      GuiService& _guiService;
      clSDS_Property_Audio_ECNR_EngineParameter& _property_Audio_ECNR_EngineParameter;
      DiagnosticsClientHandler& _diagnosticsClientHandler;
      bool _waitingOnAudioActivity;
      asf::core::Timer _audioChannelWaitTimer;
};


#endif
