/**************************************************************************//**
 * \file       clSDS_Method_CommonSetSDSEvent.cpp
 *
 * clSDS_Method_AppsLaunchApplication method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/


#include "Sds2HmiServer/functions/clSDS_Method_CommonSetSDSEvent.h"
#include "external/sds2hmi_fi.h"
#include "application/clSDS_SessionControl.h"

#include "SdsAdapter_Trace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_CommonSetSDSEvent.cpp.trc.h"
#endif

/**************************************************************************//**
 *
 ******************************************************************************/
clSDS_Method_CommonSetSDSEvent::~clSDS_Method_CommonSetSDSEvent()
{
   _pSessionControl = NULL;
}


/**************************************************************************//**
 *
 ******************************************************************************/
clSDS_Method_CommonSetSDSEvent::clSDS_Method_CommonSetSDSEvent(
   ahl_tclBaseOneThreadService* pService,
   clSDS_SessionControl* pSessionControl)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONSETSDSEVENT, pService)
   , _pSessionControl(pSessionControl)
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
tVoid clSDS_Method_CommonSetSDSEvent::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgCommonSetSDSEventMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);

   switch (oMessage.SDS_Event.enType)
   {
      case sds2hmi_fi_tcl_e8_Common_SDS_Evnt::FI_EN_COMN_EVNT_REC_TIMEOUT:
      case sds2hmi_fi_tcl_e8_Common_SDS_Evnt::FI_EN_COMN_EVNT_PAUSE_COMMAND:
         if (_pSessionControl != NULL)
         {
            if (clSDS_ConfigurationFlags::getHapticModeAfterThirdError() == true)
            {
               _pSessionControl->sendEnterManualMode();
            }
            else
            {
               _pSessionControl->vAbortSession();
            }
            vSendMethodResult();
         }
         break;
      default:
         vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
         break;
   }
}
