/**************************************************************************//**
 * \file       clSDS_Method_CommonSetAvailableUserwords.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_CommonSetAvailableUserwords_h
#define clSDS_Method_CommonSetAvailableUserwords_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include "application/SdsPhoneService.h"
#include "MOST_PhonBk_FIProxy.h"
#include "application/clSDS_PhoneStatusObserver.h"

class NaviVoiceTagHandler;

class clSDS_Method_CommonSetAvailableUserwords
   : public clServerMethod ,
     public clSDS_PhoneStatusObserver
{
   public:
      virtual ~clSDS_Method_CommonSetAvailableUserwords();
      clSDS_Method_CommonSetAvailableUserwords(
         ahl_tclBaseOneThreadService* pService,
         SdsPhoneService& sdsPhoneService,
         ::boost::shared_ptr< ::MOST_PhonBk_FI::MOST_PhonBk_FIProxy> phonebookProxy,
         NaviVoiceTagHandler* pNaviVoiceTagHandler);
      void phoneProfileChanged(uint8 profileID);

   private:
      typedef std::vector<sds2hmi_fi_tcl_Userword> AvailableUserwords;

      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      tVoid vTraceMethodStart(const AvailableUserwords& oUserwords) const;
      void updateUserWords();

      boost::shared_ptr<MOST_PhonBk_FI::MOST_PhonBk_FIProxy> _phonebookProxy;
      SdsPhoneService& _sdsPhoneService;
      NaviVoiceTagHandler* _pNaviVoiceTag;
      AvailableUserwords _availableUserwords;
      uint8 _profileID;
};


#endif
