/**************************************************************************//**
 * \file       clSDS_Method_CommonSetActiveApplication.h
 *
 * VC FC Service Message handler functions
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#ifndef clSDS_Method_CommonSetActiveApplication_h
#define clSDS_Method_CommonSetActiveApplication_h


#include "Sds2HmiServer/framework/clServerMethod.h"
#include "external/sds2hmi_fi.h"
#include <application/GuiService.h>
#include "org/genivi/audiomanager/CommandInterfaceProxy.h"


class clSDS_Method_CommonSetActiveApplication : public clServerMethod
   , public org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesCallbackIF
{
   public:
      virtual ~clSDS_Method_CommonSetActiveApplication();
      clSDS_Method_CommonSetActiveApplication(ahl_tclBaseOneThreadService* pService, GuiService& guiService,
                                              boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy> commandInterfaceProxy);
      void onGetListSystemPropertiesError(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
                                          const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesError >& error);
      void onGetListSystemPropertiesResponse(const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy >& proxy,
                                             const ::boost::shared_ptr< org::genivi::audiomanager::CommandInterface::GetListSystemPropertiesResponse >& response);
      enum am_CustomSystemPropertyType_t
      {
         SYP_LAST_TUNER_SOURCE = 12
      };
      enum sourceid
      {
         TUNER_FM = 2,
         TUNER_AM,
         TUNER_DAB,
         TUNER_DRM,
         //DTV = 11,
         TUNER_TA_FM,
         TUNER_TA_DAB,
         SXM_TTS = 22,
         TUNER_XM = 39,
         SXM_NEWS = 59,
         TUNER_TI_AM = 61
      };

   private:
      GuiService& _guiService;
      boost::shared_ptr< org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy> _commandInterfaceProxy;
      virtual tVoid vMethodStart(amt_tclServiceData* pInMsg);
      tVoid requestPlayLastTunerSource(const uint16);
};


#endif
