/**************************************************************************//**
 * \file       clSDS_Method_CommonSelectListElement.cpp
 *
 * clSDS_Method_CommonSelectListElement method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonSelectListElement.h"
#include "external/sds2hmi_fi.h"
#include "application/clSDS_ListScreen.h"
#include "application/clSDS_StringVarList.h"
#include "application/StringUtils.h"

#include "SdsAdapter_Trace.h"
#define ETG_ENABLED
#include "trace_interface.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX      "SdsAdapter_"
#define ETG_I_TRACE_CHANNEL         TR_TTFIS_SAAL
#define ETG_DEFAULT_TRACE_CLASS     TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_CommonSelectListElement.cpp.trc.h"
#endif

/**************************************************************************//**
*Destructor
******************************************************************************/
clSDS_Method_CommonSelectListElement::~clSDS_Method_CommonSelectListElement()
{
   _pListScreen = NULL;
}


/**************************************************************************//**
*Constructor
******************************************************************************/
clSDS_Method_CommonSelectListElement::clSDS_Method_CommonSelectListElement(ahl_tclBaseOneThreadService* pService, clSDS_ListScreen* pListScreen)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONSELECTLISTELEMENT, pService), _pListScreen(pListScreen), _u32AbsoluteIndex(0)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonSelectListElement::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   ETG_TRACE_USR4(("clSDS_Method_CommonSelectListElement::vMethodStart _pListScreen %s", _pListScreen ? "true" : "null"));
   ETG_TRACE_USR4(("clSDS_Method_CommonSelectListElement::vMethodStart oMessage.nLine %d", oMessage.nLine));
   ETG_TRACE_USR4(("clSDS_Method_CommonSelectListElement::vMethodStart _pListScreen->getMaxElementsPerPage(): %d", _pListScreen->getMaxElementsPerPage()));
   if ((_pListScreen != NULL) && (oMessage.nLine > 0) && (oMessage.nLine <= _pListScreen->getMaxElementsPerPage()))
   {
      ETG_TRACE_USR4(("clSDS_Method_CommonSelectListElement::vMethodStartg if"));
      _u32AbsoluteIndex = _pListScreen->u32GetPageNumber() * _pListScreen->getMaxElementsPerPage() + oMessage.nLine;

      clSDS_StringVarList::vSetVariable("$(Number)", StringUtils::toString(oMessage.nLine));

      tBool bSendResponse = _pListScreen->bSelectElement(_u32AbsoluteIndex);

      if (bSendResponse)
      {
         vSendResponse();
      }
   }
   else
   {
      ETG_TRACE_USR4(("clSDS_Method_CommonSelectListElement::vMethodStart else"));
      vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonSelectListElement::vSendResponse()
{
   sds2hmi_sdsfi_tclMsgCommonSelectListElementMethodResult oResult;
   oResult.nLine = _u32AbsoluteIndex;
   vSendMethodResult(oResult);
}
