/**************************************************************************//**
 * \file       clSDS_Method_CommonRestoreHMIList.cpp
 *
 * clSDS_Method_CommonRestoreHMIList method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonRestoreHMIList.h"
#include "application/RestoreHMIList.h"
#include "application/clSDS_POIList.h"
#include "application/QuickChargingStation.h"
#include "external/sds2hmi_fi.h"


/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_CommonRestoreHMIList::~clSDS_Method_CommonRestoreHMIList()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_CommonRestoreHMIList::clSDS_Method_CommonRestoreHMIList(
   ahl_tclBaseOneThreadService* pService
   , clSDS_POIList* pPOIList
   , QuickChargingStation* pQuickChargingStation)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONRESTOREHMILIST, pService)
   , _pPOIList(pPOIList)
   , _pQuickChargingStation(pQuickChargingStation)
{
   addHMIListTypes(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_POI_ENTRIES, _pPOIList);
   addHMIListTypes(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_ALL_CHARGE_STATIONS, _pQuickChargingStation);
   addHMIListTypes(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_QUICK_CHARGE_STATIONS, _pQuickChargingStation);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonRestoreHMIList::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgCommonRestoreHMIListMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   if (sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_QUICK_CHARGE_STATIONS == oMessage.ListType.enType || sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_ALL_CHARGE_STATIONS == oMessage.ListType.enType)
   {
      _pQuickChargingStation->setChargingStationListRequestStatus(true);
   }
   handleHMIListType(oMessage.ListType.enType);
}


/*************************************************************************
 *
 ***************************************************************************/
void clSDS_Method_CommonRestoreHMIList::handleHMIListType(sds2hmi_fi_tcl_e8_HMI_ListType::tenType enListType)
{
   std::map<sds2hmi_fi_tcl_e8_HMI_ListType::tenType, RestoreHMIList*>::iterator it;
   it = _oHMIListMap.find(enListType);

   if (it != _oHMIListMap.end() && (it->second != NULL))
   {
      it->second->vRestoreHMIListData();
   }
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_CommonRestoreHMIList::addHMIListTypes(sds2hmi_fi_tcl_e8_HMI_ListType::tenType type, RestoreHMIList* pHMIList)
{
   if (pHMIList != NULL)
   {
      pHMIList->setCurrentHMIListObserver(this);
      _oHMIListMap[type] = pHMIList;
   }
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_CommonRestoreHMIList::hmiListRestored(RestoreHMIList* pHMIList)
{
   if (pHMIList != NULL)
   {
      if (pHMIList->getResultType())
      {
         vSendMethodResult();
      }
      else
      {
         vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
      }
   }
}
