/**************************************************************************//**
 * \file       clSDS_Method_CommonInteractionLogger.cpp
 *
 * clSDS_Method_CommonInteractionLogger method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonInteractionLogger.h"
#include "external/sds2hmi_fi.h"
#include "application/SdsDiagnosisService.h"
#include "SdsAdapter_Trace.h"

#define ETG_ENABLED
#include "trace_interface.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_I_TTFIS_CMD_PREFIX      "SdsAdapter_"
#define ETG_I_TRACE_CHANNEL         TR_TTFIS_SAAL
#define ETG_DEFAULT_TRACE_CLASS     TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_CommonInteractionLogger.cpp.trc.h"
#endif

using namespace sds_gui_fi::SdsDiagnosisService;

/**************************************************************************//**
* Destructor
******************************************************************************/
clSDS_Method_CommonInteractionLogger::~clSDS_Method_CommonInteractionLogger()
{
   _pSdsDiagnosisService = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clSDS_Method_CommonInteractionLogger::clSDS_Method_CommonInteractionLogger(ahl_tclBaseOneThreadService* pService, SdsDiagnosisService* pSdsDiagnosisService)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONINTERACTIONLOGGER, pService)
   , _pSdsDiagnosisService(pSdsDiagnosisService)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clSDS_Method_CommonInteractionLogger::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgCommonInteractionLoggerMethodStart oMessage;
   vGetDataFromAmt(pInMessage, oMessage);
   switch (oMessage.Event.enType)
   {
      case sds2hmi_fi_tcl_e8_EventForLogging::FI_EN_BEGIN_OF_SPEECH:
      {
         _pSdsDiagnosisService->sendExtendedSDSLoggingDataUpdateSignal(ExtendedSDSLoggingData__BEGIN_OF_SPEECH, oMessage.TimeStamp);
      }
      break;
      case sds2hmi_fi_tcl_e8_EventForLogging::FI_EN_END_OF_SPEECH:
      {
         _pSdsDiagnosisService->sendExtendedSDSLoggingDataUpdateSignal(ExtendedSDSLoggingData__END_OF_SPEECH, oMessage.TimeStamp);
      }
      break;
      case sds2hmi_fi_tcl_e8_EventForLogging::FI_EN_CALL_TO_PP:
      {
         _pSdsDiagnosisService->sendExtendedSDSLoggingDataUpdateSignal(ExtendedSDSLoggingData__CALLING_PP, oMessage.TimeStamp);
      }
      break;
      case sds2hmi_fi_tcl_e8_EventForLogging::FI_EN_PROMPT_PLAY_SATRTED:
      {
         _pSdsDiagnosisService->sendExtendedSDSLoggingDataUpdateSignal(ExtendedSDSLoggingData__START_OF_PROMPT, oMessage.TimeStamp);
      }
      break;
      case sds2hmi_fi_tcl_e8_EventForLogging::FI_EN_END_OF_PROMPT:
      {
         _pSdsDiagnosisService->sendExtendedSDSLoggingDataUpdateSignal(ExtendedSDSLoggingData__END_OF_PROMPT, oMessage.TimeStamp);
      }
      break;
      case sds2hmi_fi_tcl_e8_EventForLogging::FI_EN_UNKNOWN:
      {
         if (oMessage.SpeechCommandList.size())
         {
            _pSdsDiagnosisService->sendExtendedSDSLoggingDataUpdateSignal(ExtendedSDSLoggingData__RECOGNIZER_RESULT, oMessage.TimeStamp);
         }
         else
         {
            ETG_TRACE_USR1(("clSDS_Method_CommonInteractionLogger::SpeechCommandList_Empty"));
         }
      }
      break;
      default:
         break;
   }

   vSendMethodResult();
}
