/**************************************************************************//**
 * \file       clSDS_Method_CommonGetHmiListDescription.cpp
 *
 * clSDS_Method_CommonGetHmiListDescription method class implementation
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/functions/clSDS_Method_CommonGetHmiListDescription.h"
#include "SdsAdapter_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/clSDS_Method_CommonGetHmiListDescription.cpp.trc.h"
#endif

using namespace org::bosch::cm::navigation::NavigationService;

/**************************************************************************//**
 * Constructor
 ******************************************************************************/
clSDS_Method_CommonGetHmiListDescription::clSDS_Method_CommonGetHmiListDescription(
   ahl_tclBaseOneThreadService* pService)
   : clServerMethod(SDS2HMI_SDSFI_C_U16_COMMONGETHMILISTDESCRIPTION, pService)
   , _isDescriptorTagAddressEntry(false)
{
}


/**************************************************************************//**
 * Destructor
 ******************************************************************************/
clSDS_Method_CommonGetHmiListDescription::~clSDS_Method_CommonGetHmiListDescription()
{
}


/**************************************************************************//**
 *
 ******************************************************************************/
tVoid clSDS_Method_CommonGetHmiListDescription::vMethodStart(amt_tclServiceData* pInMessage)
{
   sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart oMessage;
   sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult oResult;
   vGetDataFromAmt(pInMessage, oMessage);
   if (bCheckHmiListDescriptionType(oMessage, oResult))
   {
      vSendMethodResult(oResult);
   }
   else
   {
      vSendErrorMessage(SDS2HMI_SDSFI_C_U16_ERROR_CANNOTCOMPLETEACTION);
   }
}


/**************************************************************************//**
 *
 ******************************************************************************/
bool clSDS_Method_CommonGetHmiListDescription::bCheckHmiListDescriptionType(
   const sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodStart& oMessage,
   sds2hmi_sdsfi_tclMsgCommonGetHMIListDescriptionMethodResult& oResultListDescription)
{
   ETG_TRACE_USR1(("MenuType:%d", oMessage.ListType.enType));
   clSDS_List* pCurrentList ;
   std::map<sds2hmi_fi_tcl_e8_HMI_ListType::tenType, clSDS_List*>::iterator it;
   it = _oListMap.find(oMessage.ListType.enType);
   pCurrentList = it->second;

   if (pCurrentList != NULL)
   {
      switch (oMessage.ListType.enType)
      {
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_ADDRESSBOOK:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_NAV_PREV_DESTINATIONS:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_MISSED_CALLS:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_ANSWERED_CALLS:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_DIALLED_CALLS:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_ALL_CALLS:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_INFO_FEEDS:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_NAV_DISTANCE_DETOUR:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_ALL_CHARGE_STATIONS:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_QUICK_CHARGE_STATIONS:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_POI_CATEGORIES:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_NAV_POI_ICON:
         case sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_USERWORDS:
            oResultListDescription.DescriptionList = pCurrentList->getHmiListDescription();
            return true;

         default:
            return false;
      }
   }

   return false;
}


/***********************************************************************//**
 *
 ***************************************************************************/
void clSDS_Method_CommonGetHmiListDescription::vAddList(
   sds2hmi_fi_tcl_e8_HMI_ListType::tenType type,
   clSDS_List* pList)
{
   if (pList != NULL)
   {
      _oListMap[type] = pList;
   }
}


/***********************************************************************//**
 *
 ***************************************************************************/
