/**************************************************************************//**
 * \file       clServerMethodTimerHelper.cpp
 *
 *
 * \copyright  (C) 2018 Robert Bosch GmbH
 *             (C) 2018 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/
#include "Sds2HmiServer/framework/clServerMethodTimerHelper.h"


clServerMethodTimerHelper::clServerMethodTimerHelper(clServerMethod& serverMethod, size_t processingTimeoutMs)
   : _serverMethod(serverMethod)
   , _processingTimeoutMs(static_cast< ::asf::ms_t>(processingTimeoutMs))
{
}


clServerMethodTimerHelper::~clServerMethodTimerHelper()
{
}


void clServerMethodTimerHelper::startProccessingTimer()
{
   _processingTimer.start(*this, _processingTimeoutMs);
}


void clServerMethodTimerHelper::stopProccessingTimer()
{
   _processingTimer.stop();
}


void clServerMethodTimerHelper::scheduleQueuedRequest()
{
   _submitTimer.start(*this, 1);
}


void clServerMethodTimerHelper::onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data)
{
   if (&timer == &_processingTimer)
   {
      _serverMethod.requestTimeout();
      _serverMethod.submitQueuedRequest();
   }
   if (&timer == &_submitTimer)
   {
      _serverMethod.submitQueuedRequest();
   }
}
