/**************************************************************************//**
 * \file       Sds2HmiServer.cpp
 *
 * This file is part of the SdsAdapter component.
 *
 * \copyright  (C) 2016 Robert Bosch GmbH
 *             (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *             The reproduction, distribution and utilization of this file
 *             as well as the communication of its contents to others without
 *             express authorization is prohibited. Offenders will be held
 *             liable for the payment of damages. All rights reserved in the
 *             event of the grant of a patent, utility model or design.
 *****************************************************************************/

#include "Sds2HmiServer/Sds2HmiServer.h"
#include "Sds2HmiServer/framework/AhlApp.h"
#include "Sds2HmiServer/framework/AhlService.h"
#include "Sds2HmiServer/TraceCommandAdapter.h"
// sds2hmi_fi methods
#include "Sds2HmiServer/functions/clSDS_Method_AppsLaunchApplication.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonGetHmiElementDescription.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonGetHmiListDescription.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonGetListInfo.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonInteractionLogger.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonSelectListElement.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonSetActiveApplication.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonSetAvailableSpeakers.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonSetAvailableUserwords.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonSetSDSEvent.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonShowDialog.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonStartSession.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonStopSession.h"
#include "Sds2HmiServer/functions/clSDS_Method_ContactsGetAmbiguityList.h"
#include "Sds2HmiServer/functions/clSDS_Method_InfoShowMenu.h"
#include "Sds2HmiServer/functions/clSDS_Method_MediaGetAmbiguityList.h"
#include "Sds2HmiServer/functions/clSDS_Method_MediaGetDataBase.h"
#include "Sds2HmiServer/functions/clSDS_Method_MediaGetDeviceInfo.h"
#include "Sds2HmiServer/functions/clSDS_Method_MediaPlay.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviGetAmbiguityList.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviGetContactListEntries.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviGetCurrentDestination.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviGetHouseNumberRange.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviGetWaypointListInfo.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviRepeatInstruction.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviSelectDestListEntry.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviSetDestinationAsWaypoint.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviSetDestinationItem.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviValidateDestinationEntries.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviSetMapMode.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviSetZoomSetting.h"
#include "Sds2HmiServer/functions/clSDS_Method_NavDataRegisterDirectNDSUse.h"
#include "Sds2HmiServer/functions/clSDS_Method_NavDataUnRegisterDirectNDSUse.h"
#include "Sds2HmiServer/functions/clSDS_Method_NavDataAccessModeChanged.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviShowNavMenu.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviStartGuidance.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviStopGuidance.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviSetRouteCriteria.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviSetNavSetting.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviGetSearchLocation.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneDialContact.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneDialNumber.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneGetContactListEntries.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneGetDataBases.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneGetNumberInfo.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneRedialLastNumber.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneSelectPhone.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneSendDTMFDigits.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneSetContact.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneSetPhoneSetting.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneShowMenu.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneStartPairing.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneSwitchCall.h"
#include "Sds2HmiServer/functions/clSDS_Method_PhoneUpdatePhonebook.h"
#include "Sds2HmiServer/functions/clSDS_Method_TextMsgCallbackSender.h"
#include "Sds2HmiServer/functions/clSDS_Method_TextMsgGetContent.h"
#include "Sds2HmiServer/functions/clSDS_Method_TextMsgGetInfo.h"
#include "Sds2HmiServer/functions/clSDS_Method_TextMsgSend.h"
#include "Sds2HmiServer/functions/clSDS_Method_TextMsgSetContent.h"
#include "Sds2HmiServer/functions/clSDS_Method_TextMsgSetNumber.h"
#include "Sds2HmiServer/functions/clSDS_Method_TextMsgSelectMessage.h"
#include "Sds2HmiServer/functions/clSDS_Method_TunerGetDataBases.h"
#include "Sds2HmiServer/functions/clSDS_Method_TunerSelectBandMemBank.h"
#include "Sds2HmiServer/functions/clSDS_Method_TunerSelectStation.h"
//#include "Sds2HmiServer/functions/clSDS_Method_TVSelectStation.h"
#include "Sds2HmiServer/functions/clSDS_Method_NavDataGetCountryStateList.h"
#include "Sds2HmiServer/functions/clSDS_Method_NavDataGetStreetAvailability.h"
#include "Sds2HmiServer/functions/clSDS_Method_NavDataGetStringAndPhoneme.h"
#include "Sds2HmiServer/functions/clSDS_Method_VDLGetDatabases.h"
#include "Sds2HmiServer/functions/clSDS_Method_CommonRestoreHMIList.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviStartDistanceDetour.h"
#include "Sds2HmiServer/functions/clSDS_Method_NaviCancelDistanceDetour.h"


// sds2hmi_fi properties
#include "Sds2HmiServer/functions/clSDS_Property_ActiveSpeaker.h"
#include "Sds2HmiServer/functions/clSDS_Property_Audio_ECNR_EngineParameter.h"
#include "Sds2HmiServer/functions/clSDS_Property_AudioECNR_ASR_ModeStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_CommonActionRequest.h"
#include "Sds2HmiServer/functions/clSDS_Property_CommonCoreSpeechParameters.h"
#include "Sds2HmiServer/functions/clSDS_Property_CommonSDSConfiguration_Dyna.h"
#include "Sds2HmiServer/functions/clSDS_Property_CommonSDSConfiguration_Stat.h"
#include "Sds2HmiServer/functions/clSDS_Property_CommonSettingsRequest.h"
#include "Sds2HmiServer/functions/clSDS_Property_CommonStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_ConnectedDeviceStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_InfoServiceStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_MediaStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_NavDataDataSetInfo.h"
#include "Sds2HmiServer/functions/clSDS_Property_NaviCurrentCountryState.h"
#include "Sds2HmiServer/functions/clSDS_Property_NaviStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_PhoneStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_SdsStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_SpecialAppStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_TextMsgStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_TunerStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_VDLStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_WeatherStatus.h"
#include "Sds2HmiServer/functions/clSDS_Property_NaviPOIIconList.h"


// application
#include "application/AcrHandler.h"
#include "application/AudioSourceHandler.h"
#include "application/EarlyStartupPlayer.h"
#include "application/clSDS_AddressBookList.h"
#include "application/clSDS_AmbigContactList.h"
#include "application/clSDS_AmbigNumberList.h"
#include "application/clSDS_ConfigurationFlags.h"
#include "application/clSDS_CustomSMSList.h"
#include "application/clSDS_ContactNumberList.h"
#include "application/clSDS_Display.h"
#include "application/clSDS_DTMFHandler.h"
#include "application/clSDS_FmChannelList.h"
#include "application/clSDS_AmChannelList.h"
#include "application/clSDS_DabChannelList.h"
#include "application/clSDS_FormatTimeDate.h"
#include "application/clSDS_FuelPriceList.h"
#include "application/clSDS_G2P_FactorySettings.h"
#include "application/clSDS_InfoFeedsList.h"
#include "application/clSDS_IsVehicleMoving.h"
#include "application/clSDS_LanguageMediator.h"
#include "application/clSDS_ListScreen.h"
#include "application/clSDS_MenuManager.h"
#include "application/clSDS_MultipleDestinationsList.h"
#include "application/clSDS_MyAppsDataBase.h"
#include "application/clSDS_MyAppsList.h"
#include "application/clSDS_NBestList.h"
#include "application/clSDS_FMNBestList.h"
#include "application/clSDS_FMTemplate.h"
#include "application/clSDS_ParkingList.h"
#include "application/clSDS_NaviListItems.h"
#include "application/NaviPOICategoryList.h"
#include "application/NaviPOIIconsList.h"
#include "application/clSDS_PhonebookList.h"
#include "application/clSDS_POIList.h"
#include "application/clSDS_PreviousDestinationsList.h"
#include "application/clSDS_QuickDialList.h"
#include "application/clSDS_QuickDialRelationshipUpdater.h"
#include "application/clSDS_ReadSmsList.h"
#include "application/clSDS_RecentCallsList.h"
#include "application/clSDS_SDSStatus.h"
#include "application/clSDS_SessionControl.h"
#include "application/clSDS_SdsControl.h"
#include "application/clSDS_SXMAudioChannelList.h"
#include "application/clSDS_TunerBandRange.h"
//#include "application/clSDS_TVStationList.h"
#include "application/clSDS_Userwords.h"
#include "application/DataHandoverHandler.h"
#include "application/SdsDiagnosisService.h"
#include "application/GuiService.h"
#include "application/InfoShowMenuHandler.h"
#include "application/NaviAddressFormatter.h"
#include "application/NaviDetourList.h"
//#include "application/AppChannelList.h"

#include "application/PhonebookContacts.h"
#include "application/PopUpService.h"
#include "application/SettingsService.h"
#include "application/SdsAudioSource.h"
#include "application/SdsDataHandoverService.h"
#include "application/SdsFocusService.h"
#include "application/SdsPhoneService.h"
#include "application/SxmDataServices.h"
#include "external/sds2hmi_fi.h"
#include "view_db/Sds_ViewDB.h"
#include "application/NaviVoiceTagHandler.h"
#include "application/SystemVoiceSettings.h"
#include "application/CountryNameRequestor.h"
#include "application/StateNameRequestor.h"
#include "application/VariantLayoutMap.h"
#include "application/NaviHapticHandOverInterface.h"
#include "application/NaviHapticHandOverList.h"
#include "application/NdsStringRequestor.h"
#include "application/NdsCountryStateRequestor.h"
#include "application/UserProfile.h"
#include "application/NdsPhonemeRequestor.h"
#include "application/QuickChargingStation.h"
#include "application/DiagnosticsClientHandler.h"


#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_SDSADP_DETAILS
#include "trcGenProj/Header/Sds2HmiServer.cpp.trc.h"
#endif


#define SAFE_CREATE(pointerVar, constructorCall)       pointerVar = new constructorCall; if (!pointerVar) return service

#define DELETE_AND_PURGE(member)         if (member) delete member; member = NULL


using namespace asf::core;
using namespace sxm_movies_main_fi;
using namespace CMB_ACR_FI;
using namespace smartphoneint_main_fi;
using namespace dabtuner_main_fi;
///using namespace org::bosch::cm::fc_dtv::serverInterface;
using namespace bosch::cm::profile;
using namespace org::genivi::audiomanager::CommandInterface;
//using namespace HVACPIVI_MAIN_FI;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
using namespace bosch::cm::ai::hmi::managedapps::ManagedApps;
#endif


Sds2HmiServer::Sds2HmiServer()
   : _pAudioSourceHandler(NULL)
   , _pAddressBookList(NULL)
   , _pAmbigContactList(NULL)
   , _pAmbigNumberList(NULL)
   , _pConfigFlags(NULL)
   , _pContactNumberList(NULL)
   , _pCustomSMSList(NULL)
   , _pDisplay(NULL)
   , _pDTMFHandler(NULL)
   , _pEarlyStartupPlayer(NULL)
   , _pFmChannelList(NULL)
   , _pAmChannelList(NULL)
   , _pDabChannelList(NULL)
   , _pFormatTimeDate(NULL)
   , _pFuelPriceList(NULL)
   , _pG2P_FactorySetttings(NULL)
   , _pInfoFeedsList(NULL)
   , _pIsVehicleMoving(NULL)
   , _pLanguageMediator(NULL)
   , _pListScreen(NULL)
   , _pMenuManager(NULL)
   , _pMultipleDestinationList(NULL)
   , _pMyAppsDataBase(NULL)
   , _pNaviListItems(NULL)
   , _pNaviPOICategoryList(NULL)
   , _pNaviPOIIconsList(NULL)
   , _pNBestList(NULL)
   , _pFMNBestList(NULL)
   , _pFMTemplate(NULL)
   , _pParkingList(NULL)
   , _pPhonebookList(NULL)
   , _pPOIList(NULL)
   , _pPreviousDestinationsList(NULL)
   , _pQuickDialList(NULL)
   , _pQuickDialLisRelationshipUpdater(NULL)
   , _pReadSmsList(NULL)
   , _pRecentCallsList(NULL)
   , _pSDSStatus(NULL)
   , _pSessionControl(NULL)
   , _pSxmAudioChannelList(NULL)
   , _pTunerBandRange(NULL)
     //, _pTVStationList(NULL)
   , _pUserwords(NULL)
   , _pAcrHandler(NULL)
   , _pNaviVoiceTagHandler(NULL)
   , _pNdsCountryStateRequestor(NULL)
   , _pGuiService(NULL)
   , _pInfoShowMenuHandler(NULL)
   , _pNaviAddressFormatter(NULL)
   , _pNaviDetourList(NULL)
   , _pPhonebookContacts(NULL)
   , _pPopUpService(NULL)
   , _pSdsAudioSource(NULL)
   , _pSdsDataHandoverService(NULL)
   , _pSdsDiagnosisService(NULL)
   , _pSdsFocusService(NULL)
   , _pSdsPhoneService(NULL)
   , _pSettingsService(NULL)
   , _pSxmDataSevices(NULL)
   , _pTraceCommandAdapter(NULL)
   , _pVoiceSetting(NULL)
   , _pCountryNameRequestor(NULL)
   , _pStateNameRequestor(NULL)
   , _pDataHandoverHandler(NULL)
   , _pVariantLayoutMap(NULL)
   , _pNdsStringRequestor(NULL)
   , _pNdsPhonemeRequestor(NULL)
   , _pQuickChargingStation(NULL)
   , _pMethodAppsLaunchApplication(NULL)
   , _pMethodCommonGetHmiListDescription(NULL)
   , _pMethodCommonGetListInfo(NULL)
   , _pMethodCommonSetActiveApplication(NULL)
   , _pMethodCommonSetAvailableUserwords(NULL)
   , _pMethodCommonShowDialog(NULL)
   , _pMethodContactsGetAmbiguityList(NULL)
   , _pMethodMediaGetAmbiguityList(NULL)
   , _pMethodMediaGetDeviceInfo(NULL)
   , _pMethodMediaPlay(NULL)
   , _pMethodNavDataRegisterDirectNDSUse(NULL)
   , _pMethodNavDataUnRegisterDirectNDSUse(NULL)
   , _pMethod_NavDataAccessModeChanged(NULL)
   , _pMethodNaviGetContactListEntries(NULL)
   , _pMethodNaviGetSearchLocation(NULL)
   , _pMethodNaviGetWaypointListInfo(NULL)
   , _pMethodNaviSelectDestListEntry(NULL)
   , _pMethodNaviSetDestinationAsWaypoint(NULL)
   , _pMethodNaviSetDestinationItem(NULL)
   , _pMethodNaviValidateDestinationEntries(NULL)
   , _pMethodNaviSetMapMode(NULL)
   , _pMethodPhoneDialContact(NULL)
   , _pMethodPhoneDialNumber(NULL)
   , _pMethodPhoneGetContactListEntries(NULL)
   , _pMethodPhoneRedialLastNumber(NULL)
   , _pMethodPhoneSetPhoneSetting(NULL)
   , _pMethodPhoneStartPairing(NULL)
   , _pMethodPhoneSwitchCall(NULL)
   , _pMethodPhoneUpdatePhonebook(NULL)
   , _pMethodTextMsgCallbackSender(NULL)
   , _pMethodTextMsgGetContent(NULL)
   , _pMethodTextMsgGetInfo(NULL)
   , _pMethodTextMsgSelectMessage(NULL)
   , _pMethodTextMsgSend(NULL)
   , _pMethodTextMsgSetContent(NULL)
   , _pMethodTextMsgSetNumber(NULL)
   , _pMethodTunerSelectBandMemBank(NULL)
   , _pMethodTunerSelectStation(NULL)
   , _pMethodCommonRestoreHMIList(NULL)
     //, _pMethodTVSelectStation(NULL)
   , _pMethodVDLGetDatabases(NULL)
   , _pPropertyAudio_ECNR_EngineParameter(NULL)
   , _pMethodNavDataGetCountryStateList(NULL)
   , _pMethodNavDataGetStreetAvailability(NULL)
   , _pMethodNavDataGetStringAndPhoneme(NULL)
   , _pMethodInfoShowMenu(NULL)
   , _pPropertyAudioECNRASRModeStatus(NULL)
   , _pPropertyCommonActionRequest(NULL)
   , _pPropertyCommonCoreSpeechParameters(NULL)
   , _pPropertyCommonSDSConfiguration_Dyna(NULL)
   , _pPropertyCommonSDSConfiguration_Stat(NULL)
   , _pPropertyCommonSettingsRequest(NULL)
   , _pPropertyCommonStatus(NULL)
   , _pPropertyConnectedDeviceStatus(NULL)
   , _pPropertyMediaStatus(NULL)
   , _pPropertyNavDataDataSetInfo(NULL)
   , _pPropertyNaviCurrentCountryState(NULL)
   , _pPropertyNaviStatus(NULL)
   , _pPropertyPhoneStatus(NULL)
   , _pPropertySpecialAppStatus(NULL)
   , _pPropertyTextMsgStatus(NULL)
   , _pPropertyTunerStatus(NULL)
   , _pPropertyVDLStatus(NULL)
   , _pNaviHapticHandOverInterface(NULL)
   , _pNaviHapticHandOverList(NULL)
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
     //, _pAppChannelList(NULL)
#endif
   , _pUserProfile(NULL)
   , _pNaviStartDistanceDetour(NULL)
   , _pNaviCancelDistanceDetour(NULL)
   , _pPropertyNaviPOIIconList(NULL)
   , _pDiagnosticsClientHandler(NULL)
{
   ETG_TRACE_USR1(("Sds2HmiServer::Constructor"));
   buildRegistry();
   amt_bInit();
   scd_init();
   createproxies();
   _pAhlApp = new AhlApp(CCA_C_U16_APP_SAALS);
   _pSds2HmiService = createSds2HmiService(_pAhlApp);
   registerServiceAvailableDelegates();

   if (_pAhlApp->bInitInstance(0, CCA_C_U16_APP_SAALS, OSAL_ThreadWhoAmI()) == FALSE)
   {
      ETG_TRACE_ERR(("!!! vStartCCAApplications(): Heat bInitInstance FAILED"));
   }
}


Sds2HmiServer::~Sds2HmiServer()
{
   try
   {
      DELETE_AND_PURGE(_pAudioSourceHandler);
      DELETE_AND_PURGE(_pAddressBookList);
      DELETE_AND_PURGE(_pAhlApp);
      DELETE_AND_PURGE(_pAmbigContactList);
      DELETE_AND_PURGE(_pAmbigNumberList);
      DELETE_AND_PURGE(_pConfigFlags);
      DELETE_AND_PURGE(_pContactNumberList);
      DELETE_AND_PURGE(_pCustomSMSList);
      DELETE_AND_PURGE(_pDisplay);
      DELETE_AND_PURGE(_pDTMFHandler);
      DELETE_AND_PURGE(_pEarlyStartupPlayer);
      DELETE_AND_PURGE(_pFmChannelList);
      DELETE_AND_PURGE(_pAmChannelList);
      DELETE_AND_PURGE(_pDabChannelList);
      DELETE_AND_PURGE(_pFormatTimeDate);
      DELETE_AND_PURGE(_pFuelPriceList);
      DELETE_AND_PURGE(_pG2P_FactorySetttings);
      DELETE_AND_PURGE(_pNdsCountryStateRequestor);
      DELETE_AND_PURGE(_pGuiService);
      DELETE_AND_PURGE(_pInfoFeedsList);
      DELETE_AND_PURGE(_pNaviDetourList);
      DELETE_AND_PURGE(_pInfoShowMenuHandler);
      DELETE_AND_PURGE(_pNaviAddressFormatter);
      DELETE_AND_PURGE(_pIsVehicleMoving);
      DELETE_AND_PURGE(_pLanguageMediator);
      DELETE_AND_PURGE(_pListScreen);
      DELETE_AND_PURGE(_pMenuManager);
      DELETE_AND_PURGE(_pMultipleDestinationList);
      DELETE_AND_PURGE(_pMyAppsDataBase);
      DELETE_AND_PURGE(_pNaviListItems);
      DELETE_AND_PURGE(_pNaviPOICategoryList);
      DELETE_AND_PURGE(_pNaviPOIIconsList);
      DELETE_AND_PURGE(_pNBestList);
      DELETE_AND_PURGE(_pParkingList);
      DELETE_AND_PURGE(_pPhonebookContacts);
      DELETE_AND_PURGE(_pPhonebookList);
      DELETE_AND_PURGE(_pPOIList);
      DELETE_AND_PURGE(_pPopUpService);
      DELETE_AND_PURGE(_pPreviousDestinationsList);
      DELETE_AND_PURGE(_pQuickDialList);
      DELETE_AND_PURGE(_pReadSmsList);
      DELETE_AND_PURGE(_pRecentCallsList);
      DELETE_AND_PURGE(_pSds2HmiService);
      DELETE_AND_PURGE(_pSdsAudioSource);
      DELETE_AND_PURGE(_pSdsDataHandoverService);
      DELETE_AND_PURGE(_pSdsDiagnosisService);
      DELETE_AND_PURGE(_pSdsFocusService);
      DELETE_AND_PURGE(_pSdsPhoneService);
      DELETE_AND_PURGE(_pSDSStatus);
      DELETE_AND_PURGE(_pSessionControl);
      DELETE_AND_PURGE(_pSettingsService);
      DELETE_AND_PURGE(_pSxmAudioChannelList);
      DELETE_AND_PURGE(_pSxmDataSevices);
      DELETE_AND_PURGE(_pTraceCommandAdapter);
      DELETE_AND_PURGE(_pTunerBandRange);
      //DELETE_AND_PURGE(_pTVStationList);
      DELETE_AND_PURGE(_pUserwords);
      DELETE_AND_PURGE(_pAcrHandler);
      DELETE_AND_PURGE(_pNaviVoiceTagHandler);
      DELETE_AND_PURGE(_pVoiceSetting);
      DELETE_AND_PURGE(_pCountryNameRequestor);
      DELETE_AND_PURGE(_pStateNameRequestor);
      DELETE_AND_PURGE(_pDataHandoverHandler);
      DELETE_AND_PURGE(_pVariantLayoutMap);
      DELETE_AND_PURGE(_pNdsStringRequestor);
      DELETE_AND_PURGE(_pNdsPhonemeRequestor);
      DELETE_AND_PURGE(_pQuickChargingStation);
      DELETE_AND_PURGE(_pMethodAppsLaunchApplication);
      DELETE_AND_PURGE(_pMethodCommonGetHmiListDescription);
      DELETE_AND_PURGE(_pMethodCommonGetListInfo);
      DELETE_AND_PURGE(_pMethodCommonSetActiveApplication);
      DELETE_AND_PURGE(_pMethodCommonSetAvailableUserwords);
      DELETE_AND_PURGE(_pMethodCommonShowDialog);
      DELETE_AND_PURGE(_pMethodContactsGetAmbiguityList);
      DELETE_AND_PURGE(_pMethodMediaGetAmbiguityList);
      DELETE_AND_PURGE(_pMethodMediaGetDeviceInfo);
      DELETE_AND_PURGE(_pMethodMediaPlay);
      DELETE_AND_PURGE(_pMethodNavDataRegisterDirectNDSUse);
      DELETE_AND_PURGE(_pMethodNavDataUnRegisterDirectNDSUse);
      DELETE_AND_PURGE(_pMethod_NavDataAccessModeChanged);
      DELETE_AND_PURGE(_pMethodNaviGetWaypointListInfo);
      DELETE_AND_PURGE(_pMethodNaviGetContactListEntries);
      DELETE_AND_PURGE(_pMethodNaviGetSearchLocation);
      DELETE_AND_PURGE(_pMethodNaviSelectDestListEntry);
      DELETE_AND_PURGE(_pMethodNaviSetDestinationAsWaypoint);
      DELETE_AND_PURGE(_pMethodNaviSetDestinationItem);
      DELETE_AND_PURGE(_pMethodNaviValidateDestinationEntries);
      DELETE_AND_PURGE(_pMethodNaviSetMapMode);
      DELETE_AND_PURGE(_pMethodPhoneDialContact);
      DELETE_AND_PURGE(_pMethodPhoneDialNumber);
      DELETE_AND_PURGE(_pMethodPhoneGetContactListEntries);
      DELETE_AND_PURGE(_pMethodPhoneRedialLastNumber);
      DELETE_AND_PURGE(_pMethodPhoneSetPhoneSetting);
      DELETE_AND_PURGE(_pMethodPhoneStartPairing);
      DELETE_AND_PURGE(_pMethodPhoneSwitchCall);
      DELETE_AND_PURGE(_pMethodPhoneUpdatePhonebook);
      DELETE_AND_PURGE(_pMethodTextMsgCallbackSender);
      DELETE_AND_PURGE(_pMethodTextMsgGetContent);
      DELETE_AND_PURGE(_pMethodTextMsgGetInfo);
      DELETE_AND_PURGE(_pMethodTextMsgSelectMessage);
      DELETE_AND_PURGE(_pMethodTextMsgSend);
      DELETE_AND_PURGE(_pMethodTextMsgSetContent);
      DELETE_AND_PURGE(_pMethodTextMsgSetNumber);
      DELETE_AND_PURGE(_pMethodTunerSelectBandMemBank);
      DELETE_AND_PURGE(_pMethodTunerSelectStation);
      DELETE_AND_PURGE(_pMethodCommonRestoreHMIList);
      //DELETE_AND_PURGE(_pMethodTVSelectStation);
      DELETE_AND_PURGE(_pMethodVDLGetDatabases);
      DELETE_AND_PURGE(_pPropertyAudio_ECNR_EngineParameter);
      DELETE_AND_PURGE(_pMethodNavDataGetCountryStateList);
      DELETE_AND_PURGE(_pMethodNavDataGetStreetAvailability);
      DELETE_AND_PURGE(_pMethodNavDataGetStringAndPhoneme);
      DELETE_AND_PURGE(_pMethodInfoShowMenu);
      DELETE_AND_PURGE(_pPropertyAudioECNRASRModeStatus);
      DELETE_AND_PURGE(_pPropertyCommonActionRequest);
      DELETE_AND_PURGE(_pPropertyCommonCoreSpeechParameters);
      DELETE_AND_PURGE(_pPropertyCommonSDSConfiguration_Dyna);
      DELETE_AND_PURGE(_pPropertyCommonSDSConfiguration_Stat);
      DELETE_AND_PURGE(_pPropertyCommonSettingsRequest);
      DELETE_AND_PURGE(_pPropertyCommonStatus);
      DELETE_AND_PURGE(_pPropertyConnectedDeviceStatus);
      DELETE_AND_PURGE(_pPropertyMediaStatus);
      DELETE_AND_PURGE(_pPropertyNavDataDataSetInfo);
      DELETE_AND_PURGE(_pPropertyNaviCurrentCountryState);
      DELETE_AND_PURGE(_pPropertyNaviStatus);
      DELETE_AND_PURGE(_pPropertyPhoneStatus);
      DELETE_AND_PURGE(_pPropertySpecialAppStatus);
      DELETE_AND_PURGE(_pPropertyTextMsgStatus);
      DELETE_AND_PURGE(_pPropertyTunerStatus);
      DELETE_AND_PURGE(_pPropertyVDLStatus);
      DELETE_AND_PURGE(_pNaviHapticHandOverInterface);
      DELETE_AND_PURGE(_pNaviHapticHandOverList);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      //DELETE_AND_PURGE(_pAppChannelList);
#endif
      DELETE_AND_PURGE(_pUserProfile);
      DELETE_AND_PURGE(_pNaviStartDistanceDetour);
      DELETE_AND_PURGE(_pNaviCancelDistanceDetour);
      DELETE_AND_PURGE(_pPropertyNaviPOIIconList);
      DELETE_AND_PURGE(_pDiagnosticsClientHandler);
   }
   catch (...)
   {
      ETG_TRACE_FATAL(("exception occurred in ~Sds2HmiServer()"));
   }
}


void Sds2HmiServer::buildRegistry() const
{
   OSAL_tIODescriptor regHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_REGISTRY, OSAL_EN_READWRITE);
   if (regHandle != OSAL_ERROR)
   {
      const char regFileName[] = "/dev/root/opt/bosch/base/registry/sds_adapter.reg";
      if ((OSAL_s32IOControl(regHandle, OSAL_C_S32_IOCTRL_BUILD_REG, (intptr_t) regFileName)) == OSAL_OK)
      {
         ETG_TRACE_USR1(("REGISTRY loaded '%s'", regFileName));
      }
      else
      {
         ETG_TRACE_ERR(("FAILED to load REGISTRY '%s'", regFileName));
      }
      OSAL_s32IOClose(regHandle);
   }
}


// TODO jnd2hi extract creation of application objects from server
AhlService* Sds2HmiServer::createSds2HmiService(AhlApp* ahlApp)
{
   AhlService* service = new AhlService(ahlApp, CCA_C_U16_SRV_SAAL, SDS2HMI_SDSFI_C_U16_SERVICE_MAJORVERSION, SDS2HMI_SDSFI_C_U16_SERVICE_MINORVERSION);

   if (service != NULL)
   {
      SAFE_CREATE(_pPopUpService, PopUpService());
      _pSDSStatus = new clSDS_SDSStatus();
      _pMyAppsDataBase = new clSDS_MyAppsDataBase();

      SAFE_CREATE(_pSdsFocusService, SdsFocusService());
      SAFE_CREATE(_pSettingsService, SettingsService());
      SAFE_CREATE(_pVoiceSetting, SystemVoiceSettings(_pSettingsService));
      SAFE_CREATE(_pLanguageMediator, clSDS_LanguageMediator(_pSDSStatus, *_pSettingsService, _vehicleProxy));
      SAFE_CREATE(_pSxmDataSevices, SxmDataServices(_sxmAudioProxy, _sxmCanadianFuelProxy, _sxmFuelProxy, _sxmParkingProxy,
                  _sxmMovieProxy, _sxmSportsProxy, _sxmStocksProxy, _sxmTabWeatherProxy, _naviSDSProxy));
      _pPropertyCommonActionRequest = new clSDS_Property_CommonActionRequest(service, _pLanguageMediator);
      service->vAddFunction(_pPropertyCommonActionRequest);

      _pPropertyNaviPOIIconList =  new clSDS_Property_NaviPOIIconList(service);
      service->vAddFunction(_pPropertyNaviPOIIconList);

      _pLanguageMediator->vSetSDSControl(_pPropertyCommonActionRequest);
      _pQuickDialList = new clSDS_QuickDialList(_phonebookProxy);
      _pQuickDialLisRelationshipUpdater = new clSDS_QuickDialRelationshipUpdater(_phonebookProxy);
      _pUserwords = new clSDS_Userwords(_pSDSStatus, _pPropertyCommonActionRequest, _pQuickDialList);
      SAFE_CREATE(_pPropertyPhoneStatus, clSDS_Property_PhoneStatus(service, _bluetoothSettingsProxy, _telephoneProxy, _phonebookProxy, _smatphoneintProxy,  _pUserwords));
      SAFE_CREATE(_pNaviAddressFormatter, NaviAddressFormatter(_naviSDSProxy));
      _pSessionControl = new clSDS_SessionControl(_pSDSStatus, _pPropertyPhoneStatus, _pPropertyCommonActionRequest, _pLanguageMediator);
      _pDTMFHandler = new clSDS_DTMFHandler(_pSessionControl);
      _pG2P_FactorySetttings = new clSDS_G2P_FactorySettings(_pPropertyCommonActionRequest);

      service->vAddFunction(new clSDS_Property_ActiveSpeaker(service, _pLanguageMediator));
      _pPropertyAudioECNRASRModeStatus =  new clSDS_Property_AudioECNR_ASR_ModeStatus(service, _ecnrProxy);
      service->vAddFunction(_pPropertyAudioECNRASRModeStatus);
      _pIsVehicleMoving = new clSDS_IsVehicleMoving();
      _pPropertyCommonStatus = new clSDS_Property_CommonStatus(service, _pIsVehicleMoving, _vehicleProxy, _tcuProxy);
      service->vAddFunction(_pPropertyCommonStatus);

      service->vAddFunction(new clSDS_Property_SdsStatus(service, _pSDSStatus));

      _pPropertyMediaStatus = new clSDS_Property_MediaStatus(service, _mediaPlayerProxy, _smatphoneintProxy);
      service->vAddFunction(_pPropertyMediaStatus);
      _pPropertyNaviStatus = new clSDS_Property_NaviStatus(service, _naviProxy);
      service->vAddFunction(_pPropertyNaviStatus);
      SAFE_CREATE(_pNaviDetourList, NaviDetourList(_naviProxy, _pPropertyNaviStatus));
      SAFE_CREATE(_pNaviStartDistanceDetour, clSDS_Method_NaviStartDistanceDetour(service, _naviProxy, _pNaviDetourList));
      service->vAddFunction(_pNaviStartDistanceDetour);
      SAFE_CREATE(_pNaviCancelDistanceDetour, clSDS_Method_NaviCancelDistanceDetour(service, _naviProxy));
      service->vAddFunction(_pNaviCancelDistanceDetour);
      service->vAddFunction(_pPropertyPhoneStatus);

      SAFE_CREATE(_pNaviListItems, clSDS_NaviListItems());

      _pNaviPOICategoryList = new NaviPOICategoryList(_naviProxy);
      _pMethodNaviGetSearchLocation = new clSDS_Method_NaviGetSearchLocation(service, _pPropertyNaviStatus, _pNaviPOICategoryList);
      service->vAddFunction(_pMethodNaviGetSearchLocation);
      SAFE_CREATE(_pSdsAudioSource, SdsAudioSource(ahlApp, _ecnrProxy, _audprocProxy, _pPopUpService));
      SAFE_CREATE(_pEarlyStartupPlayer, EarlyStartupPlayer(*_pSdsAudioSource));

      SAFE_CREATE(_pSdsDataHandoverService, SdsDataHandoverService());
      SAFE_CREATE(_pSdsDiagnosisService, SdsDiagnosisService());
      SAFE_CREATE(_pDataHandoverHandler, DataHandoverHandler(_pPropertyCommonActionRequest, _pSdsDataHandoverService));
      _pSdsDataHandoverService->addDataHandoverObserver(_pDataHandoverHandler);

      SAFE_CREATE(_pAudioSourceHandler, AudioSourceHandler(_pSDSStatus, *_pSdsAudioSource, _pSessionControl));
      SAFE_CREATE(_pPropertyAudio_ECNR_EngineParameter, clSDS_Property_Audio_ECNR_EngineParameter(service, _ecnrProxy, *_pSdsAudioSource));
      service->vAddFunction(_pPropertyAudio_ECNR_EngineParameter);

      _pNaviHapticHandOverList = new NaviHapticHandOverList();
      SAFE_CREATE(_pListScreen, clSDS_ListScreen());
      _pListScreen->vAddToList("SR_NAV_HMIList_Address", _pNaviHapticHandOverList);
      _pListScreen->vAddToList("SR_NAV_HMIList_City", _pNaviHapticHandOverList);
      _pListScreen->vAddToList("SR_NAV_HMIList_CityCenter", _pNaviHapticHandOverList);
      _pListScreen->vAddToList("SR_NAV_HMIList_HouseNumber", _pNaviHapticHandOverList);
      _pListScreen->vAddToList("SR_NAV_HMIList_IntersStreet2", _pNaviHapticHandOverList);
      _pListScreen->vAddToList("SR_NAV_HMIList_Intersection", _pNaviHapticHandOverList);

      _pListScreen->vAddToList("SR_NAV_HMIList_State", _pNaviHapticHandOverList);
      _pListScreen->vAddToList("SR_NAV_HMIList_Street", _pNaviHapticHandOverList);
      _pListScreen->vAddToList("SR_NAV_HMIList_Intersection", _pNaviHapticHandOverList);
      _pListScreen->vAddToList("SR_NAV_HMIList_Aza", _pNaviHapticHandOverList);
      _pListScreen->vAddToList("SR_NAV_HMIList_Oaza", _pNaviHapticHandOverList);

      _pMultipleDestinationList = new clSDS_MultipleDestinationsList(_naviProxy);
      _pPOIList = new clSDS_POIList(_naviProxy);
      SAFE_CREATE(_pQuickChargingStation, QuickChargingStation(_naviProxy));

      _pListScreen->vAddToList("SR_NAV_SelectAddress", _pMultipleDestinationList);
      _pListScreen->vAddToList("SR_NAV_SelectHouseNumber", _pMultipleDestinationList);

      _pListScreen->vAddToList("SR_NAV_Ambig_List_CityCenterEur", _pMultipleDestinationList);
      _pListScreen->vAddToList("SR_NAV_Ambig_List_City", _pMultipleDestinationList);
      _pListScreen->vAddToList("SR_NAV_Intersection_List", _pMultipleDestinationList);
      _pListScreen->vAddToList("SR_NAV_SelectPoi", _pPOIList);
      _pListScreen->vAddToList("SR_NAV_POIByCategory", _pNaviPOICategoryList);
      _pListScreen->vAddToList("SR_NAV_POI_AlongRoute_Tab", _pPOIList);
      _pListScreen->vAddToList("SR_NAV_POI_InCity_Tab", _pPOIList);
      _pListScreen->vAddToList("SR_NAV_POI_NearDestination_Tab", _pPOIList);
      _pListScreen->vAddToList("SR_NAV_POI_Nearby_Tab", _pPOIList);
      _pListScreen->vAddToList("SR_NAV_DistanceDetourKm", _pNaviDetourList);
      _pListScreen->vAddToList("SR_NAV_DistanceDetourMile", _pNaviDetourList);
      _pListScreen->vAddToList("SR_NAV_DistanceDetour", _pNaviDetourList);

      _pNaviHapticHandOverInterface = new NaviHapticHandOverInterface(_naviSDSProxy, _pPropertyCommonActionRequest, _pMultipleDestinationList, _pPOIList, _pNaviPOICategoryList, _pNaviHapticHandOverList, _pNaviListItems);
      SAFE_CREATE(_pGuiService, GuiService(_pSessionControl, _pEarlyStartupPlayer, _pAudioSourceHandler, _pDataHandoverHandler, _pNaviHapticHandOverInterface));

      SAFE_CREATE(_pMethodCommonRestoreHMIList, clSDS_Method_CommonRestoreHMIList(service, _pPOIList, _pQuickChargingStation));
      service->vAddFunction(_pMethodCommonRestoreHMIList);
      SAFE_CREATE(_pNaviPOIIconsList, NaviPOIIconsList(_pGuiService, _naviSDSProxy, _pPropertyNaviPOIIconList));
      _pListScreen->vAddToList("SR_NAV_ShowIcons", _pNaviPOIIconsList);
      _pListScreen->vAddToList("SR_NAV_RemoveIcons", _pNaviPOIIconsList);

      SAFE_CREATE(_pInfoFeedsList, clSDS_InfoFeedsList(_tcuUsbMainProxy));

      _pEarlyStartupPlayer->registerObserver(_pGuiService);
      SAFE_CREATE(_pSdsPhoneService, SdsPhoneService(_pUserwords));

      _pPropertyConnectedDeviceStatus = new clSDS_Property_ConnectedDeviceStatus(service, _pSdsPhoneService);
      service->vAddFunction(_pPropertyConnectedDeviceStatus);

      _pMethodNavDataUnRegisterDirectNDSUse = new clSDS_Method_NavDataUnRegisterDirectNDSUse(service, _naviSDSProxy);
      service->vAddFunction(_pMethodNavDataUnRegisterDirectNDSUse);

      _pMethodNavDataRegisterDirectNDSUse = new clSDS_Method_NavDataRegisterDirectNDSUse(service, _naviProxy, _naviSDSProxy, _pMethodNavDataUnRegisterDirectNDSUse);
      service->vAddFunction(_pMethodNavDataRegisterDirectNDSUse);

      _pPropertyNaviCurrentCountryState = new clSDS_Property_NaviCurrentCountryState(service, _naviSDSProxy, _pMethodNavDataRegisterDirectNDSUse);
      service->vAddFunction(_pPropertyNaviCurrentCountryState);

      SAFE_CREATE(_pConfigFlags, clSDS_ConfigurationFlags);
      _pPropertyCommonSDSConfiguration_Stat = new clSDS_Property_CommonSDSConfiguration_Stat(service);
      service->vAddFunction(_pPropertyCommonSDSConfiguration_Stat);

      _pPropertyNavDataDataSetInfo = new clSDS_Property_NavDataDataSetInfo(service, _naviSDSProxy);
      service->vAddFunction(_pPropertyNavDataDataSetInfo);

      _pPropertyCommonSDSConfiguration_Dyna = new clSDS_Property_CommonSDSConfiguration_Dyna(service, _tcuProxy, _naviProxy, _pSettingsService, _pConfigFlags, _pPropertyNavDataDataSetInfo, _pPropertyNaviStatus, _vehicleProxy);
      service->vAddFunction(_pPropertyCommonSDSConfiguration_Dyna);

      _pPropertyCommonSettingsRequest = new clSDS_Property_CommonSettingsRequest(service, _pSettingsService);
      service->vAddFunction(_pPropertyCommonSettingsRequest);
      SAFE_CREATE(_pPropertyInfoServiceStatus, clSDS_Property_InfoServiceStatus(service, _pSxmDataSevices));
      service->vAddFunction(_pPropertyInfoServiceStatus);

      _pPropertySpecialAppStatus = new clSDS_Property_SpecialAppStatus(service, _telephoneProxy);
      service->vAddFunction(_pPropertySpecialAppStatus);
      _pPropertyTunerStatus = new clSDS_Property_TunerStatus(service, _pSDSStatus);
      service->vAddFunction(_pPropertyTunerStatus);
      //service->vAddFunction(new clSDS_Property_VDLStatus(service));
      service->vAddFunction(new clSDS_Property_WeatherStatus(service));
      _pPropertyTextMsgStatus = new clSDS_Property_TextMsgStatus(service, _msgProxy, _telephoneProxy);
      service->vAddFunction(_pPropertyTextMsgStatus);
      _pPropertyVDLStatus = new clSDS_Property_VDLStatus(service);
      service->vAddFunction(_pPropertyVDLStatus);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      //SAFE_CREATE(_pAppChannelList , AppChannelList(_pPropertyVDLStatus, _sdsAppProxy, _managedAppsProxy));
#endif
      /* for SDS2HMI Methods */
      SAFE_CREATE(_pMethodAppsLaunchApplication, clSDS_Method_AppsLaunchApplication(service, _telephoneProxy, *_pGuiService));
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      /* if (_pMethodAppsLaunchApplication)
       {
          _pMethodAppsLaunchApplication->setAppsChannelList(_pAppChannelList);
       }*/
#endif
      service->vAddFunction(_pMethodAppsLaunchApplication);
      service->vAddFunction(new clSDS_Method_CommonInteractionLogger(service, _pSdsDiagnosisService));
      service->vAddFunction(new clSDS_Method_CommonSetAvailableSpeakers(service, _pLanguageMediator));
      service->vAddFunction(new clSDS_Method_CommonSetSDSEvent(service, _pSessionControl));

      SAFE_CREATE(_pVariantLayoutMap, VariantLayoutMap());
      _pDisplay = new clSDS_Display(_pSDSStatus, *_pGuiService, *_pPopUpService);
      SAFE_CREATE(_pMenuManager, clSDS_MenuManager(_pDisplay, _pPropertyCommonActionRequest, _pListScreen, _pSessionControl));
      SAFE_CREATE(_pInfoShowMenuHandler, InfoShowMenuHandler(_pGuiService));

      _pGuiService->setMenuControl(_pMenuManager);
      _pDiagnosticsClientHandler = new DiagnosticsClientHandler(_diagnosticProxy);
      SAFE_CREATE(_pMethodCommonShowDialog, clSDS_Method_CommonShowDialog(service, _pMenuManager, _pListScreen, _pPropertyPhoneStatus, _pGuiService, _pSdsPhoneService, _pDisplay, _pVariantLayoutMap));
      service->vAddFunction(_pMethodCommonShowDialog);
      service->vAddFunction(new clSDS_Method_CommonStartSession(service, *_pSdsAudioSource, *_pGuiService, *_pPropertyAudio_ECNR_EngineParameter, *_pDiagnosticsClientHandler));
      service->vAddFunction(new clSDS_Method_CommonStopSession(service, *_pSdsAudioSource, _pMenuManager, *_pGuiService, *_pDiagnosticsClientHandler));
      service->vAddFunction(new clSDS_Method_CommonSelectListElement(service, _pListScreen));

      _pPropertyCommonCoreSpeechParameters = new clSDS_Property_CommonCoreSpeechParameters(service, *_pGuiService);
      service->vAddFunction(_pPropertyCommonCoreSpeechParameters);

      SAFE_CREATE(_pNaviVoiceTagHandler, NaviVoiceTagHandler(_naviProxy, _pPropertyCommonActionRequest, _pSDSStatus, *_pGuiService));

      _pMethodCommonSetAvailableUserwords = new clSDS_Method_CommonSetAvailableUserwords(service, *_pSdsPhoneService, _phonebookProxy, _pNaviVoiceTagHandler);

      SAFE_CREATE(_pStateNameRequestor, StateNameRequestor(_naviProxy));

      SAFE_CREATE(_pNdsCountryStateRequestor, NdsCountryStateRequestor(_naviSDSProxy));

      SAFE_CREATE(_pCountryNameRequestor, CountryNameRequestor(_naviProxy, _pStateNameRequestor, _pSDSStatus));

      SAFE_CREATE(_pNdsStringRequestor, NdsStringRequestor(_naviSDSProxy));

      SAFE_CREATE(_pNdsPhonemeRequestor, NdsPhonemeRequestor(_naviSDSProxy));

      service->vAddFunction(_pMethodCommonSetAvailableUserwords);
      service->vAddFunction(new clSDS_Method_PhoneGetNumberInfo(service, _pUserwords, _phonebookProxy));
      _pMethodMediaGetDeviceInfo = new clSDS_Method_MediaGetDeviceInfo(service, _mediaPlayerProxy);
      service->vAddFunction(_pMethodMediaGetDeviceInfo);

      _pMethodInfoShowMenu = new clSDS_Method_InfoShowMenu(service, *_pGuiService, _naviProxy, _naviSDSProxy, _pInfoShowMenuHandler);
      service->vAddFunction(_pMethodInfoShowMenu);

      _pNBestList = new clSDS_NBestList();
      _pListScreen->vAddToList("SR_AUD_Ambig_List_Album", _pNBestList);
      _pListScreen->vAddToList("SR_AUD_Ambig_List_Artist", _pNBestList);
      _pListScreen->vAddToList("SR_AUD_Ambig_List_Playlist", _pNBestList);
      _pListScreen->vAddToList("SR_AUD_Ambig_List_Song", _pNBestList);
      _pListScreen->vAddToList("SR_AUD_Media_Nbest", _pNBestList);
      _pListScreen->vAddToList("SR_AUD_SelectMedia", _pNBestList);

      _pListScreen->vAddToList("SR_NAV_Address_Nbest", _pNBestList);
      _pListScreen->vAddToList("SR_NAV_PoiCity_Nbest", _pNBestList);
      _pListScreen->vAddToList("SR_NAV_Country_Nbest", _pNBestList);
      _pListScreen->vAddToList("SR_NAV_State_Nbest", _pNBestList);
      _pListScreen->vAddToList("SR_NAV_Poi_Nbest", _pNBestList);

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      //_pListScreen->vAddToList("SR_APP_Main", _pAppChannelList);
#endif
      _pMethodMediaGetAmbiguityList = new clSDS_Method_MediaGetAmbiguityList(service, _mediaPlayerProxy, _pNBestList);
      service->vAddFunction(_pMethodMediaGetAmbiguityList);
      _pMethodMediaPlay = new clSDS_Method_MediaPlay(service, _mediaPlayerProxy, *_pGuiService, _pMethodMediaGetDeviceInfo);
      service->vAddFunction(_pMethodMediaPlay);
      _pMethodNaviGetContactListEntries = new clSDS_Method_NaviGetContactListEntries(service, _pNaviVoiceTagHandler);
      service->vAddFunction(_pMethodNaviGetContactListEntries);
      service->vAddFunction(new clSDS_Method_MediaGetDataBase(service));
      service->vAddFunction(new clSDS_Method_NaviGetAmbiguityList(service));
      service->vAddFunction(new clSDS_Method_NaviGetCurrentDestination(service, _naviProxy, _pGuiService));

      SAFE_CREATE(_pMethodCommonGetListInfo, clSDS_Method_CommonGetListInfo(service, _pNaviListItems));
      service->vAddFunction(_pMethodCommonGetListInfo);

      _pMethodNaviSelectDestListEntry = new clSDS_Method_NaviSelectDestListEntry(service, _pNaviListItems, _naviProxy, _pNaviVoiceTagHandler);
      service->vAddFunction(_pMethodNaviSelectDestListEntry);

      _pMethodNaviGetWaypointListInfo = new clSDS_Method_NaviGetWaypointListInfo(service, _naviProxy, _naviSDSProxy);
      service->vAddFunction(_pMethodNaviGetWaypointListInfo);

      _pMethodNaviSetDestinationAsWaypoint = new clSDS_Method_NaviSetDestinationAsWaypoint(service, _pMethodNaviGetWaypointListInfo, _naviProxy, *_pGuiService);
      service->vAddFunction(_pMethodNaviSetDestinationAsWaypoint);

      _pMethodVDLGetDatabases = new clSDS_Method_VDLGetDatabases(service);
      service ->vAddFunction(_pMethodVDLGetDatabases);

      _pMethodNaviSetDestinationItem = new clSDS_Method_NaviSetDestinationItem(service, _naviProxy, _pMultipleDestinationList,
            _pPOIList, _pNaviListItems, _pMethodCommonShowDialog, _pCountryNameRequestor, _pQuickChargingStation, _pNaviHapticHandOverInterface, _pLanguageMediator, _pNdsCountryStateRequestor, _pGuiService);
      service->vAddFunction(_pMethodNaviSetDestinationItem);

      _pMethodNaviValidateDestinationEntries = new clSDS_Method_NaviValidateDestinationEntries(service, _naviProxy, _pNdsCountryStateRequestor, _pLanguageMediator);
      service->vAddFunction(_pMethodNaviValidateDestinationEntries);

      _pMethodNavDataUnRegisterDirectNDSUse = new clSDS_Method_NavDataUnRegisterDirectNDSUse(service, _naviSDSProxy);
      service->vAddFunction(_pMethodNavDataUnRegisterDirectNDSUse);

      _pMethod_NavDataAccessModeChanged = new  clSDS_Method_NavDataAccessModeChanged(service, _naviSDSProxy);
      service->vAddFunction(_pMethod_NavDataAccessModeChanged);

      _pMethodNaviSetMapMode = new clSDS_Method_NaviSetMapMode(service, _naviProxy, *_pGuiService, _pNaviPOIIconsList);
      service->vAddFunction(_pMethodNaviSetMapMode);
      service->vAddFunction(new clSDS_Method_NaviStartGuidance(service, *_pGuiService, _pNaviListItems, _naviProxy));
      service->vAddFunction(new clSDS_Method_NaviStopGuidance(service, _naviProxy, *_pGuiService));
      service->vAddFunction(new clSDS_Method_NaviSetZoomSetting(service, _naviProxy, *_pGuiService));
      service->vAddFunction(new clSDS_Method_NaviSetRouteCriteria(service, _naviProxy, *_pGuiService));
      service->vAddFunction(new clSDS_Method_NaviSetNavSetting(service, _naviProxy, *_pGuiService));
      service->vAddFunction(new clSDS_Method_NaviShowNavMenu(service, *_pGuiService, _naviProxy));
      service->vAddFunction(new clSDS_Method_NaviRepeatInstruction(service, _naviProxy, *_pGuiService));
      service->vAddFunction(new clSDS_Method_NaviGetHouseNumberRange(service, _naviProxy));
      service->vAddFunction(new clSDS_Method_NavDataGetCountryStateList(service, _naviSDSProxy));
      service->vAddFunction(new clSDS_Method_NavDataGetStreetAvailability(service, _naviSDSProxy));
      service->vAddFunction(new clSDS_Method_NavDataGetStringAndPhoneme(service, _pNdsStringRequestor, _pNdsPhonemeRequestor));
      service->vAddFunction(new clSDS_Method_PhoneGetDataBases(service));
      service->vAddFunction(new clSDS_Method_PhoneShowMenu(service, *_pGuiService));
      _pMethodPhoneSelectPhone = new clSDS_Method_PhoneSelectPhone(service, _telephoneProxy, *_pGuiService);
      service->vAddFunction(_pMethodPhoneSelectPhone);
      _pMethodPhoneSetPhoneSetting = new clSDS_Method_PhoneSetPhoneSetting(service, _bluetoothSettingsProxy, _telephoneProxy, _pPropertyPhoneStatus, *_pGuiService);
      service->vAddFunction(_pMethodPhoneSetPhoneSetting);
      _pMethodPhoneStartPairing = new clSDS_Method_PhoneStartPairing(service, *_pGuiService);
      service->vAddFunction(_pMethodPhoneStartPairing);

      service->vAddFunction(new clSDS_Method_TunerGetDataBases(service));

      _pMethodTunerSelectBandMemBank = new clSDS_Method_TunerSelectBandMemBank(service, *_pGuiService);
      service->vAddFunction(_pMethodTunerSelectBandMemBank);

      _pMethodPhoneSwitchCall = new clSDS_Method_PhoneSwitchCall(service, _telephoneProxy);
      service->vAddFunction(_pMethodPhoneSwitchCall);
      service->vAddFunction(new clSDS_Method_PhoneSendDTMFDigits(service, _telephoneProxy));
      _pMethodTextMsgSetContent = new clSDS_Method_TextMsgSetContent(service);
      service->vAddFunction(_pMethodTextMsgSetContent);
      service->vAddFunction(new clSDS_Method_VDLGetDatabases(service));

      _pPhonebookList = new clSDS_PhonebookList(_phonebookProxy, _telephoneProxy);
      _pCustomSMSList = new clSDS_CustomSMSList(_msgProxy);
      _pFormatTimeDate = new clSDS_FormatTimeDate(_clockProxy);
      _pRecentCallsList = new clSDS_RecentCallsList(_phonebookProxy, _pFormatTimeDate, _telephoneProxy);
      SAFE_CREATE(_pReadSmsList, clSDS_ReadSmsList(_msgProxy, _phonebookProxy, _pFormatTimeDate, _pSDSStatus));
      _pReadSmsList->setTextListObserver(_pPropertyTextMsgStatus);
      _pPropertyPhoneStatus->setPhoneStatusObserver(_pReadSmsList);
      _pPropertyPhoneStatus->setPhoneStatusObserver(_pRecentCallsList);
      _pPropertyPhoneStatus->setPhoneStatusObserver(_pDTMFHandler);
      _pPropertyPhoneStatus->setPhoneStatusObserver(_pUserwords);
      _pPropertyPhoneStatus->setPhoneStatusObserver(_pMethodCommonSetAvailableUserwords);
      _pPropertyPhoneStatus->setPhoneStatusObserver(_pMethodPhoneSelectPhone);
      _pPropertyPhoneStatus->setPhoneStatusObserver(_pQuickDialList);
      _pPropertyPhoneStatus->setPhoneStatusObserver(_pQuickDialLisRelationshipUpdater);
      _pQuickDialLisRelationshipUpdater->addObserver(_pPropertyCommonSDSConfiguration_Dyna);
      _pMethodCommonShowDialog->setActiveScreenObserver(_pDTMFHandler);
      _pMethodInfoShowMenu->addTemperatureUnitObserver(_pPropertyCommonSDSConfiguration_Dyna);
      _pMethodTextMsgGetInfo = new clSDS_Method_TextMsgGetInfo(service, _pReadSmsList);
      service->vAddFunction(_pMethodTextMsgGetInfo);
      _pMethodTextMsgSelectMessage = new clSDS_Method_TextMsgSelectMessage(service, _pReadSmsList);
      service->vAddFunction(_pMethodTextMsgSelectMessage);
      _pMethodTextMsgGetContent = new clSDS_Method_TextMsgGetContent(service, _msgProxy, _pReadSmsList, _pSdsPhoneService);
      service->vAddFunction(_pMethodTextMsgGetContent);

      SAFE_CREATE(_pParkingList, clSDS_ParkingList(_sxmParkingProxy, _naviProxy, _naviSDSProxy, _vehicleProxy, _pGuiService));

      SAFE_CREATE(_pFuelPriceList, clSDS_FuelPriceList(_sxmCanadianFuelProxy, _sxmFuelProxy, _naviProxy, _naviSDSProxy, _vehicleProxy, _pGuiService));

      _pMethodTextMsgSetNumber = new clSDS_Method_TextMsgSetNumber(service, _pListScreen, _pPhonebookList, _phonebookProxy);
      service->vAddFunction(_pMethodTextMsgSetNumber);
      _pListScreen->vAddToList("SR_PHO_Quickdial", _pQuickDialList);
      _pListScreen->vAddToList("SR_PHO_NbestList", _pNBestList);
      _pListScreen->vAddToList("SR_PHO_Quickdial_Send", _pQuickDialList);
      _pListScreen->vAddToList("SR_PHO_OutCall_List", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_MissCall_List", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_InCall_List", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_SendCustom", _pCustomSMSList);
      _pListScreen->vAddToList("SR_PHO_ReadText", _pReadSmsList);
      _pListScreen->vAddToList("SR_GLO_Nbest_List", _pNBestList);
      _pListScreen->vAddToList("SR_INF_Parking", _pParkingList);
      _pListScreen->vAddToList("SR_INF_Sort_List_Distance", _pFuelPriceList);
      _pListScreen->vAddToList("SR_INF_Sort_List_Price", _pFuelPriceList);
      _pListScreen->vAddToList("SR_INF_InformationFeeds", _pInfoFeedsList);
      _pListScreen->vAddToList("SR_PHO_RecentCall_Tab", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_InCall_SendText_Tab", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_InCall_Tab", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_MissCall_SendText_Tab", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_MissCall_Tab", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_OutCall_SendText_Tab", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_OutCall_Tab", _pRecentCallsList);
      _pListScreen->vAddToList("SR_PHO_RecentCall_SendText_Tab", _pRecentCallsList);

      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_STATE, _pNaviHapticHandOverList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_CITY, _pNaviHapticHandOverList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_CITYCENTER, _pNaviHapticHandOverList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_HOUSE_NUMBR, _pNaviHapticHandOverList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_INTERSECTION, _pNaviHapticHandOverList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_INTERSECT_STREET1, _pNaviHapticHandOverList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_INTERSECT_STREET2, _pNaviHapticHandOverList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_STREET, _pNaviHapticHandOverList);

      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_MISSED_CALLS, _pRecentCallsList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_ANSWERED_CALLS, _pRecentCallsList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_DIALLED_CALLS, _pRecentCallsList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_ALL_CALLS, _pRecentCallsList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_CUSTOM_SMS, _pCustomSMSList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_RECEIVED_SMS, _pReadSmsList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_USERWORDS, _pQuickDialList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PARKING, _pParkingList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_FUEL_PRICES, _pFuelPriceList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_FUEL_DISTANCES, _pFuelPriceList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_INFO_FEEDS, _pInfoFeedsList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_NAV_DISTANCE_DETOUR, _pNaviDetourList);

      _pPreviousDestinationsList =  new clSDS_PreviousDestinationsList(_naviProxy, _pNaviAddressFormatter, _pGuiService);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_NAV_PREV_DESTINATIONS, _pPreviousDestinationsList);
      _pListScreen->vAddToList("SR_NAV_PrevDestinations", _pPreviousDestinationsList);

      _pAddressBookList = new clSDS_AddressBookList(_naviProxy, _pNaviAddressFormatter, _pGuiService);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_ADDRESSBOOK, _pAddressBookList);
      _pListScreen->vAddToList("SR_NAV_AddrBook_List", _pAddressBookList);

      // _pListScreen->vAddToList("SR_NAV_SelectHousenumber", _pAddressBookList);

      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_ALL_CHARGE_STATIONS, _pQuickChargingStation);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_QUICK_CHARGE_STATIONS, _pQuickChargingStation);

      _pListScreen->vAddToList("SR_NAV_POI_List", _pQuickChargingStation);

//      _pListScreen->vAddToList(SR_NAV_DISAMBIG_LIST, new clSDS_MultipleDestinationsList());
//      _pListScreen->vAddToList(SR_PHO_AMBIG_LIST, new clSDS_ContactNumberList(_pPhonebookList));

      _pContactNumberList = new clSDS_ContactNumberList(_pPhonebookList);

      SAFE_CREATE(_pPhonebookContacts, PhonebookContacts(_phonebookProxy, _telephoneProxy));
      SAFE_CREATE(_pAmbigContactList, clSDS_AmbigContactList(_pPhonebookContacts));
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_PB_ALL_ENTRIES, _pAmbigContactList);
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_VB_ALL_ENTRIES, _pAmbigContactList);
      _pListScreen->vAddToList("SR_PHO_Ambig_List_Contact", _pAmbigContactList);
      _pListScreen->vAddToList("SR_PHO_Ambig_List_Contact_Send", _pAmbigContactList);
      _pListScreen->vAddToList("SR_PHO_Ambig_List_Contact_Rel", _pAmbigContactList);
      _pListScreen->vAddToList("SR_PHO_SelectContact", _pAmbigContactList);

      SAFE_CREATE(_pAmbigNumberList, clSDS_AmbigNumberList(_pPhonebookContacts));
      _pMethodCommonGetListInfo->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_CONTACT_AMBIGUITY, _pAmbigNumberList);
      _pListScreen->vAddToList("SR_PHO_Ambig_List_Number", _pAmbigNumberList);
      _pListScreen->vAddToList("SR_PHO_Ambig_List_Number_Send", _pAmbigNumberList);
      _pListScreen->vAddToList("SR_PHO_Ambig_List_Number_Rel", _pAmbigNumberList);
      _pListScreen->vAddToList("SR_PHO_SelectPhoneNumber", _pAmbigNumberList);
      _pListScreen->vAddToList("SR_PHO_SelectNumber", _pAmbigNumberList);

      _pNaviListItems->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_NAV_PREV_DESTINATIONS, _pPreviousDestinationsList);
      _pNaviListItems->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_ADDRESSBOOK, _pAddressBookList);
      _pNaviListItems->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_FUEL_PRICES, _pFuelPriceList);
      _pNaviListItems->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_FUEL_DISTANCES, _pFuelPriceList);
      _pNaviListItems->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PARKING, _pParkingList);

      _pMethodTextMsgSend = new clSDS_Method_TextMsgSend(service, _msgProxy, _phonebookProxy, _telephoneProxy);
      service->vAddFunction(_pMethodTextMsgSend);

      _pMethodTextMsgCallbackSender = new clSDS_Method_TextMsgCallbackSender(service, _telephoneProxy, _pAudioSourceHandler, *_pGuiService);
      service->vAddFunction(_pMethodTextMsgCallbackSender);

      _pMethodPhoneRedialLastNumber = new clSDS_Method_PhoneRedialLastNumber(service, _pRecentCallsList, _telephoneProxy, _pAudioSourceHandler, *_pGuiService);
      service->vAddFunction(_pMethodPhoneRedialLastNumber);

      _pMethodPhoneGetContactListEntries = new clSDS_Method_PhoneGetContactListEntries(service, _pPhonebookList, _pUserwords, _phonebookProxy, _naviProxy, _pGuiService);
      service->vAddFunction(_pMethodPhoneGetContactListEntries);
      service->vAddFunction(new clSDS_Method_PhoneSetContact(service, _pPhonebookList));

      _pMethodPhoneDialNumber = new clSDS_Method_PhoneDialNumber(service, _pListScreen, _pPhonebookContacts, _telephoneProxy, _phonebookProxy,
            _pAudioSourceHandler, *_pGuiService);
      service->vAddFunction(_pMethodPhoneDialNumber);

      _pMethodPhoneDialContact = new clSDS_Method_PhoneDialContact(service, _telephoneProxy, _phonebookProxy, _pAudioSourceHandler, *_pGuiService);
      service->vAddFunction(_pMethodPhoneDialContact);

      SAFE_CREATE(_pSxmAudioChannelList, clSDS_SXMAudioChannelList(_sxmAudioProxy, _sxmPhoneticsProxy, _sdsSxmProxy));
      _pSxmAudioChannelList->setSXMTunerStateObserver(_pPropertyTunerStatus);

      service->vAddFunction(new clSDS_Method_CommonGetHmiElementDescription(service, _pMenuManager, _pListScreen));
      SAFE_CREATE(_pMethodCommonGetHmiListDescription, clSDS_Method_CommonGetHmiListDescription(service));
      service->vAddFunction(_pMethodCommonGetHmiListDescription);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_ADDRESSBOOK, _pAddressBookList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_NAV_PREV_DESTINATIONS, _pPreviousDestinationsList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_MISSED_CALLS, _pRecentCallsList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_ANSWERED_CALLS, _pRecentCallsList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_DIALLED_CALLS, _pRecentCallsList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_ALL_CALLS, _pRecentCallsList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_INFO_FEEDS, _pInfoFeedsList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_NAV_DISTANCE_DETOUR, _pNaviDetourList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_ALL_CHARGE_STATIONS, _pQuickChargingStation);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_EVE_QUICK_CHARGE_STATIONS, _pQuickChargingStation);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_POI_CATEGORIES, _pNaviPOICategoryList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_NAV_POI_ICON, _pNaviPOIIconsList);
      _pMethodCommonGetHmiListDescription->vAddList(sds2hmi_fi_tcl_e8_HMI_ListType::FI_EN_LIST_PHONE_USERWORDS, _pQuickDialList);

      _pMethodContactsGetAmbiguityList = new clSDS_Method_ContactsGetAmbiguityList(service, _phonebookProxy, _pAmbigContactList, _pAmbigNumberList);
      service->vAddFunction(_pMethodContactsGetAmbiguityList);

      SAFE_CREATE(_pFmChannelList, clSDS_FmChannelList(_sdsFmProxy, _tunerProxy));
      _pFmChannelList->setFmChannelListObserver(_pPropertyTunerStatus);

      _pFMNBestList = new clSDS_FMNBestList(_pFmChannelList);
      _pListScreen->vAddToList("SR_AUD_Nbest_List_FM", _pFMNBestList);
      _pListScreen->vAddToList("SR_AUD_Station_Nbest", _pNBestList);
      //_pListScreen->vAddToList("SR_AUD_Station_Nbest", _pFMNBestList);

      _pFMTemplate = new clSDS_FMTemplate(_pFmChannelList);
      _pDisplay->vAddTemplateHandler("TuneFMName", _pFMTemplate);
      _pDisplay->vAddTemplateHandler("Number_FMName", _pFMTemplate);

      SAFE_CREATE(_pAmChannelList, clSDS_AmChannelList(_sdsAmProxy, _tunerProxy));
      _pAmChannelList->setAmChannelListObserver(_pPropertyTunerStatus);

      SAFE_CREATE(_pDabChannelList, clSDS_DabChannelList(_sdsDabProxy, _tunerDabProxy));
      _pDabChannelList->setDabChannelListObserver(_pPropertyTunerStatus);

      //SAFE_CREATE(_pTVStationList, clSDS_TVStationList(_sdsTvProxy, _tvServiceProxy));
      //_pTVStationList->setTVChannelListObserver(_pPropertyTunerStatus);

      _pMethodTunerSelectStation = new clSDS_Method_TunerSelectStation(service, _tunerProxy,
            *_pGuiService, _sxmAudioProxy, _tunerMasterProxy, _pFmChannelList, _pAmChannelList, _tunerDabProxy, _pDabChannelList);
      service->vAddFunction(_pMethodTunerSelectStation);

      //SAFE_CREATE(_pMethodTVSelectStation, clSDS_Method_TVSelectStation(service, *_pGuiService, _pTVStationList, _tvServiceProxy));
      //service->vAddFunction(_pMethodTVSelectStation);

      _pMethodCommonSetActiveApplication = new clSDS_Method_CommonSetActiveApplication(service, *_pGuiService, _commandInterfaceProxy);
      service->vAddFunction(_pMethodCommonSetActiveApplication);

      SAFE_CREATE(_pTunerBandRange, clSDS_TunerBandRange(_tunerProxy));

      SAFE_CREATE(_pAcrHandler, AcrHandler(_acrProxy));

      clSDS_ConfigurationFlags::readConfigFile();

      SAFE_CREATE(_pMethodPhoneUpdatePhonebook, clSDS_Method_PhoneUpdatePhonebook(service, _phonebookProxy, _telephoneProxy));
      service->vAddFunction(_pMethodPhoneUpdatePhonebook);
      _pAmbigNumberList->registerObservers(_pMethodPhoneUpdatePhonebook);

      SAFE_CREATE(_pUserProfile, UserProfile(_profileProxy, _pVoiceSetting));

      _pTraceCommandAdapter = new TraceCommandAdapter(_pGuiService, _pPopUpService, _pEarlyStartupPlayer, _pMethodNaviSetDestinationItem, _pPropertyNaviCurrentCountryState, _pMethodCommonShowDialog, _pDisplay);
   }

   return service;
}


void Sds2HmiServer::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR1(("Sds2HmiServer::onAvailable for port %s", proxy->getPortName().c_str()));

   for (std::vector<asf::core::ServiceAvailableIF*>::const_iterator iter = _serviceAvailableDelegates.begin(); iter != _serviceAvailableDelegates.end(); ++iter)
   {
      if ((*iter) != NULL)
      {
         (*iter)->onAvailable(proxy, stateChange);
      }
   }
}


void Sds2HmiServer::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   for (std::vector<asf::core::ServiceAvailableIF*>::const_iterator iter = _serviceAvailableDelegates.begin(); iter != _serviceAvailableDelegates.end(); ++iter)
   {
      if ((*iter) != NULL)
      {
         (*iter)->onUnavailable(proxy, stateChange);
      }
   }
}


void Sds2HmiServer::createproxies()
{
   _audprocProxy = org::bosch::audproc::service::ServiceProxy::createProxy("audprocServicePort", *this);
   _bluetoothSettingsProxy = MOST_BTSet_FI::MOST_BTSet_FIProxy::createProxy("sds2phoneBTSetPort", *this);
   _clockProxy = clock_main_fi::Clock_main_fiProxy::createProxy("clockFiPort", *this);
   _ecnrProxy = org::bosch::ecnr::service::ServiceProxy::createProxy("ecnrServicePort", *this);
   _mediaPlayerProxy = mplay_MediaPlayer_FI::Mplay_MediaPlayer_FIProxy::createProxy("sds2mediaPlayerFiPort", *this);
   _msgProxy = MOST_Msg_FI::MOST_Msg_FIProxy::createProxy("sds2phoneMsgPort", *this);
   _naviProxy = org::bosch::cm::navigation::NavigationService::NavigationServiceProxy::createProxy("naviServicePort", *this);
   _naviSDSProxy = org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceProxy::createProxy("naviSDSServicePort", *this);
   _phonebookProxy = MOST_PhonBk_FI::MOST_PhonBk_FIProxy::createProxy("phoneBookPort", *this);
   _sdsFmProxy = sds_fm_fi::SdsFmService::SdsFmServiceProxy::createProxy("sdsFmServicePort", *this);
   _sdsAmProxy = sds_am_fi::SdsAmService::SdsAmServiceProxy::createProxy("sdsAmServicePort", *this);
   _sdsDabProxy = sds_dab_fi::SdsDabService::SdsDabServiceProxy::createProxy("sdsDabServicePort", *this);
   _sdsSxmProxy = sds_sxm_fi::SdsSxmService::SdsSxmServiceProxy::createProxy("sdsSxmServicePort", *this);
   _sdsAppProxy = sds_app_fi::SdsAppService::SdsAppServiceProxy::createProxy("sdsAppServicePort", *this);
   _sxmAudioProxy = sxm_audio_main_fi::Sxm_audio_main_fiProxy::createProxy("sdsAudioFiPort", *this);
   _sxmCanadianFuelProxy = sxm_canadian_fuel_main_fi::Sxm_canadian_fuel_main_fiProxy::createProxy("sds2SxmCanadianFuelFiPort", *this);
   _sxmFuelProxy = sxm_fuel_main_fi::Sxm_fuel_main_fiProxy::createProxy("sds2sxmFuelFiPort", *this);
   _sxmMovieProxy = sxm_movies_main_fi::Sxm_movies_main_fiProxy::createProxy("sxmMoviesFiPort", *this);
   _sxmParkingProxy = sxm_parking_main_fi::Sxm_parking_main_fiProxy::createProxy("sds2sxmParkingFiPort", *this);
   _sxmPhoneticsProxy = sxm_phonetics_main_fi::Sxm_phonetics_main_fiProxy::createProxy("sdsPhoneticsFiPort", *this);
   _sxmSportsProxy = sxm_sports_main_fi::Sxm_sports_main_fiProxy::createProxy("sds2sxmSportsFiPort", *this);
   _sxmStocksProxy = sxm_stocks_main_fi::Sxm_stocks_main_fiProxy::createProxy("sds2sxmStocksFiPort", *this);
   _sxmTabWeatherProxy = sxm_tabweather_main_fi::Sxm_tabweather_main_fiProxy::createProxy("sds2sxmTabWeatherFiPort", *this);
   _tcuProxy = tcu_main_fi::Tcu_main_fiProxy::createProxy("tcuFiPort", *this);
   _tcuUsbMainProxy = tcu_usb_main_fi::Tcu_usb_main_fiProxy::createProxy("sdstcuUsbMainFiPort", *this);
   _telephoneProxy = MOST_Tel_FI::MOST_Tel_FIProxy::createProxy("phoneTelPort", *this);
   _tunerMasterProxy = tunermaster_main_fi::Tunermaster_main_fiProxy::createProxy("sdstunermasterFiPort", *this);
   _tunerProxy = tuner_main_fi::Tuner_main_fiProxy::createProxy("tunerFiPort", *this);
   _vehicleProxy = VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy::createProxy("sds2vehicledataPort", *this);
   _acrProxy = CMB_ACR_FIProxy::createProxy("acrPort", *this);
   _smatphoneintProxy = Smartphoneint_main_fiProxy::createProxy("spiFiPort", *this);
   _tunerDabProxy = dabtuner_main_fi::Dabtuner_main_fiProxy::createProxy("sdsdabFiPort", *this);
   _sdsTvProxy = sds_tv_fi::SdsTvService::SdsTvServiceProxy::createProxy("tvDbServicePort", *this);
   //_tvServiceProxy = org::bosch::cm::fc_dtv::serverInterface::ServerInterfaceProxy::createProxy("dtvServicePort", *this);
   _profileProxy = bosch::cm::profile::ProfileProxy::createProxy("userProfilePort", *this);
   _commandInterfaceProxy = org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy::createProxy("commandInterfacePort", *this);
   //_hvacPIVIProxy = HVACPIVI_MAIN_FIProxy::createProxy("hvacpiviFiPort", *this);
   _diagnosticProxy = Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy::createProxy("diagnosticsFiPort", *this);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
   createRenaultSpecificProxies();
#endif
}


#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
void Sds2HmiServer::createRenaultSpecificProxies()
{
   // _managedAppsProxy = bosch::cm::ai::hmi::managedapps::ManagedApps::ManagedAppsProxy::createProxy("managedAppsPort", *this);
}


#endif
void Sds2HmiServer::registerServiceAvailableDelegates()
{
   addServiceAvailableDelegate(_pCustomSMSList);
   addServiceAvailableDelegate(_pFmChannelList);
   addServiceAvailableDelegate(_pAmChannelList);
   //addServiceAvailableDelegate(_pAppChannelList);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
   //addServiceAvailableDelegate(_pAppChannelList);
#endif
   addServiceAvailableDelegate(_pDabChannelList);
   addServiceAvailableDelegate(_pFormatTimeDate);
   addServiceAvailableDelegate(_pFuelPriceList);
   addServiceAvailableDelegate(_pLanguageMediator);
   addServiceAvailableDelegate(_pParkingList);
   addServiceAvailableDelegate(_pPhonebookList);
   addServiceAvailableDelegate(_pQuickDialList);
   addServiceAvailableDelegate(_pQuickDialLisRelationshipUpdater);
   addServiceAvailableDelegate(_pReadSmsList);
   addServiceAvailableDelegate(_pRecentCallsList);
   addServiceAvailableDelegate(_pSxmAudioChannelList);
   addServiceAvailableDelegate(_pTunerBandRange);
   addServiceAvailableDelegate(_pPreviousDestinationsList);
   addServiceAvailableDelegate(_pAddressBookList);
   addServiceAvailableDelegate(_pPOIList);
   addServiceAvailableDelegate(_pCountryNameRequestor);
   addServiceAvailableDelegate(_pStateNameRequestor);
   addServiceAvailableDelegate(_pQuickChargingStation);
   addServiceAvailableDelegate(_pNaviPOIIconsList);
   addServiceAvailableDelegate(_pNaviAddressFormatter);

   addServiceAvailableDelegate(_pMethodAppsLaunchApplication);
   addServiceAvailableDelegate(_pMethodInfoShowMenu);
   addServiceAvailableDelegate(_pMethodContactsGetAmbiguityList);
   addServiceAvailableDelegate(_pMethodMediaGetDeviceInfo);
   addServiceAvailableDelegate(_pMethodMediaPlay);
   addServiceAvailableDelegate(_pMethodNaviGetWaypointListInfo);
   addServiceAvailableDelegate(_pMethodNaviSelectDestListEntry);
   addServiceAvailableDelegate(_pMethodNaviSetDestinationItem);
   addServiceAvailableDelegate(_pMethodNaviValidateDestinationEntries);
   addServiceAvailableDelegate(_pMethodNaviSetMapMode);
   addServiceAvailableDelegate(_pMethodPhoneRedialLastNumber);
   addServiceAvailableDelegate(_pMethodPhoneSetPhoneSetting);
   addServiceAvailableDelegate(_pMethodPhoneSwitchCall);
   addServiceAvailableDelegate(_pMethodPhoneUpdatePhonebook);
   addServiceAvailableDelegate(_pMethodTextMsgSend);

   addServiceAvailableDelegate(_pPropertyAudioECNRASRModeStatus);
   addServiceAvailableDelegate(_pPropertyCommonSDSConfiguration_Dyna);
   addServiceAvailableDelegate(_pPropertyCommonStatus);
   addServiceAvailableDelegate(_pPropertyMediaStatus);
   addServiceAvailableDelegate(_pPropertyNaviCurrentCountryState);
   addServiceAvailableDelegate(_pPropertyNaviStatus);
   addServiceAvailableDelegate(_pPropertyPhoneStatus);
   addServiceAvailableDelegate(_pPropertySpecialAppStatus);
   addServiceAvailableDelegate(_pPropertyTextMsgStatus);
   addServiceAvailableDelegate(_pPropertyNavDataDataSetInfo);
   addServiceAvailableDelegate(_pMethodNavDataRegisterDirectNDSUse);
   addServiceAvailableDelegate(_pNaviDetourList);

   addServiceAvailableDelegate(_pAcrHandler);
   addServiceAvailableDelegate(_pNaviPOICategoryList);
   addServiceAvailableDelegate(_pNaviVoiceTagHandler);
   addServiceAvailableDelegate(_pSxmDataSevices);
   //addServiceAvailableDelegate(_pTVStationList);
   addServiceAvailableDelegate(_pNaviHapticHandOverInterface);
   addServiceAvailableDelegate(_pUserProfile);
   addServiceAvailableDelegate(_pDiagnosticsClientHandler);
}


void Sds2HmiServer::addServiceAvailableDelegate(asf::core::ServiceAvailableIF* obs)//lint -e429
{
   _serviceAvailableDelegates.push_back(obs);
}
