/**************************************************************************//**
* \file     tunerSessionManagement.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef tunerSessionManagement_h
#define tunerSessionManagement_h


#include "datatypes/tunerDatatypes.h"

#define READ_DRM_MODULATION_BIT 0x80000000
#define LW_BIT_SET 0x00000002
#define MW_BIT_SET 0x00000004
#define LW_MW_BITS_SET 0x00000006

namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         struct stTunerSessionManagement
         {
            tuner::common::enSourceId oSourceId;
            tuner::common::enBand oBand;
            tuner::common::enSourceType oSourceType;
            tuner::common::enTunerClient oTunerClient;
         };
		 
		 struct stSrcActivityTunerStateMap
		 {
        	 tuner::common::enSrcActivity srcActivity;
        	 tuner::common::enTunerState  tunerState;
		 };

         struct stSrcActivityResponseTimeMap
         {
            tuner::common::enSrcActivity tunerSrcActivity;
            int timeInMs;
         };
      }
   }
}

	bool bIsSourceAvailable(tuner::common::enSourceId sourceId);
	tuner::common::enBand oGetBand(tuner::common::enSourceId sourceId);
	tuner::common::enTunerState oGetTunerState(tuner::common::enSrcActivity srcActivity);
	tuner::sessionManagement::audio::stTunerSessionManagement oGetSource(tuner::common::enSourceId sourceId);
	bool bIsStaticSource(tuner::common::enSourceId sourceId);
	bool bIsDynamicSource(tuner::common::enSourceId sourceId);
	bool bIsTemporarySource(tuner::common::enSourceId sourceId);
	int getMaxWaitTime(tuner::common::enSrcActivity tunerSrcActivity);
	tuner::common::enTunerClient oGetTunerClient(tuner::common::enSourceId sourceId);
	tuner::common::enSourceId oGetTunerSourceId(tuner::common::enBand bandID);
	void vSetMidwTunerBand(unsigned int u32CombiBand, unsigned int u32AvailableBand);
	void vTunerSetCB1forDRMandBandForAM(unsigned int u32CombiBand, unsigned int u32AvailableBand);
	void vTunerSetNoneforDRMandBandForAM(unsigned int u32CombiBand, unsigned int u32AvailableBand);



#endif // tunerSessionManagement_h
