/**************************************************************************//**
* \file     clMuteRequest.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clMuteRequest_h
#define clMuteRequest_h


#include "datatypes/tunerDatatypes.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "datatypes/tString.h"


namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clMuteRequest
         {
        	 bool bStoredMuteInterrupt;
        	 tuner::common::enSourceId storedMuteSourceId;
        	 bool bStoreMuteRequest;
            public:
			   tuner::common::enSourceId muteSourceId;

               enum enMuteRequestState
               {
                  REQUEST_PENDING,
                  REQUEST_IN_PROGRESS,
                  REQUEST_COMPLETED,
               };
               clMuteRequest();
               virtual ~clMuteRequest();
               enMuteRequestState state;
               tuner::common::enMuteState muteState;
               bool bBlockSourceChange;
               
               bool bIsRequestPending();
               bool bIsRequestInProgress();
               bool bIsRequestCompleted();
               bool bMute();
               bool bDeMute();
               void vReset();
               bool bIsMuteRequestStored();
               bool bIsToBeProcessStoredMuteRequest(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSourceActivity, tuner::common::enBand tunerBand);
               void vStoreMuteRequest(tuner::common::enSourceId tunerSourceId, bool bInterrupt);
               void vClearStoredMuteRequest();
               bool oGetStoredMuteInterrupt();
               tuner::common::enSourceId oGetStoredSourceId();
         };
      }
   }
}

#endif // clMuteRequest_h
