/**************************************************************************//**
* \file     clDirectFrequencyRequest.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clDirectFrequencyRequest_h
#define clDirectFrequencyRequest_h


#include "datatypes/tunerDatatypes.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "datatypes/tString.h"


namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clDirectFrequencyRequest
         {
            public:
               enum enDirectFrequencyRequestState
               {
                  REQUEST_PENDING,
                  REQUEST_IN_PROGRESS,
                  REQUEST_COMPLETED,
               };
               clDirectFrequencyRequest();
               virtual ~clDirectFrequencyRequest();
               enDirectFrequencyRequestState state;
               unsigned int frequency;
               tuner::common::enSourceId sourceId;
               
               bool bIsRequestPending();
               bool bIsRequestInProgress();
               bool bIsRequestCompleted();
               void vReset();
         };
      }
   }
}

#endif // clDirectFrequencyRequest_h
