/**************************************************************************//**
* \file     clAudioSessionState.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clAudioSessionState_h
#define clAudioSessionState_h


#include "datatypes/tunerDatatypes.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "datatypes/tString.h"


namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clAudioSessionState
         {
            public:
               clAudioSessionState();
               virtual ~clAudioSessionState();
               bool bIsSrcAllocate();
               bool bIsSrcChangeInProgress();
               bool bIsSrcChangeRequested();
               bool bIsSrcAllocateInProgress();
               bool bIsSrcChangeCompleted();
               bool bIsSrcChangeFailed();
               bool bIsSrcChangeAllowed();
               bool bSrcOn();
               bool bSrcOff();
               bool bSrcPause();
               void vReset();

               tuner::common::enSourceId sourceId;
               tuner::common::enSessionState state;
               tuner::common::enSrcActivity tunerSrcActivity;
               tuner::common::enBand tunerBand;
               tunerString inputDevice;
         };
      }
   }
}

#endif // clAudioSessionState_h
