/**************************************************************************//**
* \file     clAudioSessionState.cpp
*
*           clAudioSessionState method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "sessionManagement/audio/clAudioSessionState.h"


using namespace tuner::sessionManagement::audio;
using namespace tuner::common;


/**************************************************************************//**
* Constructor
******************************************************************************/
clAudioSessionState::clAudioSessionState():
sourceId(SOURCEID_LIMIT)
, state(SRC_CHANGE_COMPLETED)
, tunerSrcActivity(SRCACTIVITY_UNKNOWN)
, tunerBand(BAND_LIMIT)
, inputDevice("")
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clAudioSessionState::~clAudioSessionState()
{
}


/**************************************************************************//**
* 
******************************************************************************/
bool clAudioSessionState::bIsSrcAllocate()
{
   if (state == tuner::common::SRC_ALLOCATED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clAudioSessionState::bIsSrcAllocateInProgress()
{
   if (state == tuner::common::SRC_ALLOCATE_IN_PROGRESS)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAudioSessionState::bIsSrcChangeInProgress()
{
   if (state == tuner::common::SRC_CHANGE_IN_PROGRESS)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clAudioSessionState::bIsSrcChangeRequested()
{
   if (state == tuner::common::SRC_CHANGE_REQUESTED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clAudioSessionState::bIsSrcChangeCompleted()
{
   if (state == tuner::common::SRC_CHANGE_COMPLETED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clAudioSessionState::bIsSrcChangeFailed()
{
   if (state == tuner::common::SRC_CHANGE_FAILED)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAudioSessionState::bIsSrcChangeAllowed()
{
   if (state == tuner::common::SRC_CHANGE_NOT_ALLOWED)
   {
      return false;
   }
   return true;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAudioSessionState::bSrcOn()
{
   if (tunerSrcActivity == tuner::common::SRCON)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clAudioSessionState::bSrcOff()
{
   if (tunerSrcActivity == tuner::common::SRCOFF)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
* 
******************************************************************************/
bool clAudioSessionState::bSrcPause()
{
   if (tunerSrcActivity == tuner::common::SRCPAUSE)
   {
      return true;
   }
   return false;
}


/**************************************************************************//**
*
******************************************************************************/
void clAudioSessionState::vReset()
{
	sourceId = SOURCEID_LIMIT;
	state = tuner::common::SRC_CHANGE_COMPLETED;
	tunerSrcActivity = SRCACTIVITY_UNKNOWN;
	tunerBand = BAND_LIMIT;
}
