/**************************************************************************//**
* \file     clAudioControl.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clAudioControl_h
#define clAudioControl_h


#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "datatypes/tunerDatatypes.h"


namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
      	 class clAudioInterface;


         class clAudioControl
         {
         public:
            virtual ~clAudioControl();
            clAudioControl();
            void vInformSourceAvailability(tuner::common::enSourceId tunerSourceId,
            		tuner::common::enAudioSrcAvailability,tuner::common::enAudioSourceAvailabiltyReason);
            void vSendSrcChangeResult(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSourceActivity);
            void vSetAudioImpl(tuner::sessionManagement::audio::clAudioInterface* poImpl);
            void vRequestMute(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState) ;
         };
      }
   }
}

#endif // clAudioControl_h
