/******************************************************************
*FILE: clConfigDefines.h
*SW-COMPONENT:
*DESCRIPTION:
*COPYRIGHT:  2016 Robert Bosch GmbH
*AUTHOR:auj1kor
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/


#ifndef CLCONFIGDEFINES_H_
#define CLCONFIGDEFINES_H_


enum enTunerArea
{
  enPSA_TunerArea_Europe                 = 0x00,
  enPSA_TunerArea_Japan	                 = 0x01,
  enPSA_TunerArea_South_America          = 0x02,
  enPSA_TunerArea_Asia_China           	 = 0x03,
  enPSA_TunerArea_Arabia				 = 0x04,
  enPSA_TunerArea_North_America  	     = 0x05,
  enPSA_TunerArea_Korea					 = 0x06,
  enPSA_TunerArea_Brazil				 = 0x07
};

enum enTunerAreaExt
{
  enCRY_TunerArea_China 				 = 0x01,
  enCRY_TunerArea_Argentina 	         = 0x02,
  enCRY_TunerArea_Russia 		         = 0x03,
  enCRY_TunerArea_Chile 				 = 0x06,
  enCRY_TunerArea_Colombia 	             = 0x07,
  enCRY_TunerArea_Iran 		             = 0x08,
  enCRY_TunerArea_GCC	                 = 0x0b

};

enum enAntennaInfo
{
	enKdsCMVariantCoding_idx_FM1_AntennaInfo 	= 0x00,
	enKdsCMVariantCoding_idx_FM2_AntennaInfo 	= 0x01,
	enKdsCMVariantCoding_idx_DAB_AntennaInfo 	= 0x02,
	enKdsCMVariantCoding_idx_GPS_AntennaInfo	= 0x03,
	enKdsCMVariantCoding_idx_DTV1_AntennaInfo	= 0x04,
	enKdsCMVariantCoding_idx_DTV2_AntennaInfo	= 0x05,
	enKdsCMVariantCoding_idx_DTV3_AntennaInfo	= 0x06,
	enKdsCMVariantCoding_idx_DTV4_AntennaInfo	= 0x07,
	enKdsCMVariantCoding_idx_DAB2_AntennaInfo   = 0x08
};

enum enCMExtPowerSupplyType
{
	enunknown,
	enELMOS1_1, 
	enELMOS1_2, 
	enELMOS2_1, 
	enELMOS2_2, 
	enInfineonTLF4277_1,
	enMAXIM_16946, 
	enInfineonTLF4277_2,
	enELMOS3_1,
	enELMOS3_2,
	enELMOS4_1,
	enELMOS4_2,
	enMAX20084_1_1,
	enMAX20084_1_2,
	enMAX20084_2_1,
	enMAX20084_2_2,
	enMAX20084_3_1,
	enMAX20084_3_2,
	enTPS7B7701_1,
	enTPS7B7702_1_1,
	enTPS7B7702_1_2
};  

enum
{
  TUN_KDS_INVALID_PARAMETER_         = 255
 ,TUN_KDS_FM_AM_Tuner_Parameter_Set = 1
 ,TUN_KDS_GENERIC_Tuner_Parameter_Set = 2
 ,TUN_KDS_HD_RADIO_PARAM_SET = 3
 ,TUN_KDS_DRM_TUNER_PARAM_SET = 4
 ,TUN_KDS_VARIANT_CODING = 5

};


enum tenAntennaParameter
{
	enAntennaParameter_idx_MajorIndex=				8,
	enAntennaParameter_idx_FM1AntennaType=			11,
	enAntennaParameter_idx_FM1OpenCur=				12,
	enAntennaParameter_idx_FM1OpenClearCur=			13,
	enAntennaParameter_idx_FM1ConsiderVg_Open=		14,
	enAntennaParameter_idx_FM1ConsiderIgn_Open=		15,
	enAntennaParameter_idx_FM1Open2Amp=				16,
	enAntennaParameter_idx_FM1Open2AmpClearCur_Lw=  17,
	enAntennaParameter_idx_FM1Open2AmpClearCur_Hg=	18,
	enAntennaParameter_idx_FM1ConsiderVg_Open2Amp=	19,
	enAntennaParameter_idx_FM1ConsiderIgn_Open2Amp=	20,
	enAntennaParameter_idx_FM1ShortCur=				21,
	enAntennaParameter_idx_FM1ShortClearCur=		22,
	enAntennaParameter_idx_FM1ConsiderVg_Short=		23,
	enAntennaParameter_idx_FM1ConsiderIgn_Short=	24,
	enAntennaParameter_idx_FM1MonitorCycle=			25,
	enAntennaParameter_idx_FM1NoOfMonitorCycle=		26,
	enAntennaParameter_idx_FM1ShortCircuitWait=		27,
	enAntennaParameter_idx_FM1ConsiderCriticalHg_Vg=28,
	enAntennaParameter_idx_FM2AntennaType=			31,
	enAntennaParameter_idx_FM2OpenCur=				32,
	enAntennaParameter_idx_FM2OpenClearCur=			33,
	enAntennaParameter_idx_FM2ConsiderVg_Open=		34,
	enAntennaParameter_idx_FM2ConsiderIgn_Open=		35,
	enAntennaParameter_idx_FM2Open2Amp=				36,
	enAntennaParameter_idx_FM2Open2AmpClearCur_Lw=	37,
	enAntennaParameter_idx_FM2Open2AmpClearCur_Hg=	38,
	enAntennaParameter_idx_FM2ConsiderVg_Open2Amp=	39,
	enAntennaParameter_idx_FM2ConsiderIgn_Open2Amp=	40,
	enAntennaParameter_idx_FM2ShortCur=				41,
	enAntennaParameter_idx_FM2ShortClearCur=		42,
	enAntennaParameter_idx_FM2ConsiderVg_Short=		43,
	enAntennaParameter_idx_FM2ConsiderIgn_Short=	44,
	enAntennaParameter_idx_FM2MonitorCycle=			45,
	enAntennaParameter_idx_FM2NoOfMonitorCycle=		46,
	enAntennaParameter_idx_FM2ShortCircuitWait=		47,
	enAntennaParameter_idx_FM2ConsiderCriticalHg_Vg=48,
	enAntennaParameter_idx_DAB1AntennaType=			51,
	enAntennaParameter_idx_DAB1OpenCur=				52,
	enAntennaParameter_idx_DAB1OpenClearCur=		53,
	enAntennaParameter_idx_DAB1ConsiderVg_Open=		54,
	enAntennaParameter_idx_DAB1ConsiderIgn_Open=	55,
	enAntennaParameter_idx_DAB1Open2Amp=			56,
	enAntennaParameter_idx_DAB1Open2AmpClearCur_Lw=	57,
	enAntennaParameter_idx_DAB1Open2AmpClearCur_Hg=	58,
	enAntennaParameter_idx_DAB1ConsiderVg_Open2Amp=	59,
	enAntennaParameter_idx_DAB1ConsiderIgn_Open2Amp=60,
	enAntennaParameter_idx_DAB1ShortCur=			61,
	enAntennaParameter_idx_DAB1ShortClearCur=		62,
	enAntennaParameter_idx_DAB1ConsiderVg_Short=	63,
	enAntennaParameter_idx_DAB1ConsiderIgn_Short=	64,
	enAntennaParameter_idx_DAB1MonitorCycle=		65,
	enAntennaParameter_idx_DAB1NoOfMonitorCycle=	66,
	enAntennaParameter_idx_DAB1ShortCircuitWait=	67,
	enAntennaParameter_idx_DAB1ConsiderCriticalHg_Vg=68,
	enAntennaParameter_idx_DAB1ParEnd				=70,
	enAntennaParameter_idx_GPSAntennaType=			 71,
	enAntennaParameter_idx_GPSOpenCur=				 72,
	enAntennaParameter_idx_GPSOpenClearCur=			 73,
	enAntennaParameter_idx_GPSConsiderVg_Open=       74,
	enAntennaParameter_idx_GPSConsiderIgn_Open=	     75,
	enAntennaParameter_idx_GPSOpen2Amp=				 76,
	enAntennaParameter_idx_GPSOpen2AmpClearCur_Lw=	 77,
	enAntennaParameter_idx_GPSOpen2AmpClearCur_Hg=	 78,
	enAntennaParameter_idx_GPSConsiderVg_Open2Amp=	 79,
	enAntennaParameter_idx_GPSConsiderIgn_Open2Amp=  80,
	enAntennaParameter_idx_GPSShortCur=				 81,
	enAntennaParameter_idx_GPSShortClearCur=		 82,
	enAntennaParameter_idx_GPSConsiderVg_Short=		 83,
	enAntennaParameter_idx_GPSConsiderIgn_Short=     84,
	enAntennaParameter_idx_GPSMonitorCycle=			 85,
	enAntennaParameter_idx_GPSNoOfMonitorCycle=      86,
	enAntennaParameter_idx_GPSShortCircuitWait=      87,
	enAntennaParameter_idx_GPSConsiderCriticalHg_Vg= 88,
	enAntennaParameter_idx_DTV1AntennaType=			91,
	enAntennaParameter_idx_DTV1OpenCur=				92,
	enAntennaParameter_idx_DTV1OpenClearCur=		93,
	enAntennaParameter_idx_DTV1ConsiderVg_Open=		94,
	enAntennaParameter_idx_DTV1ConsiderIgn_Open=	95,
	enAntennaParameter_idx_DTV1Open2Amp=			96,
	enAntennaParameter_idx_DTV1Open2AmpClearCur_Lw=	97,
	enAntennaParameter_idx_DTV1Open2AmpClearCur_Hg=	98,
	enAntennaParameter_idx_DTV1ConsiderVg_Open2Amp=	99,
	enAntennaParameter_idx_DTV1ConsiderIgn_Open2Amp=100,
	enAntennaParameter_idx_DTV1ShortCur=			101,
	enAntennaParameter_idx_DTV1ShortClearCur=		102,
	enAntennaParameter_idx_DTV1ConsiderVg_Short=	103,
	enAntennaParameter_idx_DTV1ConsiderIgn_Short=	104,
	enAntennaParameter_idx_DTV1MonitorCycle=		105,
	enAntennaParameter_idx_DTV1NoOfMonitorCycle=	106,
	enAntennaParameter_idx_DTV1ShortCircuitWait=	107,
	enAntennaParameter_idx_DTV1ConsiderCriticalHg_Vg=108,
	enAntennaParameter_idx_DTV1ParEnd				=110,
	enAntennaParameter_idx_DTV2AntennaType=			111,
	enAntennaParameter_idx_DTV2OpenCur=				112,
	enAntennaParameter_idx_DTV2OpenClearCur=		113,
	enAntennaParameter_idx_DTV2ConsiderVg_Open=		114,
	enAntennaParameter_idx_DTV2ConsiderIgn_Open=	115,
	enAntennaParameter_idx_DTV2Open2Amp=			116,
	enAntennaParameter_idx_DTV2Open2AmpClearCur_Lw=	117,
	enAntennaParameter_idx_DTV2Open2AmpClearCur_Hg=	118,
	enAntennaParameter_idx_DTV2ConsiderVg_Open2Amp=	119,
	enAntennaParameter_idx_DTV2ConsiderIgn_Open2Amp=120,
	enAntennaParameter_idx_DTV2ShortCur=			121,
	enAntennaParameter_idx_DTV2ShortClearCur=		122,
	enAntennaParameter_idx_DTV2ConsiderVg_Short=	123,
	enAntennaParameter_idx_DTV2ConsiderIgn_Short=	124,
	enAntennaParameter_idx_DTV2MonitorCycle=		125,
	enAntennaParameter_idx_DTV2NoOfMonitorCycle=	126,
	enAntennaParameter_idx_DTV2ShortCircuitWait=	127,
	enAntennaParameter_idx_DTV2ConsiderCriticalHg_Vg=128,
	enAntennaParameter_idx_DTV2ParEnd				=130,
	enAntennaParameter_idx_DTV3AntennaType=			131,
	enAntennaParameter_idx_DTV3OpenCur=				132,
	enAntennaParameter_idx_DTV3OpenClearCur=		133,
	enAntennaParameter_idx_DTV3ConsiderVg_Open=		134,
	enAntennaParameter_idx_DTV3ConsiderIgn_Open=	135,
	enAntennaParameter_idx_DTV3Open2Amp=			136,
	enAntennaParameter_idx_DTV3Open2AmpClearCur_Lw=	137,
	enAntennaParameter_idx_DTV3Open2AmpClearCur_Hg=	138,
	enAntennaParameter_idx_DTV3ConsiderVg_Open2Amp=	139,
	enAntennaParameter_idx_DTV3ConsiderIgn_Open2Amp=140,
	enAntennaParameter_idx_DTV3ShortCur=			141,
	enAntennaParameter_idx_DTV3ShortClearCur=		142,
	enAntennaParameter_idx_DTV3ConsiderVg_Short=	143,
	enAntennaParameter_idx_DTV3ConsiderIgn_Short=	144,
	enAntennaParameter_idx_DTV3MonitorCycle=		145,
	enAntennaParameter_idx_DTV3NoOfMonitorCycle=	146,
	enAntennaParameter_idx_DTV3ShortCircuitWait=	147,
	enAntennaParameter_idx_DTV3ConsiderCriticalHg_Vg=148,
	enAntennaParameter_idx_DTV4AntennaType=			151,
	enAntennaParameter_idx_DTV4OpenCur=				152,
	enAntennaParameter_idx_DTV4OpenClearCur=		153,
	enAntennaParameter_idx_DTV4ConsiderVg_Open=		154,
	enAntennaParameter_idx_DTV4ConsiderIgn_Open=	155,
	enAntennaParameter_idx_DTV4Open2Amp=			156,
	enAntennaParameter_idx_DTV4Open2AmpClearCur_Lw=	157,
	enAntennaParameter_idx_DTV4Open2AmpClearCur_Hg=	158,
	enAntennaParameter_idx_DTV4ConsiderVg_Open2Amp=	159,
	enAntennaParameter_idx_DTV4ConsiderIgn_Open2Amp=160,
	enAntennaParameter_idx_DTV4ShortCur=			161,
	enAntennaParameter_idx_DTV4ShortClearCur=		162,
	enAntennaParameter_idx_DTV4ConsiderVg_Short=	163,
	enAntennaParameter_idx_DTV4ConsiderIgn_Short=	164,
	enAntennaParameter_idx_DTV4MonitorCycle=		165,
	enAntennaParameter_idx_DTV4NoOfMonitorCycle=	166,
	enAntennaParameter_idx_DTV4ShortCircuitWait=	167,
	enAntennaParameter_idx_DTV4ConsiderCriticalHg_Vg=168,
};

enum tenAntennaType
{
   enNone,
   enPassive,
   enActive,
   enPhantom
};   //AntennaType defined in DiagnosticServices.pdf

#define TUN_CONFIG_AM_AVAIL_EU						  6
#define TUN_CONFIG_AM_AVAIL_RESTAREA				  4
#define TUN_CONFIG_LW_NOTAVAIL						  0xFFFFFFFD
#define TUN_CONFIG_AM_NOTAVAIL                        0xFFFFFFF9
#define TUN_TRACE_CONFIG_PRINT             	0x01
#define TUN_TRACE_CONFIG_SET_TO_DEFAULT    	0x02
#define TUN_TRACE_CONFIG_READ_KDS          	0x03



#endif /* CLCONFIGDEFINES_H_ */
