/*
 * drmPlayerUtility.cpp
 *
 *  Created on: Dec 3, 2015
 *      Author: pmn3kor
 */

#include <pthread.h>
#include <semaphore.h>
#include <stdio.h>
#include <sys/time.h>

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <assert.h>

#include "drmPlayer/drmPlayerUtility.h"

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_DRMPLAYER
#include "trcGenProj/Header/drmPlayerUtility.cpp.trc.h"
#endif

using namespace tuner::drm;

unsigned int drmPlayerUtility::m_u32SuperFrameCrcFailCount = 0;
unsigned int drmPlayerUtility::m_u32AudioFrameCrcFailCount = 0;
unsigned int drmPlayerUtility::m_u32TotalFrameCount = 0;
bool drmPlayerUtility::bLastFrameStatus = false;
bool drmPlayerUtility::bNonReliabilityIndictaion = false;
#include "DRMTrace.h"

drmPlayerUtility::drmPlayerUtility()
 {

}

drmPlayerUtility::~drmPlayerUtility()
{

}

unsigned int drmPlayerUtility::u32ConvertSampleRateForAAC(unsigned char ThreeBitAudioSamplingRate)
{
   unsigned int u32tempSampleRate = 0;
   switch(ThreeBitAudioSamplingRate)
   {
   case 1: //001: 12 kHz
   {
      u32tempSampleRate = 12000;
      break;
   }
   case 3: //011: 24 kHz
   {
      u32tempSampleRate = 24000;
      break;
   }
   case 5: //101: 48 kHz
   {
      u32tempSampleRate = 48000;
      break;
   }
   default : //000: reserved, 010: reserved, 100: reserved, 110: reserved, 111: reserved.
   {
      ETG_TRACE_USR4(("Invalid sampling rate ThreeBitAudioSamplingRate=%d", ThreeBitAudioSamplingRate));
      break;
   }
   }
   return u32tempSampleRate;
}

bool drmPlayerUtility::bIsSBRStream(unsigned char OneBitSBRFlag)
{
   if(OneBitSBRFlag == 1)
      return true;
   else
      return false;
}

bool drmPlayerUtility::bIsDoubleValueCondition(unsigned int SampleRate)
{
   if((SampleRate == 24000) || (SampleRate == 12000))
      return true;
   else
      return false;
}

unsigned int drmPlayerUtility::u32GetSampleRateForAAC(unsigned char ThreeBitAudioSamplingRate, unsigned char OneBitSBRFlag)
{
   unsigned int tempSampleRate = u32ConvertSampleRateForAAC(ThreeBitAudioSamplingRate);
   if((bIsSBRStream(OneBitSBRFlag)) && bIsDoubleValueCondition(tempSampleRate))
   {
      tempSampleRate=2*tempSampleRate;
   }
   return tempSampleRate;
}

unsigned int drmPlayerUtility::u32GetSampleRateForxHEAAC(unsigned char ThreeBitAudioSamplingRate)
{
   unsigned int u32tempSampleRate = 0;
   switch(ThreeBitAudioSamplingRate)
   {
   case 0: //000: 9,6 kHz
   {
      u32tempSampleRate = 9600;
      break;
   }
   case 1: //001: 12 kHz
   {
      u32tempSampleRate = 12000;
      break;
   }
   case 2: //010: 16 kHz
   {
      u32tempSampleRate = 16000;
      break;
   }
   case 3: //011: 19,2 kHz
   {
      u32tempSampleRate = 19200;
      break;
   }
   case 4: //100: 24 kHz
   {
      u32tempSampleRate = 24000;
      break;
   }
   case 5: //101: 32 kHz.
   {
      u32tempSampleRate = 32000;
      break;
   }
   case 6: //110: 38,4 kHz
   {
      u32tempSampleRate = 38400;
      break;
   }
   case 7: //111: 48 kHz.
   {
      u32tempSampleRate = 48000;
      break;
   }
   default :
   {
      ETG_TRACE_USR4(("Invalid sampling rate ThreeBitAudioSamplingRate=%d", ThreeBitAudioSamplingRate));
      break;
   }
   }
   return u32tempSampleRate;
}

bool drmPlayerUtility::bIsAACStream(unsigned char TwoBitAudioCoding)
{
   if(TwoBitAudioCoding == 0)
      return true;
   else
      return false;
}

bool drmPlayerUtility::bIsxHEAACStream(unsigned char TwoBitAudioCoding)
{
   if(TwoBitAudioCoding == 3)
     return true;
  else
     return false;
}

unsigned int drmPlayerUtility::vGetSampleRate(
      unsigned char TwoBitAudioCoding , unsigned char ThreeBitAudioSamplingRate, unsigned char OneBitSBRFlag)
{
   unsigned int tempSampleRate=0;
   if(bIsAACStream(TwoBitAudioCoding))
   {
      tempSampleRate = u32GetSampleRateForAAC(ThreeBitAudioSamplingRate, OneBitSBRFlag);
   }
   else if(bIsxHEAACStream(TwoBitAudioCoding))
   {
      tempSampleRate = u32GetSampleRateForxHEAAC(ThreeBitAudioSamplingRate);
   }
   else
   {
      ETG_TRACE_USR4(("Invalid audio coding TwoBitAudioCoding=%d", TwoBitAudioCoding));
   }
   return tempSampleRate;
}


unsigned char  drmPlayerUtility::getBitFromByte(unsigned char Value, unsigned char whichBit)
{
    if (whichBit > 0 && whichBit <= 8)
        return (Value & (1<<(whichBit-1)));
    else
        return 0;
}

unsigned int drmPlayerUtility::u32GetAudioFrameCorruptCount()
{
   return  m_u32AudioFrameCrcFailCount ;
}

unsigned int drmPlayerUtility::u32GetSuperFrameCorruptCount()
{
   return m_u32SuperFrameCrcFailCount;
}

unsigned int drmPlayerUtility::u32GetTotalFrames()
{
   return m_u32TotalFrameCount;
}

bool drmPlayerUtility::bGetLastFrameStatus()
{
   return bLastFrameStatus;
}

bool drmPlayerUtility::bGetNonReliabilityStatus()
{
   return bNonReliabilityIndictaion;
}
