///////////////////////////////////////////////////////////
//  drmPlayerInterface.h
//  Implementation of the Class drmPlayerInterface
//  Created on:      27-Oct-2014 11:43:05
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_358161B9_B363_40ae_8133_6886EFC7E50C__INCLUDED_)
#define EA_358161B9_B363_40ae_8133_6886EFC7E50C__INCLUDED_


#include "datatypes/tCommon.h"
#include "datatypes/tString.h"
#include "datatypes/tVector.h"
#include "../common/ADRMsg/ADRMsg_if.h"


/**
 * This file is automatically generated from EA.
 * Do not manually change. Please synchronize with EA.
 */


namespace tuner
{
namespace drm
{
class drmPlayer;
class drmPlayerInterface
{

public:
	/**
	 * static class pointer to call other functions from static call backs.
	 */
	static drmPlayerInterface * m_Proxy;

	/**
	 * Destructor
	 */
	~drmPlayerInterface();
	/**
	 * Starts playback of data on the gstreamer pipeline.
	 * returns FALSE if playback fails.
	 */
	bool bPlay();
	/**
	 * Provides the instance of the drmPlayer created.
	 */
	static drmPlayerInterface* getInstance();
	/**
	 * This function is called to provide new data to the gstreamer pipeline
	 */
	void vOnNewData(clCMDRMAudioLogicalFrameStatus* inputStream);
	void vOnNewData(tunerVector<unsigned char>, bool){}
	/**
	 * Stops play back of the DRM data. Deletes the pipeline created.
	 */
	void vPause();
	/**
	 * This function is used to initialize the sink name required for the gstreamer
	 * pipeline
	 */
	void vSetSink(const tunerString alsaSink,unsigned int b8ElementConfig=1);
	/**
	 * stops play back of the DRM data
	 */
	void vStop();
	/**
	 * Deletes the current player instance.
	 */
	void vDeletePlayer();

	void vSetPlayerState(bool bNewValue);

	int getFrameCount();
    bool bGetNonReliabilityStatus();

	unsigned int u32GetSuperFrameCorruptCount();

	unsigned int u32GetAudioFrameCorruptCount();

	bool bGetLastFrameStatus();

	unsigned int u32GetTotalFrames();
protected:
	/**
	 * drmPlayer would act like a singleton, however constructor is left protected to
	 * allow overriding from utest class
	 */
	drmPlayerInterface();
	/**
	 * drmPlayer would act like a singleton, copy constructor is protected
	 */
	drmPlayerInterface(const drmPlayerInterface&);
	/**
	 * drmPlayer would act like a singleton, copy constructor is protected
	 */
	drmPlayerInterface& operator =(const drmPlayerInterface&);

private:
	/**
	 * The handle to the DRM player class.
	 */
	tuner::drm::drmPlayer* player;
	/**
	 * Checks if player is available. Returns True if player is found, else false.
	 */
	bool bIsPlayerAvailable();
	/**
	 * Creates a new instance of gstreamer player
	 */
	void vCreatePlayer(const tunerString alsaSink,unsigned int b8ElementConfig);

};
}

}
#endif // !defined(EA_358161B9_B363_40ae_8133_6886EFC7E50C__INCLUDED_)
