///////////////////////////////////////////////////////////
//  drmPlayerInterface.cpp
//  Implementation of the Class drmPlayerInterface
//  Created on:      27-Oct-2014 11:43:05
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "drmPlayer/drmPlayerInterface.h"
#include "drmPlayer/drmPlayer.h"
#include "datatypes/tCommon.h"

#include "DRMTrace.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_DRMPLAYER
#include "trcGenProj/Header/drmPlayerInterface.cpp.trc.h"
#endif

using namespace tuner::drm;

drmPlayerInterface* drmPlayerInterface::m_Proxy = NULL;


drmPlayerInterface::drmPlayerInterface()
: player(0)
{

}


drmPlayerInterface::~drmPlayerInterface(){
	player=NULL;
}


bool drmPlayerInterface::bPlay(){
	if (NULL != player)
	{
		return player->bPlay();
	}
	return false;
}

void drmPlayerInterface::vSetPlayerState(bool bNewValue)
{
   if (NULL != player)
   {
      player->vSetPlayerState(bNewValue);
   }
}

drmPlayerInterface* drmPlayerInterface::getInstance(){
	if (NULL == m_Proxy)
	{
		m_Proxy = tunerNew drmPlayerInterface();
	}
	return m_Proxy;
}


void drmPlayerInterface::vOnNewData(clCMDRMAudioLogicalFrameStatus* inputStream){
	if (NULL != player)
	{
		player->vOnNewData(inputStream);
	}
}

void drmPlayerInterface::vPause(){
	if (NULL != player)
	{
		player->vPause();
	}
}


void drmPlayerInterface::vSetSink(const tunerString alsaSink, unsigned int b8ElementConfig){
	if (bIsPlayerAvailable())
	{
		vDeletePlayer();
	}
	vCreatePlayer(alsaSink, b8ElementConfig);
}


void drmPlayerInterface::vStop(){
	if (NULL != player)
	{
		player->vStop();
	}
}


bool drmPlayerInterface::bIsPlayerAvailable(){
	if (NULL != player)
	{
		return true;
	}
	return false;
}


void drmPlayerInterface::vDeletePlayer(){
	if (NULL != player)
	{
		tunerDelete player;
	}
	player = NULL;
}


int drmPlayerInterface::getFrameCount(){
	if (NULL != player)
	{
		return player->getFrameCount();
	}
	return 0;
}

bool drmPlayerInterface::bGetNonReliabilityStatus(){
   if (NULL != player)
   {
      return player->bGetNonReliabilityStatus();
   }
   return 0;
}

unsigned int drmPlayerInterface::u32GetSuperFrameCorruptCount(){
   if (NULL != player)
   {
      return player->u32GetSuperFrameCorruptCount();
   }
   return 0;
}

unsigned int drmPlayerInterface::u32GetAudioFrameCorruptCount(){
   if (NULL != player)
   {
      return player->u32GetAudioFrameCorruptCount();
   }
   return 0;
}

unsigned int drmPlayerInterface::u32GetTotalFrames(){
   if (NULL != player)
   {
      return player->u32GetTotalFrames();
   }
   return 0;
}

bool drmPlayerInterface::bGetLastFrameStatus(){
   if (NULL != player)
   {
      return player->bGetLastFrameStatus();
   }
   ETG_TRACE_USR4(("bGetLastFrameStatus() player"));
   return 0;
}
void drmPlayerInterface::vCreatePlayer(const tunerString alsaSink, unsigned int b8ElementConfig){
	player = tunerNew drmPlayer(alsaSink, b8ElementConfig);
}
