/**************************************************************************//**
 * \file     clDRMInput.h
 *
 *
 * \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
 ******************************************************************************/
#ifndef clDRMInput_h
#define clDRMInput_h


#include "datatypes/tVector.h"
#include "datatypes/tString.h"
#include "datatypes/tCommon.h"

#include <glib.h>
#include <semaphore.h>
#include <stdio.h>
#include <sys/time.h>

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <assert.h>
#include <pthread.h>
#include "glib.h"
#include "gst/gst.h"
#include "gst/app/gstappsrc.h"
#include "ADRMsg/ADRMsg_if.h"


#define INTERFACE_HEADER_SIZE      44   /* size of the base interface header in bytes */


class clCMDRMAudioLogicalFrameStatus;


namespace tuner
{
namespace drm
{
class clDRMInput
{
public:
	clDRMInput();
	virtual ~clDRMInput();
	void vFeedData(tunerString oFileName);
	static void* vFileReaderThread(void *);

	static clDRMInput* m_poInput;
	//static clDRMInput* getInstance();
private:
	void vOnFileReaderThread();
	void vReadNextFrame();
	void vSetAsLastFrame();
	void vSendFrame();
	void vAddHeaderInformation();
	void vAddPayloadInformation();
	bool bIsLastFrame();

	int ntos(int value);

	FILE* fp;
	bool m_bIsEndofFile, m_bQuitThread;
	struct timeval referenceTime;
	tunerString m_oFileName;
	pthread_mutex_t mutex;
	sem_t semaphore;
	struct timeval drmFrameTime;
	gulong actInterfaceHeader[INTERFACE_HEADER_SIZE];
	clCMDRMAudioLogicalFrameStatus* m_poFrame;
	pthread_t thread;
};
}
}



#endif // clDRMInput_h
