///////////////////////////////////////////////////////////
//  appSourcePlayer.cpp
//  Implementation of the Class appSourcePlayer
//  Created on:      27-Oct-2014 11:43:10
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "drmPlayer/appSourcePlayer.h"
#include "DRMTrace.h"
#include <pthread.h>
#include <semaphore.h>
#include <stdio.h>
#include <sys/time.h>

#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <assert.h>

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_DRMPLAYER 
#include "trcGenProj/Header/appSourcePlayer.cpp.trc.h"
#endif
using namespace tuner::drm;


appSourcePlayer* appSourcePlayer::m_poAppSourcePlayer = NULL;
pthread_mutex_t appSourcePlayer::lock=PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t appSourcePlayer::playerlock=PTHREAD_MUTEX_INITIALIZER;
pthread_mutex_t appSourcePlayer::CleanPipelineLock=PTHREAD_MUTEX_INITIALIZER;

#define vTrace g_print
#define DRM_THREAD_PRIORITY 60


appSourcePlayer::appSourcePlayer()
:drmPlayerUtility()
, m_SinkName(""), bIsEndOfStream(false), m_Action(0)
, m_pipeline(0)
, m_player(0)
, m_sink(0)
, m_volume(0)
, m_sinkBin(0)
, m_capsfilter(0)
, m_queue2(0)
, m_bus(0)
, m_loop(0)
, bIsAppReady(false)
, m_AudioSamplingRate(0)
, m_AudioMode(0)
, m_bFirstFrame(true)
, m_SBRFlag(0)
, m_bSetPlayerState(false)
, m_pthreadcreate_returnvalue(255)
, m_bCleanPipelineInProgress(false)
{
   ETG_TRACE_USR4(("Constructor of appSourcePlayer called"));
	//setenv("GST_DEBUG", "*drm*:5", 1);
	m_poAppSourcePlayer = this;
	m_volume = NULL;
	bSendFrame=true;
	drmFrames.clear();
	sem_init(&semaphore, 0, 0);
    m_bIsPrioChanged = false;
    bNeedData = false;
    bApplyAudioRamp = false;
    blIsBufferOverFlow = false;
    m_source = NULL;

    thread=(pthread_t)NULL;
}


appSourcePlayer::~appSourcePlayer(){
	//pthread_mutex_unlock(&lock);
	vQuitPipeline();
}


void appSourcePlayer::SetMaxPriority()
{
    int policy;
    struct sched_param param;

    pthread_getschedparam(pthread_self(), &policy, &param);

    //param.sched_priority = sched_get_priority_max(SCHED_RR);
    param.sched_priority = DRM_THREAD_PRIORITY;
    policy = SCHED_RR;

    pthread_setschedparam(pthread_self(), policy, &param);

 
}




void appSourcePlayer::vInit() {
	pthread_attr_t attr;
	struct sched_param params;
	pthread_attr_init(&attr);
	pthread_attr_setschedpolicy(&attr, SCHED_RR);
	//params.sched_priority = sched_get_priority_max(SCHED_RR);
   params.sched_priority = DRM_THREAD_PRIORITY;
	pthread_attr_setschedparam(&attr, &params);
	pthread_attr_setinheritsched(&attr, PTHREAD_EXPLICIT_SCHED);

	if (bUsePlayBin())
	{
	   m_pthreadcreate_returnvalue = pthread_create(&thread, NULL, vCreatePlayBinPipeLine, NULL);
	}
	else
	{
	   m_pthreadcreate_returnvalue = pthread_create(&thread, &attr, vCreatePipeline, NULL);
	}

	ETG_TRACE_USR4(("m_pthreadcreate_returnvalue = %d", m_pthreadcreate_returnvalue));
	if (m_pthreadcreate_returnvalue)
	{
	   ETG_TRACE_USR4(("thread creation failed"));
	   NORMAL_M_ASSERT( m_pthreadcreate_returnvalue == 0 );
	   return;
	}
	else
	{
		pthread_setname_np(thread, "DRM_RU");
	}
	sem_wait(&semaphore);
}


bool appSourcePlayer::bUsePlayBin() {
	for (unsigned int u32Index = 0; u32Index < m_gstElements.size(); u32Index++)
	{
		if (m_gstElements[u32Index] == "playbin2")
		{
			return true;
		}
	}
	return false;
}


void appSourcePlayer::vPause(){
	ETG_TRACE_USR4(("ENTRY_THREAD: vPause()"));
	gst_element_set_state(m_pipeline, GST_STATE_PAUSED);
}

bool appSourcePlayer::bPlay(){
	ETG_TRACE_USR4(("ENTRY_THREAD: bPlay()"));
	gst_element_set_state(m_pipeline, GST_STATE_PLAYING);
	return true;
}


// thread is locked when we try to set player state coz..
//eg : logical frame is received from ADR at vOnNewData and is getting processed and at the same time we get SRC OFF
//player is deleted but data already present inside is not handled properly. So lock the thread till it is processed.
void appSourcePlayer::vSetPlayerState(bool bNewValue)
{
   pthread_mutex_lock(&playerlock);
   m_bSetPlayerState = bNewValue;
   pthread_mutex_unlock(&playerlock);
}

bool appSourcePlayer::vGetPlayerState()
{
   return m_bSetPlayerState;
}


void appSourcePlayer::vStop(){
	ETG_TRACE_USR4(("ENTRY_THREAD: vStop()"));
	vSendEOSEvent();
	vChangeStateToNull();
}


void appSourcePlayer::vSendEOSEvent(){
	GstEvent *l_pEvent;
	l_pEvent = gst_event_new_eos();
	gst_element_send_event(m_pipeline, l_pEvent);
}


void appSourcePlayer::vChangeStateToNull(){
	GstStateChangeReturn l_gstStateChange = GST_STATE_CHANGE_SUCCESS;
	GstState l_gstState, l_gstPendingState;
	l_gstStateChange = gst_element_set_state(m_pipeline, GST_STATE_NULL);
	if (l_gstStateChange == GST_STATE_CHANGE_FAILURE)
	{
		ETG_TRACE_ERR(("ENTRY_THREAD: vChangeStateToNull: [ERROR] Setting Pipeline to NULL state Failed"));
	}
	else if (l_gstStateChange == GST_STATE_CHANGE_ASYNC)
	{
		ETG_TRACE_USR4(("ENTRY_THREAD: vChangeStateToNull: Pipeline changing state asynchronously"));
		do
		{
			guint32 l_iMilliSecond = 1000;
			GstClockTime l_gstTimeOut = (GstClockTime)(5) * l_iMilliSecond * l_iMilliSecond * l_iMilliSecond;
			l_gstStateChange = gst_element_get_state(m_pipeline,
					&l_gstState,
					&l_gstPendingState,
					l_gstTimeOut);
		} while (l_gstState != GST_STATE_NULL);
	}
	else
	{
		ETG_TRACE_USR4(("ENTRY_THREAD: vChangeStateToNull: Setting Pipeline to NULL state succeeded"));
	}
}


void appSourcePlayer::vOnNewData(clCMDRMAudioLogicalFrameStatus* frameData){

   pthread_mutex_lock(&playerlock);
   if(vGetPlayerState())
   {
      pthread_mutex_unlock(&playerlock);
      vReadAudioInfoEntity(frameData);
      pthread_mutex_lock(&CleanPipelineLock);
      if(m_pipeline == NULL && m_bFirstFrame && (!bGetCleanPipeLineState()))
      {
        ETG_TRACE_USR4(("READ_THREAD: should be called only when first frame of audio file is received"));
        appSourcePlayer::vInit();
        bPlay();
        m_bFirstFrame = false;
      }
      pthread_mutex_unlock(&CleanPipelineLock);
      pthread_mutex_lock(&lock);

      try{
    	  drmFrames.push_back(frameData);
      }
      catch(...){
		ETG_TRACE_USR4(("vOnNewData Push back  "));
      }
      ETG_TRACE_USR4(("READ_THREAD: frameCount = %d", drmFrames.size()));
      pthread_mutex_unlock(&lock);
   }
   else
   {
      pthread_mutex_unlock(&playerlock);
   }

}



void appSourcePlayer::vSetNewConfiguration(unsigned char TwoBitAudioMode , unsigned int u32tempSampleRate, unsigned char OneBitSBRFlag)
{
   if(m_pipeline != NULL)
   {
      m_poAppSourcePlayer->vQuitPipeline();
      ETG_TRACE_USR4(("clear pipeline to reconfigure"));
   }
   if(m_pipeline == NULL)
   {
      m_AudioMode = TwoBitAudioMode;
      m_AudioSamplingRate = u32tempSampleRate;
      m_SBRFlag = OneBitSBRFlag;
      m_bFirstFrame = true;
      bSendFrame = true;
      ETG_TRACE_USR4(("vSetNewConfiguration values are : m_AudioMode=%d m_AudioSamplingRate=%d m_SBRFlag=%d",
            m_AudioMode,  m_AudioSamplingRate, m_SBRFlag ));
   }
}

void appSourcePlayer::vReadAudioInfoEntity(clCMDRMAudioLogicalFrameStatus* frameData)
{
   tunerVector<unsigned char> lAudioInfoEntity = frameData->AudioInfoEntity;
   unsigned char TwoBitAudioCoding = ((getBitFromByte(lAudioInfoEntity[0], 4) >> 2) | (getBitFromByte(lAudioInfoEntity[0], 3) >> 2));
   unsigned char OneBitSBRFlag  =  (getBitFromByte(lAudioInfoEntity[0], 2) >> 1) ;
   unsigned char TwoBitAudioMode =  ((getBitFromByte(lAudioInfoEntity[0], 1) << 1) | (getBitFromByte(lAudioInfoEntity[1], 8) >> 7));
   unsigned char ThreeBitAudioSamplingRate = ((getBitFromByte(lAudioInfoEntity[1], 7) >> 4 )
   		   	   	   	   	   	   	   	   	   	   | (getBitFromByte(lAudioInfoEntity[1], 6) >> 4)
   		   	   	   	   	   	   	   	   	   	   | (getBitFromByte(lAudioInfoEntity[1], 5) >> 4));

   unsigned int u32tempSampleRate = vGetSampleRate(TwoBitAudioCoding, ThreeBitAudioSamplingRate, OneBitSBRFlag);

   if((TwoBitAudioMode != m_AudioMode) || (u32tempSampleRate != m_AudioSamplingRate) || (OneBitSBRFlag != m_SBRFlag))
   {
      ETG_TRACE_USR4(("appSourcePlayer::vReadAudioInfoEntity configuration changed "));
      ETG_TRACE_USR4(("vReadAudioInfoEntity values are : TwoBitAudioMode=%d ThreeBitAudioSamplingRate=%d TwoBitAudioCoding=%d OneBitSBRFlag=%d",
                     TwoBitAudioMode, ThreeBitAudioSamplingRate, TwoBitAudioCoding, OneBitSBRFlag ));
      vSetNewConfiguration(TwoBitAudioMode, u32tempSampleRate, OneBitSBRFlag);
   }

}


gboolean appSourcePlayer::bSendNextFrame() {

   if(false == m_bIsPrioChanged)
   {
      m_bIsPrioChanged = true;
      SetMaxPriority();
   }

	clCMDRMAudioLogicalFrameStatus* poNextFrame = 0;
	bool bFrameReadCompleted = false;
	while( (bFrameReadCompleted == false) && (bSendFrame==true))
	{
		pthread_mutex_lock(&lock);
		if (!drmFrames.empty())
		{
			poNextFrame = drmFrames.front();
			drmFrames.erase(drmFrames.begin());
		}
		pthread_mutex_unlock(&lock);
		if (poNextFrame != 0)
		{
              
			GstBuffer *buffer = gst_buffer_new_and_alloc(poNextFrame->LenFrameData);
         guint8 *rawPointer = (guint8 *)GST_BUFFER_DATA(buffer);
         tunerCopy(poNextFrame->FrameData.begin(), poNextFrame->FrameData.end(), rawPointer);
		 if(poNextFrame->NonReliabilityIndication.enType == 0)
		 {
		    audioInfoEntity = poNextFrame->AudioInfoEntity;

		 }
		 GstBuffer *AudioBuffer = gst_buffer_new_and_alloc (audioInfoEntity.size());
		 tunerCopy(audioInfoEntity.begin(), audioInfoEntity.end(),GST_BUFFER_DATA(AudioBuffer));
         GstCaps *caps = gst_caps_new_simple ("audio/x-drm",
               "codec_data", GST_TYPE_BUFFER, AudioBuffer,
               "drmplus", G_TYPE_BOOLEAN, FALSE,
               "higher-protected", G_TYPE_UINT, poNextFrame->LenHigherProtFrameData,
               "frame-corrupt", G_TYPE_BOOLEAN, poNextFrame->NonReliabilityIndication.enType,
               "ext-frame-count", G_TYPE_UINT, poNextFrame->FrameCntr,
               NULL);
         gst_buffer_unref (AudioBuffer);
         gst_buffer_set_caps (buffer, caps);
         gst_caps_unref (caps);
         GstFlowReturn ret;
         g_signal_emit_by_name (m_source, "push-buffer", buffer, &ret);
         gst_buffer_unref (buffer);
         ETG_TRACE_USR4(("GSTREAMER_THREAD: bSendNextFrame()%s", ret == 0 ? "Data pushed successfully" : "Error in pushing the data"));
         
         		

         m_Action = static_cast<unsigned char>(poNextFrame->Action.enType);
         if (poNextFrame->Action.enType == clCMEnum_Action::END_OF_STREAM)
			{
				gst_app_src_end_of_stream((GstAppSrc*)(m_source));
				ETG_TRACE_USR4(("GSTREAMER_THREAD: bSendNextFrame sending EOS..."));
			}
			bFrameReadCompleted = true;
		}
		else
		{
         if (m_Action == clCMEnum_Action::END_OF_STREAM)
			{
				ETG_TRACE_USR4(("GSTREAMER_THREAD: bSendNextFrame called on EOS..."));
				gst_app_src_end_of_stream((GstAppSrc*)(m_source));
				bFrameReadCompleted = true;
			}
			else
			{
				//ETG_TRACE_USR4(("GSTREAMER_THREAD: bSendNextFrame called and no data frame present..."));
				usleep(10000);
			}
		}
	}
	delete poNextFrame;
	return TRUE;
}


void* appSourcePlayer::vCreatePipeline(void *)
{
	ETG_TRACE_USR4(("ENTRY_THREAD: vCreatePipeline()"));
	gst_init(NULL, NULL);
	m_poAppSourcePlayer->vCreateElements();
	m_poAppSourcePlayer->vCreateDecoderElements();
	m_poAppSourcePlayer->vStorePlayerElement();
	m_poAppSourcePlayer->vStoreQueueElement();
	m_poAppSourcePlayer->vStoreCapsFilter();
   m_poAppSourcePlayer->vSetCaps();
	m_poAppSourcePlayer->vSetupSink();
	m_poAppSourcePlayer->vSetCallBacks();
	m_poAppSourcePlayer->bLinkElements();
	m_poAppSourcePlayer->vSetupLoop();
	m_poAppSourcePlayer->vStartLoop();
	m_poAppSourcePlayer->vCleanPipeLine();
	return NULL;
}

void* appSourcePlayer::vCreatePlayBinPipeLine(void *)
{
	gst_init(NULL, NULL);
	m_poAppSourcePlayer->vCreatePlayBinElements();
	m_poAppSourcePlayer->vSetupSink();
	m_poAppSourcePlayer->vLinkSink();
	m_poAppSourcePlayer->vSetupLoop();
	m_poAppSourcePlayer->vStartLoop();
	m_poAppSourcePlayer->vCleanPipeLine();
	return NULL;
}


void appSourcePlayer::vOnSourceInformation(GstElement *pipeline, GstAppSrc *source) {
	ETG_TRACE_USR4(("vOnSourceInformation()pipeline=%d", pipeline));
	m_poAppSourcePlayer->m_source = (GstAppSrc*)source;
	m_poAppSourcePlayer->vSetCallBacks();
}


void appSourcePlayer::vCreatePlayBinElements() {
	m_pipeline = gst_parse_launch("playbin2 uri=appsrc://", NULL);
	g_signal_connect(m_pipeline, "source-setup", G_CALLBACK(vOnSourceInformation), NULL);
	m_bus = gst_pipeline_get_bus(GST_PIPELINE_CAST((tVoid*)m_pipeline));
	gst_bus_add_watch((GstBus*)m_bus, (GstBusFunc)vOnNewStatus, NULL);
}


void appSourcePlayer::vCreateDecoderElements() {
   m_Elements.clear();
   for (unsigned int u32Index = 0; u32Index < m_gstElements.size(); u32Index++)
	{
		GstElement* element = gst_element_factory_make(m_gstElements[u32Index].c_str(), m_gstElements[u32Index].c_str());
		m_Elements.push_back(element);
	}
}

GstElement* appSourcePlayer::getVolumeElement()
{
	GstElement* volume = NULL;
	for (unsigned int u32Index = 0; u32Index < m_Elements.size(); u32Index++)
	{
		gchar* elementName = gst_element_get_name(m_Elements[u32Index]);
		if (g_strcmp0("volume", elementName) == 0)
		{
			volume = m_Elements[u32Index];
			m_poAppSourcePlayer->m_volume = volume;
		}
		g_free(elementName);
	}
	return volume;
}


void appSourcePlayer::vStorePlayerElement()
{
	for (unsigned int u32Index = 0; u32Index < m_Elements.size(); u32Index++)
	{
		gchar* elementName = gst_element_get_name(m_Elements[u32Index]);
		ETG_TRACE_USR4(("elementName = %s", elementName));
		if (g_strcmp0("drm-audio", elementName) == 0)
		{
			m_poAppSourcePlayer->m_player = m_Elements[u32Index];
		}
		g_free(elementName);
	}
	if (m_poAppSourcePlayer->m_player == 0)
   {
      NORMAL_M_ASSERT( m_poAppSourcePlayer->m_player != NULL );
      ETG_TRACE_USR4(("ENTRY_THREAD Unable to identify drm-audio"));
   }
}


void appSourcePlayer::vStoreCapsFilter()
{
	for (unsigned int u32Index = 0; u32Index < m_Elements.size(); u32Index++)
	{
		gchar* elementName = gst_element_get_name(m_Elements[u32Index]);
		if (g_strcmp0("capsfilter", elementName) == 0)
		{
			m_poAppSourcePlayer->m_capsfilter = m_Elements[u32Index];
		}
		g_free(elementName);
	}
	if (m_poAppSourcePlayer->m_capsfilter == 0)
   {
      NORMAL_M_ASSERT( m_poAppSourcePlayer->m_capsfilter != NULL );
      ETG_TRACE_USR4(("ENTRY_THREAD Unable to identify capsfilter"));
   }
}


void appSourcePlayer::vStoreQueueElement()
{
	for (unsigned int u32Index = 0; u32Index < m_Elements.size(); u32Index++)
	{
		gchar* elementName = gst_element_get_name(m_Elements[u32Index]);
		if (g_strcmp0("queue2", elementName) == 0)
		{
			m_poAppSourcePlayer->m_queue2 = m_Elements[u32Index];
		}
		g_free(elementName);
	}
	if (m_poAppSourcePlayer->m_queue2 == 0)
   {
      NORMAL_M_ASSERT( m_poAppSourcePlayer->m_queue2 != NULL );
      ETG_TRACE_USR4(("ENTRY_THREAD Unable to identify queue2"));
   }
}

void appSourcePlayer::vSetInitialVolumetoZero(){
	GstElement* volume = getVolumeElement();
	if (volume != NULL)
	{
		g_object_set(volume, "volume", 0.0, NULL);
	}
}


void appSourcePlayer::vCreateElements() {
	m_pipeline = gst_pipeline_new("appSourcePlayer");
	m_bus = gst_pipeline_get_bus(GST_PIPELINE_CAST((tVoid*)m_pipeline));
	gst_bus_add_watch((GstBus*)m_bus, (GstBusFunc)vOnNewStatus, NULL);
	gst_object_unref(m_bus);
	m_bus = 0;
	m_source = GST_APP_SRC_CAST((tVoid*)(gst_element_factory_make("appsrc", "audio-source")));
	ETG_TRACE_USR4(("ENTRY_THREAD vCreateElements() element=%d", m_source));
}


void appSourcePlayer::vSetupSink() {
	m_sink = gst_element_factory_make("alsasink", NULL);
	g_object_set((GObject *)(m_sink), "buffer-time",  (gint64)800000, NULL);
	g_object_set((GObject *)(m_sink), "device", m_SinkName.c_str(), NULL);
	g_object_set((GObject *)(m_sink), "can-activate-pull", true, NULL);
}



void appSourcePlayer::vSetupFileSink() {
	m_sink = gst_element_factory_make("filesink", "mysink");
	m_volume = gst_element_factory_make("wavenc", "wavenc");
	g_object_set((GObject *)(m_sink), "location", "/var/opt/bosch/dynamic/ffs/sample.wav", NULL);
	m_sinkBin = (GstElement*)(gst_bin_new("output"));
	gst_bin_add_many(GST_BIN_CAST((tVoid*)m_sinkBin), m_volume, m_sink, NULL);
	if (!gst_element_link(m_volume, m_sink))
	{
		ETG_TRACE_USR4(("ENTRY_THREAD: Failed to link volume and sink=%d", m_Elements[0]));
		return;
	}
	GstPad *pad = gst_element_get_static_pad(m_volume, "sink");
	gst_element_add_pad(m_sinkBin, gst_ghost_pad_new("sink", pad));
	gst_object_unref((GObject *)(pad));
}


void appSourcePlayer::vGetFrameStatusFromDecoder()
{
   g_object_get ((GObject *)(m_poAppSourcePlayer->m_player),
         "external-frame-corrupt", &bNonReliabilityIndictaion,
         "last-au-ok", &bLastFrameStatus,
         "external-frame-count", &m_u32TotalFrameCount,
         "superframe-parse-error-count", &m_u32SuperFrameCrcFailCount,
         "erroneous-au-count", &m_u32AudioFrameCrcFailCount, NULL);
}


void appSourcePlayer::vGetFrameUpdate(GstElement * /*pipeline*/, guint /*size*/)
{
   m_poAppSourcePlayer->vGetFrameStatusFromDecoder();

   ETG_TRACE_USR4( ("NonReliabilityIndictaion %d, LastFrameStatus %d, TotalFrameCount %d, SuperFrameCrcFailCount %d, AudioFrameCrcFailCount %d\n",
         bGetNonReliabilityStatus(), bGetLastFrameStatus(), u32GetTotalFrames(), u32GetSuperFrameCorruptCount(), u32GetAudioFrameCorruptCount()));
}


void appSourcePlayer::vSetCallBacks()
{
	g_object_set((GObject *)(m_player), "conceal-fadeout-slope", 2, NULL);
	g_object_set((GObject *)(m_player), "conceal-fadein-slope", 16, NULL);
	g_object_set((GObject *)(m_player), "conceal-mute-release", 16, NULL);
	g_object_set((GObject *)(m_source), "stream-type", 0, NULL);
    g_object_set((GObject *)(m_queue2), "ring-buffer-max-size", (gint64)90000, NULL); // 48000 khz * 0,4s * 16 bit * 2 channels *1,1 (factor)
	g_signal_connect(gpointer(m_source), "need-data", G_CALLBACK(startFeed), NULL);
	g_signal_connect(gpointer(m_player), "notify::last-au-ok", G_CALLBACK(vGetFrameUpdate), NULL);
}


void appSourcePlayer::vSetCaps() {
   gint channels = ((m_AudioMode > 0) ? 2 : 1);
	GstCaps *caps = gst_caps_new_simple ("audio/x-raw-int",
         "rate", G_TYPE_INT, m_AudioSamplingRate,
         "channels", G_TYPE_INT, channels,
         "width", G_TYPE_INT, 16, "depth", G_TYPE_INT, 16,
         "signed", G_TYPE_BOOLEAN, TRUE,
         NULL);
	g_object_set((GObject *)(m_capsfilter), "caps", caps, NULL);

	ETG_TRACE_USR4(("ENTRY_THREAD: vSetCaps channels = %d m_AudioSamplingRate= %d", channels, m_AudioSamplingRate));
	gst_caps_unref (caps);
}

bool appSourcePlayer::bLinkElements() {
	unsigned int u32Index = 0;
	gst_bin_add(GST_BIN_CAST((tVoid*)m_pipeline), GST_ELEMENT_CAST(m_source));
	for (u32Index = 0; u32Index < m_Elements.size(); u32Index++)
	{
		gst_bin_add(GST_BIN_CAST((tVoid*)m_pipeline), GST_ELEMENT_CAST(m_Elements[u32Index]));
	}
	gst_bin_add(GST_BIN_CAST((tVoid*)m_pipeline), GST_ELEMENT_CAST(m_sink));
	if (!gst_element_link(GST_ELEMENT_CAST(m_source), m_Elements[0]))
	{
		ETG_TRACE_USR4(("ENTRY_THREAD: Failed to link element=%d elementname=%s", m_Elements[0], gst_element_get_name(m_Elements[0])));
		return false;
	}
	for (u32Index = 1; u32Index < m_Elements.size(); u32Index++)
	{
		if (!gst_element_link(m_Elements[u32Index - 1], m_Elements[u32Index]))
		{
			ETG_TRACE_USR4(("ENTRY_THREAD: Failed to link elementname = %s", gst_element_get_name(m_Elements[u32Index])));
			return false;
		}
	}
	if (!gst_element_link( m_Elements[u32Index - 1], GST_ELEMENT_CAST(m_sink)))
	{
		ETG_TRACE_USR4(("ENTRY_THREAD: Failed to link sink"));
		return false;
	}
	return true;
}


void appSourcePlayer::vLinkSink() {
	g_object_set((static_cast<gpointer>(m_pipeline)), "audio-sink", m_sinkBin, NULL);
}


void appSourcePlayer::vCleanPipeLine() {
	ETG_TRACE_USR4(("GSTREAMER_THREAD: vCleanPipeLine()... pipeline cleaned"));
	if (m_pipeline)
	{
		g_source_remove_by_user_data(m_pipeline);
		GstStateChangeReturn ret = gst_element_set_state(m_pipeline, GST_STATE_NULL);
		ETG_TRACE_USR4(("GstStateChangeReturn() ret : %d", ret));
		gst_object_unref(static_cast<gpointer>(m_pipeline));
		m_pipeline = NULL;
	}
	if (m_loop)
	{
		g_main_loop_unref(m_loop);
		m_loop = 0;
		ETG_TRACE_USR4(("GSTREAMER_THREAD: vCleanPipeLine()... loop reference removed"));
	}
	m_volume = NULL;
    vSetCleanPipeLineState(false);
}

void appSourcePlayer::vSetupLoop() {
	ETG_TRACE_USR4(("ENTRY_THREAD: vSetupLoop()"));
	gst_element_set_state(m_pipeline, GST_STATE_READY);
	m_loop = g_main_loop_new(NULL, FALSE);
}


void appSourcePlayer::vStartLoop() {
	ETG_TRACE_USR4(("APP_THREAD: vStartLoop()"));
	g_main_loop_run(m_loop);
}

void appSourcePlayer::startFeed(GstElement * pipeline, guint size){
	ETG_TRACE_USR4(("GSTREAMER_THREAD: startFeed()pipeline=%d size=%d", pipeline,size));
	bReadData();
}


gboolean appSourcePlayer::bReadData(){
	return m_poAppSourcePlayer->bSendNextFrame();
}


void appSourcePlayer::stopFeed(GstElement * pipeline, guint size){
	ETG_TRACE_USR4(("GSTREAMER_THREAD: stopFeed()-->stop feeding pipeline=%d size=%d", pipeline, size));
}


void appSourcePlayer::vQuitPipeline(){
    ETG_TRACE_USR4(("GSTREAMER_THREAD: vQuitPipeline()"));
	if (m_poAppSourcePlayer->m_loop)
	{
		g_main_loop_quit(m_poAppSourcePlayer->m_loop);
	}
    bIsAppReady = false;
	bSendFrame=false;
	vSetCleanPipeLineState(true);
	if(m_pthreadcreate_returnvalue == 0)
	{
	   pthread_join(thread, NULL);
	}
	pthread_mutex_unlock(&lock);
	sem_destroy(&semaphore);
	pthread_mutex_destroy(&lock);
}


gboolean appSourcePlayer::vOnNewStatus(GstBus *bus, GstMessage *msg, gpointer data){
	ETG_TRACE_USR4(("GSTREAMER_THREAD: vOnNewStatus()bus=%d data=%d", bus,data));
	if (m_poAppSourcePlayer->bIsAppReady == false)
	{
		m_poAppSourcePlayer->bIsAppReady = true;
		sem_post(&m_poAppSourcePlayer->semaphore);
	}
	switch (GST_MESSAGE_TYPE(msg)) {
	case GST_MESSAGE_STATE_CHANGED: {
		GstState old_state, new_state;
		gst_message_parse_state_changed(msg, &old_state, &new_state, NULL);
		vTrace("Element %s changed state from %s to %s.\n",
				GST_OBJECT_NAME(msg->src),
				gst_element_state_get_name(old_state),
				gst_element_state_get_name(new_state));
		ETG_TRACE_USR4(("GSTREAMER_THREAD: Element %s changed ", GST_OBJECT_NAME(msg->src)));
		ETG_TRACE_USR4(("GSTREAMER_THREAD: from state %s ", gst_element_state_get_name(old_state)));
		ETG_TRACE_USR4(("GSTREAMER_THREAD: to state   %s ", gst_element_state_get_name(new_state)));
		break;
	}
	case GST_MESSAGE_PROGRESS:
		ETG_TRACE_USR4(("GSTREAMER_THREAD: vOnNewStatus()--> GST_MESSAGE_PROGRESS"));
		break;
	case GST_MESSAGE_WARNING:
		ETG_TRACE_USR4(("GSTREAMER_THREAD: vOnNewStatus()--> GST_MESSAGE_WARNING"));
		break;
	case GST_MESSAGE_EOS:
		vTrace("End of stream\n");
		ETG_TRACE_USR4(("GSTREAMER_THREAD: vOnNewStatus()--> GST_MESSAGE_EOS"));
		g_main_loop_quit(m_poAppSourcePlayer->m_loop);
		break;
	case GST_MESSAGE_ERROR: {
		ETG_TRACE_USR4(("GSTREAMER_THREAD:  vOnNewStatus()--> GST_MESSAGE_ERROR"));
		gchar  *debug;
		GError *error;
		gst_message_parse_error(msg, &error, &debug);
		g_free(debug);
		ETG_TRACE_USR4(("GSTREAMER_THREAD: Error: %s", error->message));
		g_error_free(error);

		if(!gst_pipeline_get_auto_flush_bus (GST_PIPELINE(m_poAppSourcePlayer->m_pipeline)))//lint !e826  
		{
		   gst_pipeline_set_auto_flush_bus(GST_PIPELINE(m_poAppSourcePlayer->m_pipeline), true);//lint !e826  
		}
		m_poAppSourcePlayer->vChangeStateToNull();		
		gst_pipeline_set_auto_flush_bus(GST_PIPELINE(m_poAppSourcePlayer->m_pipeline), false);//lint !e826  

        gst_element_set_state(m_poAppSourcePlayer->m_pipeline, GST_STATE_READY);
        m_poAppSourcePlayer->bPlay();
		break;
	}
	default:
	{
		ETG_TRACE_USR4(("vOnNewStatus()--> default=%d", GST_MESSAGE_TYPE(msg)));
		break;
	}
	}
	return TRUE;
}


int appSourcePlayer::getFrameCount(){
	return drmFrames.size();
}



bool appSourcePlayer::bGetCleanPipeLineState()
{
   return m_bCleanPipelineInProgress;
}


void appSourcePlayer::vSetCleanPipeLineState(bool bNewValue)
{
   pthread_mutex_lock(&CleanPipelineLock);
   m_bCleanPipelineInProgress = bNewValue;
   pthread_mutex_unlock(&CleanPipelineLock);
}
