/**************************************************************************//**
* \file     clServerProperty.cpp
*
*           Base class for CCA property implementations.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "CcaApp/clServerProperty.h"
#include "CcaApp/clCCAhandler.h"
#include "tuner_trace.h"


using namespace tuner::CcaApp;


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_CCA_HANDLER
#include "trcGenProj/Header/clServerProperty.cpp.trc.h"
#endif

/**************************************************************************//**
* Destructor
******************************************************************************/
clServerProperty::~clServerProperty()
{
   OSAL_DELETE m_poNotificationTable;
   m_poNotificationTable = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clServerProperty::clServerProperty(tU16 u16FunctionID, clCCAhandler* poCCAhandler)
   : clFunction(u16FunctionID, poCCAhandler),
     m_u16DestAppID(AMT_C_U32_BASEMSG_SOURCEAPPID),
     m_u16RequestCmdCtr(0), m_u32RequestType(AMT_C_U8_CCAMSG_OPCODE_UPREG),
     m_u16RegisterId(0)
{
   m_poNotificationTable = OSAL_NEW ahl_tclNotificationTable(1);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerProperty::vHandleMessage(amt_tclServiceData* poInMsg)
{
   if (poInMsg != NULL)
   {
      switch (poInMsg->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_SET:
            vSaveResponseParameters(poInMsg);
            vSet(poInMsg);
            break;

         case AMT_C_U8_CCAMSG_OPCODE_GET:
            vSaveResponseParameters(poInMsg);
            vGet(poInMsg);
            break;

         case AMT_C_U8_CCAMSG_OPCODE_UPREG:
            vAddToNotificationTable(poInMsg);
            vUpreg(poInMsg);
            break;

         case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
            vRemoveFromNotificationTable(poInMsg);
            break;

         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
            m_poCCAhandler->vTpegSendErrorMessage(
               poInMsg->u16GetFunctionID(),
               m_poCCAhandler->m_u16InvalidOpCodeError);
            break;

         default:
            break;
      }
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vAddToNotificationTable(amt_tclServiceData* poInMessage)
{
   if ((poInMessage != NULL) && (m_poNotificationTable != NULL))
   {
      (tVoid)m_poNotificationTable->bAddNotification(
            poInMessage->u16GetFunctionID(),
            poInMessage->u16GetSourceAppID(),
            poInMessage->u16GetRegisterID(),
            TRUE,
            poInMessage->u16GetCmdCounter(),
            poInMessage->u16GetSourceSubID());

      ETG_TRACE_USR1((
         "UPREG INFO - FunctionID %x, AppID %x CommandCounter %d",
         poInMessage->u16GetFunctionID(),
         poInMessage->u16GetSourceAppID(),
         poInMessage->u16GetCmdCounter()));
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vRemoveFromNotificationTable(amt_tclServiceData* poInMessage)
{
   if ((poInMessage != NULL) && (m_poNotificationTable != NULL))
   {
      (tVoid)m_poNotificationTable->bRemoveNotification(
            poInMessage->u16GetFunctionID(),
            poInMessage->u16GetSourceAppID(),
            poInMessage->u16GetRegisterID(),
            TRUE,
            poInMessage->u16GetCmdCounter(),
            poInMessage->u16GetSourceSubID());
      ETG_TRACE_USR1((
         "RELUPREG INFO - FunctionID %x, AppID %x CommandCounter %d",
         poInMessage->u16GetFunctionID(),
         poInMessage->u16GetSourceAppID(),
         poInMessage->u16GetCmdCounter()));
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vSaveResponseParameters(amt_tclServiceData* poInMessage)
{
   if (poInMessage != NULL)
   {
      m_u16DestAppID = poInMessage->u16GetSourceAppID();
      m_u32RequestType = poInMessage->u8GetOpCode();
      m_u16RequestCmdCtr = poInMessage->u16GetCmdCounter();
      m_u16RegisterId = poInMessage->u16GetRegisterID();

      ETG_TRACE_USR1((
         "AppId %x, ReqType %d,RequestCmdCtr %d",
         m_u16DestAppID,
         m_u32RequestType,
         m_u16RequestCmdCtr));
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vStatus(fi_tclTypeBase& oOutData)
{
   if (m_u32RequestType != AMT_C_U8_CCAMSG_OPCODE_UPREG)
   {
      m_poCCAhandler->vSendMessage( 
         m_u16DestAppID,
         m_u16RequestCmdCtr,
         m_u16RegisterId,
         oOutData,
         u16GetFunctionID(),
         AMT_C_U8_CCAMSG_OPCODE_STATUS);
      ETG_TRACE_USR1(("CmdCtrValue %d  RequestType %d", m_u16RequestCmdCtr, m_u32RequestType));
      m_u32RequestType = AMT_C_U8_CCAMSG_OPCODE_UPREG;
   }
   else
   {
      vStatusToRegisteredClients(oOutData);
   }
}

/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vStatus(fi_tclTypeBase& oOutData, tU16 u16AppID)
{
   if (m_u32RequestType != AMT_C_U8_CCAMSG_OPCODE_UPREG)
   {
      m_poCCAhandler->vSendMessage(
         m_u16DestAppID,
         m_u16RequestCmdCtr,
         m_u16RegisterId,
         oOutData,
         u16GetFunctionID(),
         AMT_C_U8_CCAMSG_OPCODE_STATUS);
      ETG_TRACE_USR1(("CmdCtrValue %d  RequestType %d", m_u16RequestCmdCtr, m_u32RequestType));
      m_u32RequestType = AMT_C_U8_CCAMSG_OPCODE_UPREG;
   }
   else
   {
	   vStatusToRegisteredClientID(oOutData , u16AppID);
   }
}

/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vError(tU16 u16FunctionID,tU16 u16ErrorCode)
{
	if (m_poNotificationTable != NULL)
	   {
	      ahl_tNotification* pNotify = m_poNotificationTable->poGetNotificationList(u16FunctionID);
	      for ( ; pNotify != OSAL_NULL; pNotify = pNotify->pNext)
	      {
	         m_poCCAhandler->vTpegSendErrorMessage(
	            pNotify->u16AppID,
	            pNotify->u16CmdCounter,
	            pNotify->u16RegisterID,
	            u16FunctionID,
	            u16ErrorCode);
	        ETG_TRACE_USR1(("ClientAppID %x CmdCtrValue %d", pNotify->u16AppID, pNotify->u16CmdCounter));
	      }
	   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vStatusToRegisteredClients(fi_tclTypeBase& oOutData)
{
   if (m_poNotificationTable != NULL)
   {
      ahl_tNotification* pNotify = m_poNotificationTable->poGetNotificationList(u16GetFunctionID());
      for ( ; pNotify != OSAL_NULL; pNotify = pNotify->pNext)
      {
         m_poCCAhandler->vSendMessage(
            pNotify->u16AppID,
            pNotify->u16CmdCounter,
            pNotify->u16RegisterID,
            oOutData,
            u16GetFunctionID(),
            AMT_C_U8_CCAMSG_OPCODE_STATUS);
        ETG_TRACE_USR1(("ClientAppID %x CmdCtrValue %d", pNotify->u16AppID, pNotify->u16CmdCounter));
      }
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerProperty::vStatusToRegisteredClientID(fi_tclTypeBase& oOutData , tU16 u16ClientID)
{
   if (m_poNotificationTable != NULL)
   {
      ahl_tNotification* pNotify = m_poNotificationTable->poGetNotificationList(u16GetFunctionID());
      for ( ; pNotify != OSAL_NULL; pNotify = pNotify->pNext)
      {
    	 if(u16ClientID ==  pNotify->u16AppID)
    	 {
             m_poCCAhandler->vSendMessage(
                pNotify->u16AppID,
                pNotify->u16CmdCounter,
                pNotify->u16RegisterID,
                oOutData,
                u16GetFunctionID(),
                AMT_C_U8_CCAMSG_OPCODE_STATUS);
            ETG_TRACE_USR1(("vStatusToRegisteredClientID, ClientAppID %x CmdCtrValue %d", pNotify->u16AppID, pNotify->u16CmdCounter));
            break;
    	 }
     }
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerProperty::vSet(amt_tclServiceData* /*poInMsg*/)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerProperty::vUpreg(amt_tclServiceData* /*poInMsg*/)
{
}

tVoid clServerProperty::vConstructSelfPostMessage(unsigned char* /*puchData*/)
{

}

tVoid clServerProperty::vSendMessage ( tU16             u16DestAppID,
                                fi_tclTypeBase&  oOutData,
                                tU16             u16Fid,
                                tU8              u8OpCode,
                                tU16             u16CmdCtr,
                                tU16             u16RegId)
{
    m_poCCAhandler->vSendMessage(
            u16DestAppID,
            u16CmdCtr,
            u16RegId,
            oOutData,
            u16Fid,
            u8OpCode);
}
