/**************************************************************************//**
* \file     clServerMethod.h
*
*           See .cpp file for description.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clMethodServer_h
#define clMethodServer_h


#include "CcaApp/clFunction.h"


#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "common_fi_if.h"

#include <vector>



namespace tuner
{
   namespace CcaApp
   {
      class clServerMethodObserver;


      class clServerMethod : public tuner::CcaApp::clFunction
      {
      public:
         virtual ~clServerMethod();
         clServerMethod(tU16 u16FunctionID, tuner::CcaApp::clCCAhandler* poCCAhandler);
         virtual tVoid vHandleMessage(amt_tclServiceData* poInMsg);
         tVoid vRegisterObserver(tuner::CcaApp::clServerMethodObserver* poObserver);
         tVoid vSendMethodResult(fi_tclTypeBase& oOutData);
         tVoid vSendErrorMessage(tU16 u16ErrorCode);
         tU16 u16GetCmdCtr() const;
         virtual tVoid vConstructSelfPostMessage(unsigned char* puchData);

      protected:
         virtual tVoid vMethodStart(amt_tclServiceData* poInMsg) = 0;
         virtual tVoid vSendMessage( tU16             u16DestAppID,
                                  fi_tclTypeBase&  oOutData,
                                  tU16             u16Fid,
                                  tU8              u8OpCode,
                                  tU16             u16CmdCtr,
                                  tU16             u16RegId);
         tVoid vSendMethodResult();
         tVoid vTraceMethodStartData(amt_tclServiceData* poInMsg);
         tVoid vNotifyObservers();

      private:
         tU16 m_u16DestAppID;
         tU16 m_u16CmdCtr;
         tU16 m_u16RegisterID;
         tVoid vSaveResponseParameters(amt_tclServiceData* poInMessage);

         std::vector<tuner::CcaApp::clServerMethodObserver*> m_observers;
      };
   }
}


#endif
