/**************************************************************************//**
* \file     clClientProperty.cpp
*
*           Base class for CCA property implementations.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "CcaApp/clClientProperty.h"
#include "CcaApp/clCCAhandler.h"
#include "CcaApp/clClientPropertyObserver.h"


using namespace tuner::CcaApp;


/**************************************************************************//**
* Destructor
******************************************************************************/
clClientProperty::~clClientProperty()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clClientProperty::clClientProperty(tU16 u16FunctionID, clCCAhandler* poCCAhandler)
   : clFunction(u16FunctionID, poCCAhandler)
{
   m_poCCAhandler->oFiRegHelper.bAddFunctionID(u16FunctionID);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientProperty::vRegisterObserver(clClientPropertyObserver* poObserver)
{
   if (poObserver != NULL)
   {
      m_observers.push_back(poObserver);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientProperty::vNotifyObservers()
{
   std::vector<clClientPropertyObserver* >::iterator iter = m_observers.begin();
   while (iter != m_observers.end())
   {
      if (*iter != NULL)
      {
         (*iter)->vUpdate(u16GetFunctionID());
      }
      iter++;
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientProperty::vHandleMessage(amt_tclServiceData* poInMsg)
{
   switch (poInMsg->u8GetOpCode())
   {
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         m_poCCAhandler->vStartInitSequence(u16GetFunctionID());
         vStatus(poInMsg);
         break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         m_poCCAhandler->vHandleCCAErrorMessage(poInMsg);
         vError(poInMsg);
         break;

      default:
         m_poCCAhandler->vTpegSendErrorMessage(
            poInMsg->u16GetFunctionID(),
            m_poCCAhandler->m_u16InvalidOpCodeError);
         break;
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientProperty::vSet(fi_tclTypeBase& oPayload)
{
   m_poCCAhandler->bTpegSendCCAMessage(u16GetFunctionID(), AMT_C_U8_CCAMSG_OPCODE_SET, oPayload);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientProperty::vError(amt_tclServiceData* /*poInMsg*/ ) 
{
}
