/**************************************************************************//**
* \file     clClientMethod.h
*
*           See .cpp file for description.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clMethodClient_h
#define clMethodClient_h


#include "CcaApp/clFunction.h"

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "common_fi_if.h"

#include <vector>


namespace tuner
{
   namespace CcaApp
   {
      class clClientMethodObserver;
      class clClientMethod : public tuner::CcaApp::clFunction
      {
      public:
         virtual ~clClientMethod();
         clClientMethod(tU16 u16FunctionID, tuner::CcaApp::clCCAhandler* poCCAhandler);
         virtual tVoid vHandleMessage(amt_tclServiceData* poInMessage);
         tVoid vRegisterObserver(clClientMethodObserver* poObserver);
         tVoid vMethodAbort();

      protected:
         tVoid vMethodStart();
         tVoid vMethodStart(fi_tclTypeBase& oPayload);
         virtual tVoid vMethodResult(amt_tclServiceData* poInMessage);
         virtual tVoid vError(amt_tclServiceData* poInMessage);
         tVoid vNotifyObservers(const tU32 u32ErrorCode = 0);

      private:
         std::vector<tuner::CcaApp::clClientMethodObserver* > m_observers;
      };
   }
}

#endif
