/**************************************************************************//**
* \file     clClientMethod.cpp
*
*           Base class for method implementation for CCA clients.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "CcaApp/clClientMethod.h"
#include "CcaApp/clCCAhandler.h"
#include "CcaApp/clClientMethodObserver.h"

using namespace tuner::CcaApp;

/**************************************************************************//**
* Destructor
******************************************************************************/
clClientMethod::~clClientMethod()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clClientMethod::clClientMethod(tU16 u16FunctionID, clCCAhandler* poCCAhandler)
   : clFunction(u16FunctionID, poCCAhandler)
{
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientMethod::vRegisterObserver(tuner::CcaApp::clClientMethodObserver* poObserver)
{
   if (poObserver != NULL)
   {
      m_observers.push_back(poObserver);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientMethod::vNotifyObservers(const tU32 u32ErrorCode)
{
   std::vector<tuner::CcaApp::clClientMethodObserver*>::iterator iter = m_observers.begin();
   while (iter != m_observers.end())
   {
      if (*iter != NULL)
      {
         if (u32ErrorCode == 0)
         {
            (*iter)->vResult(u16GetFunctionID());
         }
         else
         {
            (*iter)->vError(u16GetFunctionID(), u32ErrorCode);
         }
      }
      iter++;
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientMethod::vHandleMessage(amt_tclServiceData* poInMessage)
{
   switch (poInMessage->u8GetOpCode())
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULTFIRST:
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULTMIDDLE:
      case AMT_C_U8_CCAMSG_OPCODE_METHODRESULTLAST:
         vMethodResult(poInMessage);
         break;

      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         m_poCCAhandler->vHandleCCAErrorMessage(poInMessage);
         vError(poInMessage);
         break;

      default:
         m_poCCAhandler->vTpegSendErrorMessage(
            poInMessage->u16GetFunctionID(),
            m_poCCAhandler->m_u16InvalidOpCodeError);
         break;
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientMethod::vMethodStart()
{
   m_poCCAhandler->bTpegSendCCAMessage(
      u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientMethod::vMethodStart(fi_tclTypeBase& oPayload)
{
   m_poCCAhandler->bTpegSendCCAMessage(
      u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
      oPayload);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clClientMethod::vMethodAbort()
{
   m_poCCAhandler->bTpegSendCCAMessage(
      u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_METHODABORT);
}


/**************************************************************************//**
* Default implementation ignores the method result.
******************************************************************************/
tVoid clClientMethod::vMethodResult(amt_tclServiceData* /*poInMessage*/) 
{
}


/**************************************************************************//**
* Default implementation ignores the error.
******************************************************************************/
tVoid clClientMethod::vError(amt_tclServiceData* /*poInMessage*/) 
{
}
