/*****************************************************************************
* FILE:         clCCAhandler.h
* PROJECT:      G3G project
* SW-COMPONENT: __COMPONENT__
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) __YEAR__ Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef clCCAhandler_H_
#define clCCAhandler_H_

#ifndef VARIANT_S_FTR_ENABLE_AHL_MOCK
#define AHL_S_IMPORT_INTERFACE_NOTIFICTABLE
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#else
#include "ahl_mock/ahl_if.h"         // use Application Help Library
#endif

#define UTFUTIL_S_IMPORT_INTERFACE_GENERIC
#include "utf_if.h"

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "common_fi_if.h"

#include "CcaApp/clCCAhandler.h"
#include "CcaApp/clIFiPropRegHelper.h"

#ifndef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif


#define TPEG_UPREG_CMD_COUNTER 1
#define ERROR_NOTAVAILABLE 0x000B

class ail_tclAppInterface;

namespace tuner
{
   namespace CcaApp
   {
      class clFunction;
      class clCCAhandler
      {

      public:
         clCCAhandler(ail_tclAppInterface *poMainApp, tU16 u16ServiceID, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion, tU16 u16TargetAppID, tU16 u16SourceAppID);
         virtual ~clCCAhandler();
         clCCAhandler& operator = (const clCCAhandler &oClientHandler);

         virtual const tChar* getName() const { return "clCCAhandler"; };


         tVoid vStartInitSequence(tU16 u16FunctionID);

         tVoid vHandleCCAErrorMessage(amt_tclServiceData* poInMessage);
         tVoid vTpegSendErrorMessage(tU16 u16FunctionId, tU16 u16ErrorId);
         tVoid vSendErrorMessage(tU16 u16Fid, tU16 u16ErrorCode);
         tVoid vTpegSendErrorMessage(tU16 u16DestAppID,
            tU16 u16CmdCounter,
            tU16 u16RegId,
            tU16 u16Fid,
            tU16 u16ErrorCode);
         tBool bTpegSendCCAMessage(tU16 u16FunctionId, tU8 u8OpCode);
         tBool bTpegSendCCAMessage(tU16 u16Fid,
            tU8  u8OpCode,
            fi_tclTypeBase& oOutData,
            tU8  u8StreamType = AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
            tU8  u8StreamCounter = 0);

         virtual tVoid vGetDataFromAmt(amt_tclServiceData* poFIMsg,
            fi_tclTypeBase &oFIData);




         virtual tVoid vSendMessage(tU16 u16DestAppID,
            tU16 u16CmdCtr,
            tU16 u16RegId,
            fi_tclTypeBase& oOutData,
            tU16 u16Fid,
            tU8 u8OpCode);

         virtual tVoid vSendEmptyMessage(tU16 u16DestAppID,
            tU16 u16CmdCtr,
            tU16 u16RegID,
            tU16 u16Fid,
            tU8 u8Opcode);


         tVoid vAddFunction(tuner::CcaApp::clFunction* poFunction);
         tuner::CcaApp::clFunction* poGetFunction(tU16 u16FunctionID);
         tBool bSendCCAMessage(tU16 u16Fid, tU8 u8OpCode);
         tVoid vHandleMessage(amt_tclServiceData* poInMsg);
         tVoid vTraceCCAMessage(amt_tclServiceData* poInMsg);


         tVoid vSetRegisterId(tU16 u16RegisterId);
         tU16 u16GetRegID();

      private:
         tU16 m_u16MajorVersion;
         tU16 m_u16MinorVersion;
         tU16 m_u16ServiceID;
         tU16 m_u16TargetAppID;
         tU16 m_u16RegisterId;
         tU16 m_u16SourceAppID;

      public:
         tBool bRegisterForAllFID();

      private:
         tBool bRegisterForFID(tU16 u16FID);
         tVoid vSetRegisterId();
         tU16 u16GetM_TARGET_CCA_SRV();
         tU16 u16GetM_TARGET_CCA_APP();

      protected:
         std::vector <tuner::CcaApp::clFunction*> m_VectorFunction;
         //virtual const mm_tMsgMap* GetMsgMap() const;
         ail_tclAppInterface* m_poMainApp;

      public:
         tU16 m_u16InvalidOpCodeError;
         tuner::CcaApp::clIFiPropRegHelper oFiRegHelper;


         /***************************************************************************
         * Message map definition macro
         ***************************************************************************/

      };
   }
}

#endif // _clCCAhandler_H_

