///////////////////////////////////////////////////////////
//  clServerMethod.h
//  Implementation of the Class clServerMethod
//  Created on:      14-Jan-2015 10:19:02
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_DF2E7AF9_D395_4c65_B8A9_87E1B371ED0E__INCLUDED_)
#define EA_DF2E7AF9_D395_4c65_B8A9_87E1B371ED0E__INCLUDED_

#include "clFunction.h"
#include "ADRMsg/ADRMsg_if.h"

namespace tuner
{
	namespace AarsApp
	{
		/**
		 * @author pad1cob
		 * @version 1.0
		 * @created 14-Jan-2015 10:19:02
		 */
      class clAarsHandler;
		class clServerMethod : public tuner::AarsApp::clFunction
		{

		public:
			clServerMethod();
			virtual ~clServerMethod();

			/**
			 * handler for incoming ADR messages
			 * 
			 * @param bitStream
			 */
			virtual void vHandleMessage(tunerVector<unsigned char> & bitStream);
			/**
			 * 
			 * @param oOutData
			 */
			void vSendMethodResult(clADRMsgPayload& oOutData);
			/**
			 * 
			 * @param poAarsHandler
			 * @param functionID    u16FunctionID
			 * @param ClientID
			 * @param FBlockID
			 * @param InstanceID
			 */
			clServerMethod(tuner::AarsApp::clAarsHandler* poAarsHandler, short functionID, unsigned short ClientID, unsigned short FBlockID, unsigned char InstanceID);

		protected:
			/**
			 * 
			 * @param bitStream
			 */
			virtual void vMethodStart(tunerVector<unsigned char> bitStream);

		};

	}

}
#endif // !defined(EA_DF2E7AF9_D395_4c65_B8A9_87E1B371ED0E__INCLUDED_)
