///////////////////////////////////////////////////////////
//  clFunction.h
//  Implementation of the Class clFunction
//  Created on:      14-Jan-2015 10:18:55
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_1C197B32_4DF0_4ac2_9434_E8A0BD87C696__INCLUDED_)
#define EA_1C197B32_4DF0_4ac2_9434_E8A0BD87C696__INCLUDED_

#include  "datatypes/tVector.h"

namespace tuner
{
	namespace AarsApp
	{
		/**
		 * @author pad1cob
		 * @version 1.0
		 * @created 14-Jan-2015 10:18:55
		 */
      class clAarsHandler;
		class clFunction
		{

		public:
			
			virtual ~clFunction();

			/**
			 * Overloaded constructor
			 * 
			 * @param poAarsHandler
			 * @param functionID
			 */
			unsigned short getu16FunctionID();
			/**
			 * handler for incoming ADR messages
			 * 
			 * @param bitStream
			 */
			virtual void vHandleMessage(tunerVector<unsigned char> & bitStream);
			/**
			 * Overloaded constructor
			 * 
			 * @param poAarsHandler
			 * @param functionID    functionID
			 * @param ClientID
			 * @param FBlockID
			 * @param InstanceID
			 */
			clFunction(tuner::AarsApp::clAarsHandler* poAarsHandler, short functionID, unsigned short ClientID, unsigned short FBlockID, unsigned char InstanceID);
			clFunction(tuner::AarsApp::clAarsHandler* poAarsHandler, unsigned short StartFunctionID,unsigned short EndFunctionID, unsigned short ClientID, unsigned short FBlockID, unsigned char InstanceID);
			unsigned short getu16ClientID();
			unsigned short getu16FBlockID();
			unsigned char getu8InstanceID();
			unsigned short getStartFunctionID();
			unsigned short getEndFunctionID();
			/**
			 * 
			 * @param newVal
			 */
			void setu16ClientID(unsigned short newVal);
			/**
			 * 
			 * @param newVal
			 */
			void setu16FBlockID(unsigned short newVal);
			/**
			 * 
			 * @param newVal
			 */
			void setu8InstanceID(unsigned char newVal);

			virtual void vOnServiceAvailable();

		protected:

			tuner::AarsApp::clAarsHandler* m_poAarsHandler;
			/**
			 *
			 * @param newVal
			 */
			void setu16FunctionID(unsigned short newVal);

			clFunction();

		private:
			/**
			 * The function ID supported by the interface
			 */
			unsigned short u16FunctionID;
			unsigned short u16ClientID;
			unsigned short u16FBlockID;
			unsigned char u8InstanceID;
			unsigned short u16StartFunctionID;
			unsigned short u16EndFunctionID;

		};

	}

}
#endif // !defined(EA_1C197B32_4DF0_4ac2_9434_E8A0BD87C696__INCLUDED_)
