///////////////////////////////////////////////////////////
//  clClientProperty.h
//  Implementation of the Class clClientProperty
//  Created on:      14-Jan-2015 13:42:48
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_1177886E_A374_44eb_878D_8A1D7C1A4F71__INCLUDED_)
#define EA_1177886E_A374_44eb_878D_8A1D7C1A4F71__INCLUDED_

#include "clFunction.h"
#include "ADRMsg/ADRMsg_if.h"

namespace tuner
{
	namespace AarsApp
	{
		/**
		 * @author pad1cob
		 * @version 1.0
		 * @created 14-Jan-2015 13:42:48
		 */
		class clClientProperty : public tuner::AarsApp::clFunction
		{

		public:
			clClientProperty();
			virtual ~clClientProperty();

			/**
			 * handler for incoming ADR messages
			 * 
			 * @param bitStream
			 */
			virtual void vHandleMessage(tunerVector<unsigned char> & bitStream);
			/**
			 * 
			 * @param poAarsHandler
			 * @param functionID    u16FunctionID
			 * @param ClientID
			 * @param FBlockID
			 * @param InstanceID
			 */
			clClientProperty(tuner::AarsApp::clAarsHandler* poAarsHandler, unsigned short functionID, unsigned short ClientID, unsigned short FBlockID, unsigned char InstanceID);
			clClientProperty(tuner::AarsApp::clAarsHandler* poAarsHandler, unsigned short StartFunctionID, unsigned short EndFunctionID, unsigned short ClientID, unsigned short FBlockID, unsigned char InstanceID);


		protected:
			/**
			 * 
			 * @param bitStream
			 */
			virtual void vError(tunerVector<unsigned char> bitStream);
			/**
			 * 
			 * @param oPayload
			 */
			void vSet(clADRMsgPayload & oPayload);
			/**
			 * 
			 * @param oPayload
			 */
			void vGet(clADRMsgPayload & oPayload);
			/**
			 *
			 * @param oPayload
			 */
			void vSetGet(clADRMsgPayload & oPayload);
			void vIncrement(clADRMsgPayload & oPayload);
			void vDecrement(clADRMsgPayload & oPayload);
			/**
			 *
			 * @param bitStream
			 */
			virtual void vStatus(tunerVector<unsigned char> & bitStream);

		};

	}

}
#endif // !defined(EA_1177886E_A374_44eb_878D_8A1D7C1A4F71__INCLUDED_)
