///////////////////////////////////////////////////////////
//  clClientProperty.cpp
//  Implementation of the Class clClientProperty
//  Created on:      14-Jan-2015 13:42:48
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clClientProperty.h"
#include "clAarsHandler.h"

#include "tuner_trace.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clClientProperty.cpp.trc.h"
#endif

using tuner::AarsApp::clClientProperty;


clClientProperty::clClientProperty(){

}



clClientProperty::~clClientProperty(){

}





void clClientProperty::vError(tunerVector<unsigned char> /*bitStream*/){

}


void clClientProperty::vHandleMessage(tunerVector<unsigned char> & bitStream){
   clADRInMsg oMsg(bitStream, true);
	switch(oMsg.getHeader().getu8OpCode())
	{
	case ADR_MSG_U8_STATUS:
		vStatus(bitStream);
		break;
	case ADR_MSG_U8_ERROR:
		vError(bitStream);
		break;
	default:
		break;
	}
}


void clClientProperty::vSet(clADRMsgPayload & oPayload){
	clADRMsgHeader oHeader;
	oHeader.setu16ClientId(getu16ClientID());
	oHeader.setu16FBlockId(getu16FBlockID());
	oHeader.setu16FunctionId(getu16FunctionID());
	oHeader.setu8InstanceId(getu8InstanceID());
	oHeader.setu8OpCode(ADR_MSG_U8_SET);
	clADROutMsg oMsg(oHeader, &oPayload);
	tunerVector<unsigned char> msgData = oMsg.oSerialize();
	m_poAarsHandler->vWaitOnMessageQue(&(msgData[0]), msgData.size());
}

void clClientProperty::vGet(clADRMsgPayload & oPayload){
	clADRMsgHeader oHeader;
	oHeader.setu16ClientId(getu16ClientID());
	oHeader.setu16FBlockId(getu16FBlockID());
	oHeader.setu16FunctionId(getu16FunctionID());
	oHeader.setu8InstanceId(getu8InstanceID());
	oHeader.setu8OpCode(ADR_MSG_U8_GET);
	clADROutMsg oMsg(oHeader, &oPayload);
	tunerVector<unsigned char> msgData = oMsg.oSerialize();
	m_poAarsHandler->vWaitOnMessageQue(&(msgData[0]), msgData.size());
}

void clClientProperty::vSetGet(clADRMsgPayload & oPayload){
	clADRMsgHeader oHeader;
	oHeader.setu16ClientId(getu16ClientID());
	oHeader.setu16FBlockId(getu16FBlockID());
	oHeader.setu16FunctionId(getu16FunctionID());
	oHeader.setu8InstanceId(getu8InstanceID());
	oHeader.setu8OpCode(ADR_MSG_U8_SETGET);
	clADROutMsg oMsg(oHeader, &oPayload);
	tunerVector<unsigned char> msgData = oMsg.oSerialize();
	m_poAarsHandler->vWaitOnMessageQue(&(msgData[0]), msgData.size());
}


void clClientProperty::vIncrement(clADRMsgPayload & oPayload){
	clADRMsgHeader oHeader;
	oHeader.setu16ClientId(getu16ClientID());
	oHeader.setu16FBlockId(getu16FBlockID());
	oHeader.setu16FunctionId(getu16FunctionID());
	oHeader.setu8InstanceId(getu8InstanceID());
	oHeader.setu8OpCode(ADR_MSG_U8_INCREMENT);
	clADROutMsg oMsg(oHeader, &oPayload);
	tunerVector<unsigned char> msgData = oMsg.oSerialize();
	m_poAarsHandler->vWaitOnMessageQue(&(msgData[0]), msgData.size());
}

void clClientProperty::vDecrement(clADRMsgPayload & oPayload){
	clADRMsgHeader oHeader;
	oHeader.setu16ClientId(getu16ClientID());
	oHeader.setu16FBlockId(getu16FBlockID());
	oHeader.setu16FunctionId(getu16FunctionID());
	oHeader.setu8InstanceId(getu8InstanceID());
	oHeader.setu8OpCode(ADR_MSG_U8_DECREMENT);
	clADROutMsg oMsg(oHeader, &oPayload);
	tunerVector<unsigned char> msgData = oMsg.oSerialize();
	m_poAarsHandler->vWaitOnMessageQue(&(msgData[0]), msgData.size());
}

void clClientProperty::vStatus(tunerVector<unsigned char> & /*bitStream*/){

}



clClientProperty::clClientProperty(tuner::AarsApp::clAarsHandler* poAarsHandler, unsigned short functionID, unsigned short ClientID, unsigned short FBlockID, unsigned char InstanceID)
     : clFunction(poAarsHandler, functionID ,ClientID, FBlockID, InstanceID){

}

clClientProperty::clClientProperty(tuner::AarsApp::clAarsHandler* poAarsHandler, unsigned short StartFunctionID, unsigned short EndFunctionID, unsigned short ClientID, unsigned short FBlockID, unsigned char InstanceID)
	 : clFunction(poAarsHandler, StartFunctionID, EndFunctionID ,ClientID, FBlockID, InstanceID){
}
