///////////////////////////////////////////////////////////
//  clTAMessageStatus.h
//  Implementation of the Class clTAMessageStatus
//  Created on:      29-May-2015 3:33:00 PM
///////////////////////////////////////////////////////////

#if !defined(EA_E679F63C_71BC_449b_876C_3F9FDE8FEEBE__INCLUDED_)
#define EA_E679F63C_71BC_449b_876C_3F9FDE8FEEBE__INCLUDED_

#include "clADRMsgPayload.h"

class clTAMessageStatus : public clADRMsgPayload
{

public:
	/**
	 * Boolean(1 byte)
	 * Bit 0 False TA not active
	 *       True  TA active
	 * Bit 1 False EON not active
	 *       True  EON active
	 * Bit 2..7 False not used
	 *          True  not used
	 */
	unsigned char TAMessageInfo;

	clTAMessageStatus();
	virtual ~clTAMessageStatus();
	/**
	 * serialize the data stream
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the data stream
	 */
	short u16GetSize();
	/**
	 * construct the data stream
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * read TAMessageStatus parameters
	 */
	unsigned char getTAMessageInfo();
	bool bIsTAOn();
	bool bIsEONTAOn();

};
#endif // !defined(EA_E679F63C_71BC_449b_876C_3F9FDE8FEEBE__INCLUDED_)
