///////////////////////////////////////////////////////////
//  clNotificationSet.h
//  Implementation of the Class clNotificationSet
//  Created on:      10-Feb-2015 3:50:02 PM
///////////////////////////////////////////////////////////

#if !defined(EA_671E52B2_C100_456a_9539_8D3AD6D8028E__INCLUDED_)
#define EA_671E52B2_C100_456a_9539_8D3AD6D8028E__INCLUDED_

#include "clADRMsgPayload.h"
#include "clByteConverter.h"
#include "types/clCMEnumTypes.h"

class clNotificationSet : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clNotificationSet();
	/**
	 * Destructor
	 */
	virtual ~clNotificationSet();
	/**
	 * Enumeration 0..3
	 */
	clCMEnum_Control Control;
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short ClientID;
	/**
	 * Stream 0..n
	 * FktID1, FktID2, ... FktIDn
	 */
	tunerVector<unsigned short> FktIDList;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set Fkt Ids
	 */
	void setFktIDs(tunerVector<unsigned short> newListFktIDs);
	/**
	 * Set Client Id
	 */
	void setClientID(unsigned short newClientID);
	/**
	 * Set Control
	 */
	void setControl(clCMEnum_Control::enControl newControl);

};
#endif // !defined(EA_671E52B2_C100_456a_9539_8D3AD6D8028E__INCLUDED_)
