///////////////////////////////////////////////////////////
//  clCMVersionInfoStatus.cpp
//  Implementation of the Class clCMVersionInfoStatus
//  Created on:      05-Feb-2015 10:01:58 AM
///////////////////////////////////////////////////////////

#include "clCMVersionInfoStatus.h"

clCMVersionInfoStatus::clCMVersionInfoStatus()
{

}

clCMVersionInfoStatus::clCMVersionInfoStatus(tunerString newSWVersion, tunerString newHWVersion)
{
	unsigned short stringSize = (unsigned short)newSWVersion.size();

	if (newSWVersion.size() > VERSIONINFO_LEN)
	{
		stringSize = VERSIONINFO_LEN;
	}
	tunerString oSWString(newSWVersion.c_str(), stringSize);
	SoftwareVersion = oSWString;

	stringSize = (unsigned short)newHWVersion.size();
	if (newHWVersion.size() > VERSIONINFO_LEN)
	{
		stringSize = VERSIONINFO_LEN;
	}
	tunerString oHWString(newHWVersion.c_str(), stringSize);
	HardwareVersion = oHWString;
}

clCMVersionInfoStatus::~clCMVersionInfoStatus(){

}

tunerVector<unsigned char> clCMVersionInfoStatus::oSerialize()
{
	tunerVector<unsigned char> payloadData;
	return payloadData;
}

short clCMVersionInfoStatus::u16GetSize()
{
	return 0;
}

void clCMVersionInfoStatus::vConstruct(tunerVector<unsigned char> bitStream)
{
	unsigned short index = 0;

	tunerString oSoftwareVersionString ((const char *)&(bitStream[index]), VERSIONINFO_LEN);
	SoftwareVersion = oSoftwareVersionString;
	index =(unsigned short)(index + VERSIONINFO_LEN);
	
	tunerString oHardwareVersionString ((const char *)&(bitStream[index]), VERSIONINFO_LEN);
	HardwareVersion = oHardwareVersionString;
	index =(unsigned short)(index + VERSIONINFO_LEN);
}

const char* clCMVersionInfoStatus::getSoftwareVersion() const
{
	return SoftwareVersion.c_str();
}

const char* clCMVersionInfoStatus::getHardwareVersion() const
{
	return HardwareVersion.c_str();
}

void clCMVersionInfoStatus::setSoftwareVersion(tunerString newSWVersion)
{
	unsigned short stringSize = (unsigned short)newSWVersion.size();

	if (newSWVersion.size() > VERSIONINFO_LEN)
	{
		stringSize = VERSIONINFO_LEN;
	}
	tunerString oString(newSWVersion.c_str(), stringSize);
	SoftwareVersion = oString;
}
void clCMVersionInfoStatus::setHardwareVersion(tunerString newHWVersion)
{
	unsigned short stringSize = (unsigned short)newHWVersion.size();

	if (newHWVersion.size() > VERSIONINFO_LEN)
	{
		stringSize = VERSIONINFO_LEN;
	}
	tunerString oString(newHWVersion.c_str(), stringSize);
	HardwareVersion = oString;
}