///////////////////////////////////////////////////////////
//  clCMTuningActionConfigurationStatus.cpp
//  Implementation of the Class clCMTuningActionConfigurationStatus
//  Created on:      08-Apr-2015 2:55:26 PM
///////////////////////////////////////////////////////////

#include "clCMTuningActionConfigurationStatus.h"

#define ZERO                        0
#define NUMBEROFSEEKPERIODS         1
#define SCANTIME                    2
#define AFBESTDELAYTIME             3
#define TPSEEKSTRATEGY              4
#define PTYFILTER                   5
#define TUNINGSWITCHES              6
#define AUTOSEEKSTEPDELAY           7
#define MANUALSTEPDELAY             8
#define WRONGPISTEPDELAY            9
#define NONRDSDETECTIONTIMER       10
#define TPSEEKAFTERRDSLOSTTIMER    11
#define AMSTATIONINLISTREMOVETIMER 12
#define SCROLLINGPSDETECTIONTIMER  13
#define ALL                         0

clCMTuningActionConfigurationStatus::clCMTuningActionConfigurationStatus(){

}

clCMTuningActionConfigurationStatus::~clCMTuningActionConfigurationStatus(){

}

tunerVector<unsigned char> clCMTuningActionConfigurationStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

void clCMTuningActionConfigurationStatus::setData(clCMADRBaseType_TuningActionConfigurationData newData){

	Data = newData;
}

void clCMTuningActionConfigurationStatus::setPosition(clCMADRBaseType_Pos newPos){

	Pos = newPos;
}

short clCMTuningActionConfigurationStatus::u16GetSize(){

	return 0;
}

void clCMTuningActionConfigurationStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short pos = 0;

	Pos.x = bitStream[pos++];
	Pos.y = bitStream[pos++];

	if(bConstructAllElements(Pos.x, Pos.y))
	{
		ConstructNumberOfSeekPeriods(pos, bitStream, Pos.x);
		ConstructScantime(pos, bitStream, Pos.x);
		ConstructAfBestDelayTime(pos, bitStream, Pos.x);
		ConstructTPSeekStrategy(pos, bitStream, Pos.x);
		ConstructPtyFilter(pos, bitStream, Pos.x);
		ConstructTuningSwitches(pos, bitStream, Pos.x);
		ConstructAutoSeekStepDelay(pos, bitStream, Pos.x);
		ConstructManualStepDelay(pos, bitStream, Pos.x);
		ConstructWrongPiAcceptDelay(pos, bitStream, Pos.x);
		ConstructNONRDSdetectionTimer(pos, bitStream, Pos.x);
		ConstructTPSeekAfterRDSlostTimer(pos, bitStream, Pos.x);
		ConstructAMStationInListRemoveTimer(pos, bitStream, Pos.x);
		ConstructScrollingPSdetectionTimer(pos, bitStream, Pos.x);
	}
	else
	{
		ConstrcutIndividualParameters(pos, Pos.x, Pos.y, bitStream);
	}
}

bool clCMTuningActionConfigurationStatus::bConstructAllElements(unsigned char x, unsigned char y)
{
	if(x == ALL && y == ZERO)
	{
		return true;
	}
	else
	{
		return false;
	}
}

void clCMTuningActionConfigurationStatus::ConstructNumberOfSeekPeriods(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == NUMBEROFSEEKPERIODS || xPos == ALL){
		Data.NumberOfSeekPeriods = bitStream[pos++];
	}
}
void clCMTuningActionConfigurationStatus::ConstructScantime(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == SCANTIME || xPos == ALL){
		Data.Scantime = bitStream[pos++];
	}
}
void clCMTuningActionConfigurationStatus::ConstructAfBestDelayTime(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == AFBESTDELAYTIME || xPos == ALL){
		Data.AfBestDelayTime = bitStream[pos++];
	}
}
void clCMTuningActionConfigurationStatus::ConstructTPSeekStrategy(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == TPSEEKSTRATEGY || xPos == ALL){
		Data.TPSeekStrategy.enType = static_cast<clCMEnum_TPSeekStrategy::enTPSeekStrategy>(bitStream[pos++]);
	}
}
void clCMTuningActionConfigurationStatus::ConstructPtyFilter(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == PTYFILTER || xPos == ALL){
		Data.PtyFilter = getInt(bitStream, pos);
		pos =(unsigned short)(pos + sizeof(Data.PtyFilter));
	}
}
void clCMTuningActionConfigurationStatus::ConstructTuningSwitches(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == TUNINGSWITCHES || xPos == ALL){
		Data.TuningSwitches = bitStream[pos++];
	}
}
void clCMTuningActionConfigurationStatus::ConstructAutoSeekStepDelay(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == AUTOSEEKSTEPDELAY || xPos == ALL){
		Data.AutoSeekStepDelay = getWord(bitStream[pos + 1], bitStream[pos]);
		pos =(unsigned short)(pos + sizeof(Data.AutoSeekStepDelay));
	}
}
void clCMTuningActionConfigurationStatus::ConstructManualStepDelay(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == MANUALSTEPDELAY || xPos == ALL){
		Data.ManualStepDelay = getWord(bitStream[pos + 1], bitStream[pos]);
		pos =(unsigned short)(pos + sizeof(Data.ManualStepDelay));
	}
}
void clCMTuningActionConfigurationStatus::ConstructWrongPiAcceptDelay(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == WRONGPISTEPDELAY || xPos == ALL){
		Data.WrongPiAcceptDelay = bitStream[pos++];
	}
}
void clCMTuningActionConfigurationStatus::ConstructNONRDSdetectionTimer(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == NONRDSDETECTIONTIMER || xPos == ALL){
		Data.NONRDSdetectionTimer = bitStream[pos++];
	}
}
void clCMTuningActionConfigurationStatus::ConstructTPSeekAfterRDSlostTimer(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == TPSEEKAFTERRDSLOSTTIMER || xPos == ALL){
		Data.TPSeekAfterRDSlostTimer = bitStream[pos++];
	}
}
void clCMTuningActionConfigurationStatus::ConstructAMStationInListRemoveTimer(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == AMSTATIONINLISTREMOVETIMER || xPos == ALL){
		Data.AMStationInListRemoveTimer = bitStream[pos++];
	}
}
void clCMTuningActionConfigurationStatus::ConstructScrollingPSdetectionTimer(unsigned short &pos, tunerVector<unsigned char> bitStream, unsigned char xPos){

	if(xPos == SCROLLINGPSDETECTIONTIMER || xPos == ALL){
		Data.ScrollingPSdetectionTimer = bitStream[pos++];
	}
}

void clCMTuningActionConfigurationStatus::ConstrcutIndividualParameters(unsigned short &pos, unsigned char x, unsigned char y, tunerVector<unsigned char> bitStream)
{
	if(y == ZERO)
	{
		ConstructNumberOfSeekPeriods(pos, bitStream, x);
		ConstructScantime(pos, bitStream, x);
		ConstructAfBestDelayTime(pos, bitStream, x);
		ConstructTPSeekStrategy(pos, bitStream, x);
		ConstructPtyFilter(pos, bitStream, x);
		ConstructTuningSwitches(pos, bitStream, x);
		ConstructAutoSeekStepDelay(pos, bitStream, x);
		ConstructManualStepDelay(pos, bitStream, x);
		ConstructWrongPiAcceptDelay(pos, bitStream, x);
		ConstructNONRDSdetectionTimer(pos, bitStream, x);
		ConstructTPSeekAfterRDSlostTimer(pos, bitStream, x);
		ConstructAMStationInListRemoveTimer(pos, bitStream, x);
		ConstructScrollingPSdetectionTimer(pos, bitStream, x);
	}
}
